########################## -*- Mode: Perl -*- ##########################
##
## File             : Lattice.pm
##
## Description      : Lattice of attributes
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : Thu Feb 15 14:37:11 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Mon Nov 11 13:31:36 1996
##
## $State: Exp $
##
## $Id: Lattice.pm,v 5.1.1.1 1996/12/23 12:48:10 goevert Exp goevert $
##
## $Log: Lattice.pm,v $
## Revision 5.1.1.1  1996/12/23 12:48:10  goevert
## patch6: no Exporter required any longer
##
## Revision 5.1  1996/11/05 16:54:45  goevert
## *** empty log message ***
##
## Revision 5.0.1.3  1996/07/03 13:27:10  goevert
## patch19: case: no form file
##
## Revision 5.0.1.2  1996/05/13 11:25:37  goevert
## patch1:
##
########################################################################


use strict;


package SFgate::Attributes::Lattice;


sub new
{
    my $class = shift;
    my $self  = {};
    bless $self, $class;

    $self->initialize(@_);

    return $self;
}


sub initialize
{
    my $self = shift;

    local($_) = @_;
    ## local variables
    my(@stack, $last, $last_depth, $depth, , $diff, %predecessor, %successors);
    
    open(LATTICE, "< $_")
        || die "Couldn't open $_: $!\n";

    $_ = <LATTICE>;
    chop;
    s/^( +)//;
    push(@stack, $_);
    $last = $_;
    $self->{'TOP'} = $_;
    $last_depth = 0;
    
    while (<LATTICE>) {

        s/\s+$//;
        s/^( +)//;
        $depth = length($1);

        if ($depth > $last_depth) {
            push(@stack, $last) if $last;
        }
        elsif ($depth < $last_depth) {
            $diff = ($last_depth - $depth) / 2;
            for (1 .. $diff) {
                pop(@stack);
            }
        }

        if (@stack) {
            push(@{$successors{$stack[$#stack]}}, $_);
            $predecessor{$_} = $stack[$#stack];
        }

        $last = $_;
        $last_depth = $depth;
    }

    $self->{'predecessor'} = \%predecessor;
    $self->{'successors'}  = \%successors;
}


sub get_successors
{
    my $self = shift;

    my($attribute) = @_;
    ## local variables
    local($_);
    ## return value
    my(@successors);

    return () if !defined($self->{'successors'}->{$attribute});

    foreach (@{$self->{'successors'}->{$attribute}}) {
        push(@successors, $_);
        @successors = (@successors, $self->get_successors($_));
    }
    
    return @successors;

}


sub get_predecessor
{
    my $self = shift;

    my($attribute) = @_;

    return $self->{'predecessor'}->{$attribute};
}


sub get_top
{
    my $self = shift;

    return $self->{'TOP'};
}


sub is_attribute
{
    my $self = shift;

    my($attribute) = @_;
    
    return $self->{'predecessor'}->{$attribute} || $self->{'successors'}->{$attribute};
}


sub display
{
    my $self = shift;

    $self->print_successors('TOP', '');
}


sub print_successors
{
    my $self = shift;
    
    my($top, $nest) = @_;
    ## local variables
    local($_);
    
    print "$nest$top\n";

    foreach (@{$self->{'successors'}->{$top}}) {
        $self->print_successors($_, "  $nest");
    }
}


1;
