%start C
%start CE
%start Q
%start I
%start F
%start A
%{
/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */
#include "commands.h"
#include "protos.h"
#include "conf.h"
int	cmd;
char	*quote;

int	OldPh = 0;		/* is user using an old version of ph? */

#define OLD		OldPh=1
#define INCREMENT	80
#define UNREASONABLE	8192
extern FILE *Input;
extern FILE *Output;

#undef input
#undef unput
#undef output

static int TC;


/*
 * input/output with backup and a record of the last command
 */
char	CommandText[UNREASONABLE];
char	*CommandSpot = CommandText;

#define RESET	CommandSpot = CommandText
#define input()		(((TC=GetAC(Input))==EOF)?0:(*CommandSpot++ = TC))
#define unput(c)	CommandSpot--,ungetc(c,Input)
#define output(c)	putc(c,Output)
%}
%%
	BEGIN I;				/* start state */
<I>query	{AddValue((char *)yytext,COMMAND); cmd = C_QUERY; BEGIN C;}
<I>ph		{AddValue((char *)yytext,COMMAND); cmd = C_QUERY; BEGIN C;}
<I>change	{AddValue((char *)yytext,COMMAND); cmd = C_CHANGE; BEGIN C;}
<I>login	{AddValue((char *)yytext,COMMAND); cmd = C_LOGIN; BEGIN C;}
<I>answer	{AddValue((char *)yytext,COMMAND); cmd = C_ANSWER; BEGIN A;}
<I>email	{AddValue((char *)yytext,COMMAND); cmd = C_EMAIL; BEGIN C;}
<I>clear	{AddValue((char *)yytext,COMMAND); cmd = C_CLEAR; BEGIN C;}
<I>logout	{AddValue((char *)yytext,COMMAND); cmd = C_LOGOUT; BEGIN C;}
<I>fields	{AddValue((char *)yytext,COMMAND); cmd = C_FIELDS; BEGIN C;}
<I>add		{AddValue((char *)yytext,COMMAND); cmd = C_ADD; BEGIN C;}
<I>delete	{AddValue((char *)yytext,COMMAND); cmd = C_DELETE; BEGIN C;}
<I>set		{AddValue((char *)yytext,COMMAND); cmd = C_SET; BEGIN C;}
<I>quit		{AddValue((char *)yytext,COMMAND); cmd = C_QUIT; BEGIN C;}
<I>stop		{AddValue((char *)yytext,COMMAND); cmd = C_QUIT; BEGIN C;}
<I>exit		{AddValue((char *)yytext,COMMAND); cmd = C_QUIT; BEGIN C;}
<I>status	{AddValue((char *)yytext,COMMAND); cmd = C_STATUS; BEGIN C;}
<I>help		{AddValue((char *)yytext,COMMAND); cmd = C_HELP; BEGIN C;}
<I>id		{AddValue((char *)yytext,COMMAND); cmd = C_ID; BEGIN C;}
<I>siteinfo	{AddValue((char *)yytext,COMMAND); cmd = C_INFO; BEGIN C;}

<I>interactive\ncsnet\nversion\n\t3.0\nwhois\n	{OLD;RESET;}

<I>exact\n	{AddValue("query",COMMAND); CommandSpot--; cmd = C_QUERY; BEGIN C;}
<I>[ \t]+	;				/* ignore whitespace */
<I>[^ \377\t\n]+	{Unknown((char *)yytext);BEGIN F;}	/* extraneous junk */
<I,F>\n		return(-1);			/* no command */
<I>'#'		{BEGIN F;}

<F>.		;				/* just toss it all */

<A>[ \t]	;
<A>[^ \t\n]+	{AddValue((char *)yytext,VALUE);}
<A>\n		{DoCommand(cmd); RESET; return(cmd);}
<C>return	{AddValue("return",RETURN);}	/* make , return, and */
<C>force	{AddValue("force",RETURN);}	/* force all serve */
<C>make		{AddValue("make",RETURN);}	/* the same function */
<C,CE>\"	{CollectQuote(0,0); BEGIN Q;}	/* begin a quoted value */
<C,CE>[ \t]	{BEGIN C;}			/* ignore whitespace */
<C,CE>\\\n	{BEGIN C;}			/* ignore escaped newlines */
<C>[^ \"\n\t=~]+	{AddValue((char *)yytext,VALUE);}		/* a single value */
<CE>[^ \"\n\t]+	{AddValue((char *)yytext,VALUE); BEGIN C;}	/* value after = */
<C>=		{AddValue("=",EQUAL);BEGIN CE;}	/* the equal sign */
<C>~		{AddValue("~",EQUAL|TILD_E);BEGIN CE;}	/* the tilde */
<C,CE>\n	{DoCommand(cmd); RESET; return(cmd);}/* execute */

<Q>[^\\\"]+	CollectQuote((char *)yytext,yyleng);	/* copy any char but quote */
<Q>\\\"		CollectQuote("\"",1);		/* copy an escaped quote */
<Q>\\\\		CollectQuote("\\",1);		/* copy an escaped backslash */
<Q>\\n		CollectQuote("\n",1);		/* C newline */
<Q>\\t		CollectQuote("\t",1);		/* C tab */
<Q>\"		{AddValue(quote,VALUE); BEGIN C;}	/* enter the quoted value */

\377.		;	/* ignore telnet commands; refuse telnet options */
\377\373.	{fprintf(Output,"\377\376%c",(unsigned char) yytext[2]);}
\377\375.	{fprintf(Output,"\377\374%c",(unsigned char) yytext[2]);}
\\		;				/* ignore other backslashes */

%%
void
CollectQuote(text, len)
	char	*text;
	int	len;
{
	static char *endt;
	static int size = 0;
	static int cnt = 0;

	if (text == NULL)
	{
		if (quote)
		{
			free(quote);
			quote = 0;
			size = 0;
			cnt = 0;
		}
	} else
	{
		if (cnt + len >= size && cnt + len < UNREASONABLE)
		{
			if (!quote)
			{
				endt = quote = malloc(len + INCREMENT);
				size = len + INCREMENT;
				cnt = 0;
			} else
			{
				size = cnt + len + INCREMENT;
				quote = realloc(quote, size);
				endt = quote + cnt;
			}
		}
		strcpy(endt, text);
		endt += len;
		cnt += len;
	}
}

/*
 * get a non-null, non-return character
 */
int 
GetAC(fp)
	FILE *fp;
{
	int	c;

	do
	{
		c = getc(fp);
	}
	while (c == '\r' || c == '\0');

	return (c);
}
