#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

static QDIR MakeADir __P((ARG *));
static int ValidAdd __P((ARG *));

/*
 * Do an add command
 */
void 
DoAdd(args)
	ARG *args;
{
	long	entry;
	QDIR	dir;

	if (!AmHero && !User)
		DoReply(LR_NOTLOG, "You must be logged in to use this command.");
	else if (!CanAddEntries())
	{
		IssueMessage(LOG_INFO, "%s:not authorized for add.", UserAlias);
		DoReply(LR_ADD, "You may not add NameServer entries.");
	} else if (!GonnaWrite())
		/* GonnaWrite will issue an error message */ ;
	else if (!ValidAdd(args))
		DoReply(LR_SYNTAX, "Add command not understood.");
	else
	{
		dir = MakeADir(args->aNext);
		entry = new_ent();
		if (!putdata(dir))
		{
			IssueMessage(LOG_WARNING, "DoAdd putdata failed.");
			DoReply(LR_TEMP, "Store failed.");
			goto done;
		}
		MakeLookup(dir, entry, make_lookup);
		set_date(0);
		store_ent();
		DoReply(LR_OK, "Ok.");
	      done:
		Unlock();
		FreeDir(&dir);
	}
}

/*
 * Make a dir entry from an argument list
 */
static QDIR 
MakeADir(args)
	ARG *args;
{
	QDIR	dir;

	dir = (QDIR) malloc(sizeof (char *));

	*dir = NULL;

	for (; args; args = args->aNext)
	{
		if (strcmp(args->aSecond, "none"))
			if (!ChangeDir(&dir, args->aFD, args->aSecond))
				IssueMessage(LOG_WARNING, "MakeADir ChangeDir failed.");
	}
	return (dir);
}

/*
 * validate an argument list for an add command
 */
static int 
ValidAdd(args)
	ARG *args;
{
	int	isBad = 0;
	int	count = 0;
	int	reason = 0;

	for (args = args->aNext; args; args = args->aNext)
	{
		count++;
		if (args->aType != (VALUE | EQUAL | VALUE2))
		{
			isBad = 1;
			DoReply(-LR_SYNTAX, "%d:argument is not field=value pair.", count);
		} else if ((args->aFD = FindFD(args->aFirst)) == NULL)
		{
			isBad = 1;
			DoReply(-LR_FIELD, "%d:unknown field.");
		} else if (!strcmp(args->aSecond, "none"))
		{
			isBad = 1;
			DoReply(-LR_SYNTAX, "``None'' not allowed on add.");
		} else if (args->aFD->fdId == F_ALIAS)
		{
			if (reason = BadAlias(args->aSecond))
			{
				switch (reason)
				{
				    case 1:
					DoReply(-LR_VALUE, "Alias is too long or too short.");
					break;
				    case 2:
					DoReply(-LR_VALUE, "Only alphanumerics and ``-'' are allowed in aliases.");
					break;
				    default:
					DoReply(-LR_VALUE, "Alias is bad.");
					break;
				}
				isBad = 1;
				continue;
			} else if (AliasIsUsed(args->aSecond, 0))
			{
				DoReply(-LR_ALIAS, "Alias %s in use or is too common a name.",
					args->aSecond);
				isBad = 1;
				continue;
			}
		}
#ifdef PRE_ENCRYPT
		else if (args->aFD->fdId == F_PASSWORD)
		{
			char	pwCrypt[14];

			strncpy(pwCrypt, crypt(args->aSecond, args->aSecond), 13);
			pwCrypt[13] = 0;
			free(args->aSecond);
			args->aSecond = make_str(pwCrypt);
		}
#endif
	}

	return (!isBad);
}
