######################### -*- Mode: Perl -*- #########################
##
## File          : Makefile.PL
##
## Description   : 
##
## Author        : Ulrich Pfeifer
## Created On    : Sun Sep 10 11:00:44 1995
##
## Last Modified : Time-stamp: <1998-07-26 16:39:34 goevert>
##
## $Id: Makefile.PL 1.9 Fri, 20 Oct 2000 13:07:37 +0200 goevert $
##
## $ProjectHeader: Wais 23.16 Fri, 20 Oct 2000 13:07:37 +0200 goevert $
######################################################################


use strict;

use ExtUtils::MakeMaker;
use Config;

require 5.6.0;


## find waisindex and waisserver binaries, wais.h and libwais.a
my @paths;
foreach (split ':', $ENV{PATH}) {
  push @paths, $_ if -x "$_/waisserver" and -x "$_/waisindex";
}
my($ld, $cpp);
die "Couldn't find `waisserver' or `waisindex' or both in your PATH.\n" unless @paths;
foreach (@paths) {
  s!/bin$!/lib!;
  next unless -r $_ . '/libwais.a' and -r $_ . '/wais.h';
  $ld  = "-L$_";
  $cpp = "-I$_";
  last;
}


&WriteMakefile
  ( PREREQ_PM    => { Curses     => 0,
                     },
    LIBS         => "$ld $Config{ldflags} -lwais",
    INC          => "-DWAIS_USES_STDIO $cpp $Config{cppflags}",
    NAME         => 'Wais',
    VERSION_FROM => 'lib/Wais.pm',
    DEFINE       => '-DTRACE=0',
    OBJECT       => "Wais.o HTWAIS.o dictionary.o",
    dist         => { SUFFIX   => 'gz',
                      COMPRESS => 'gzip -9f',
                      PREOP    => 'pod2text lib/Wais.pm > README; pod2text INSTALL.pod > INSTALL',
                     },
    MAP_TARGET   => 'waisperl',
    EXE_FILES    => [ qw(script/inspect script/makedb) ],
  );


## ###################################################################
## subs
## ###################################################################

sub MY::postamble {
  
  my $self = shift;

  q[
ftpdist: dist
	rm -f /home-local/ftp/pub/src/Perl/$(DISTNAME)-*.tar.$(SUFFIX)
	mv $(DISTVNAME).tar.$(SUFFIX) /home-local/ftp/pub/src/Perl
]
    .
  qq[

install :: register

register ::
\t] . $self->{NOECHO} . q[$(PERL) -I$(PERL_ARCHLIB) -I$(PERL_LIB) \
-e '    use Wais; ' \
-e '    use Config; ' \
-e '    eval "use Sys::Hostname; \\$$host = q[on ].hostname;";' \
-e '    $$address="waispm\@ls6.cs.uni-dortmund.de";'	\
-e '    print "Send registration mail to $$address (y/n)? ";'	\
-e '    $$answer = <STDIN>;' 	\
-e '    if ($$answer !~ /^n/i) {'	\
-e '        exec "perlbug", "-a", $$address, "-C",'	\
-e '        "-s", "Installed Wais extension $$Wais::VERSION $$host$$Config{mydomain}";'	\
-e '    } else {'	\
-e '        print "Ok ... I will keep your secret!\n";'	\
-e '    }'
]
}
