#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

#include <sys/param.h>

/*
 * give the user some help
 */
void 
DoHelp(argp)
	ARG *argp;
{
	char	*me;
	char	*client;
	int	foundOne = 0;
	int	ix = 1;
	char	*topic;

	argp = argp->aNext;	/* skip the command name */

	if (!argp)		/* no client specified */
	{
		DoReply(-LR_OK, "%d: The following clients have help:", ix);
		foundOne = HelpText(ix, 0, 0);
	} else
	{
		client = argp->aFirst;
		if (index(client, '/'))
			DoReply(-LR_BADHELP, "Valid help clients don't contain /'s.");
		else
			do
			{
				argp = argp->aNext;
				topic = argp ? argp->aFirst : NULL;
				if (topic && index(topic, '/'))
				{
					DoReply(-LR_BADHELP, "%d:%s: Valid help topics don't contain /'s.", ix, topic);
					continue;
				}
				if (topic)
					DoReply(-LR_OK, "%d:%s: ", ix, topic);
				else
					DoReply(-LR_OK, "%d: These ``%s'' help topics are available:", ix, client);
				if (HelpText(ix, client, topic) || HelpText(ix, NATIVESUBDIR, topic))
					foundOne = 1;
				else if (!HelpText(ix, client, NOHELP))
					HelpText(ix, NATIVESUBDIR, NOHELP);
				ix++;
			}
			while (argp && argp->aNext);
	}
	if (foundOne)
		DoReply(LR_OK, "Ok.");
	else
		DoReply(LR_ERROR, "No help available.");
}

/*
 * give the user a specific help file
 */
int 
HelpText(ix, client, topic)
	int ix;
	char *client, *topic;
{
	FILE	*helpFile;
	char	buffer[MAXPATHLEN];
	char	*ep;
	int	code;

	if (!topic)
	{
		code = ListTopics(ix, client);
		if (code)
		{
			if (client && !strcmp(client, NATIVESUBDIR))
				DoReply(-LR_OK, "%d: To view one of these topics, type ``help %s name-of-topic-you-want''.", ix, NATIVESUBDIR);
			else
				DoReply(-LR_OK, "%d: To view one of these topics, type ``help name-of-topic-you-want''.", ix);
		}
		if (!code || client && strcmp(client, NATIVESUBDIR))
		{
			DoReply(-LR_OK, "%d: These ``%s'' help topics are also available:", ++ix, NATIVESUBDIR);
			ListTopics(ix, NATIVESUBDIR);
			DoReply(-LR_OK, "%d: To view one of these topics, type ``help %s name-of-topic-you-want''.", ix, NATIVESUBDIR);
		}
		return (code);
	} else
	{
		(void) sprintf(buffer, "%s/%s/%s", HELPDIR, client, topic);
		if ((helpFile = fopen(buffer, "r")) == NULL)
			return (0);
		HelpCopy(ix, helpFile);
		(void) fclose(helpFile);
		return (1);
	}
}

/*
 * list the help topics available
 */
int 
ListTopics(indx, client)
	int indx;
	char *client;
{
	char	buffer[MAXPATHLEN];
	FILE	*ls;

	if (client)
		(void) sprintf(buffer, "ls -C %s/%s|expand", HELPDIR, client);
	else
		(void) sprintf(buffer, "ls -C %s|expand", HELPDIR);

	if ((ls = popen(buffer, "r")) == NULL)
		return (0);

	HelpCopy(indx, ls);

	(void) pclose(ls);
	return (1);
}

/*
 * copy help lines from a file pointer to the output
 */
int 
HelpCopy(indx, helpFile)
	int indx;
	FILE *helpFile;
{
	char	buffer[256];
	char	*ep;

	while (fgets(buffer, sizeof (buffer), helpFile))
	{
		ep = buffer + strlen(buffer) - 1;
		if (*ep == '\n')
			*ep = 0;
		DoReply(-LR_OK, "%d: %s", indx, buffer);
	}
}
