#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

/*
 * maked -- make a dir file for the nameserver
 */

extern int DontLog;		/* qi/qi.c */
extern int IndicateAlways;	/* qi/query.c */

#define BUF_SIZE    4096
#define DIR_MAX	    80
static char *Me;		/* the name of this program */

main(argc, argv)
	int	argc;
	char	**argv;

{
	char	buffer[BUF_SIZE];
	QDIR	dirp;
	int	count;
	int	Quiet = 0;

	/* when you're strange, no one remembers your name */
	Me = *argv;

	DontLog = 1;
	IndicateAlways = 0;	/* somebody wants this */
	dirp = (char **) malloc(DIR_MAX * sizeof (char *));

	while (--argc > 0 && **(++argv) == '-')
	{
		char *equal, **opt;

		(*argv)++;
		if (**argv == 'q')
			Quiet++;
		else if (equal = index(*argv, '='))
		{
			*equal++ = '\0';
			for (opt = Strings; *opt; opt += 2)
				if (!strcmp(opt[0], *argv))
				{
					opt[1] = equal;
					break;
				}
			if (*opt == '\0')
			{
				fprintf(stderr, "%s: %s: unknown string.\n",
					Me, *argv);
				exit(1);
			}
		} else
		{
			fprintf(stderr, "%s: %s: unknown option.\n", Me, *argv);
			exit(1);
		}
	}
	Database = (argc > 0) ? *argv : DATABASE;
	if (!Quiet)
		fprintf(stderr, "%s: building database %s\n", Me, Database);
	sleep(5);
	DoSysLog(0);		/* report errors to stderr */

	if (!dbd_init(Database))
	{
		fprintf(stderr, "Couldn't init %s.\n", Database);
		exit(2);
	}
	get_dir_head();

	count = 0;
	while (GetLine(buffer) != 0)
	{
		TurnIntoDir(buffer, dirp);

		if (!new_ent())
		{
			perror("new_ent failed");
			exit(1);
		}
		if (!putdata(dirp))
		{
			perror("Putdata");
			abort();
		}
		set_date(0);
		store_ent();
		if (!Quiet && ++count % 500 == 0)
			fprintf(stderr, "%d\r", count, dirp[0]);
	}
	if (!Quiet)
		putc('\n', stderr);
	put_dir_head();
	exit(0);
}

/*
 * get a line of input
 */
GetLine(line)
	char *line;
{
	register int count = 0;
	register int c;
	register int backslash = 0;

	for (c = getchar(); c != EOF && c != '\n'; c = getchar())
	{
		if (backslash)
		{
			if (c == 'n')
				*line++ = '\n';
			else if (c == 't')
				*line++ = ' ';	/* cheating, I know... */
			else
				*line++ = c;
			count++;
			backslash = 0;
		} else if (!(backslash = (c == '\\')))
		{
			*line++ = c;
			count++;
		}
	}
	if (count > BUF_SIZE)
	{
		fprintf(stderr, "Oh no--overflow!\n");
		exit(4);
	}
	if (c == '\n')
		count++;
	*line = 0;
	return (count);
}

/*
 * turn an input line into a dir
 */
TurnIntoDir(line, dirp)
	char	*line;
	char   **dirp;
{
	char	*token;
	char   **origDir = dirp;

	for (token = strtok(line, "\t"); token; token = strtok(0, "\t"))
	{
		if (token[strlen(token) - 1] != ':')
			*dirp++ = token;
	}

	*dirp = 0;
	if (dirp - origDir > DIR_MAX)
	{
		fprintf(stderr, "Oh no--Dir overflow!\n");
		exit(5);
	}
}
