/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

#include <stdio.h>
#include <ndbm.h>
#include <sys/types.h>
#ifdef SYSV
# include <sys/fcntl.h>
#else /* !SYSV */
# include <sys/file.h>
#endif /* SYSV */

static DBM *db;

/*
 * initialize the id database
 */
IdInit(dbName)
	char *dbName;
{
	if ((db = dbm_open(dbName, O_RDWR | O_CREAT, 0660)) == NULL)
		return (1);

	srand(time(0));
	return (0);
}

/*
 * make the database go away
 */
IdDone()
{
	dbm_close(db);
}

/*
 * assign an id number to an UVID
 */
char    *
AssignId(uvid)
	char    *uvid;
{
	datum    key;
	datum    rec;
	int      id;
	static char scratch[40];

	key.dptr = uvid;
	key.dsize = strlen(uvid) + 1;

	rec = dbm_fetch(db, key);
	if (rec.dptr)
		return (NULL);

	rec.dptr = scratch;

	do
	{
		id = rand() + 10000000;
		sprintf(scratch, "%c%d", strncmp(uvid, "000", 3) ? 'i' : 't', id);
		rec.dsize = strlen(scratch) + 1;
	}
	while (dbm_store(db, rec, key, DBM_INSERT) != 0);
	dbm_store(db, key, rec, DBM_INSERT);
	return (scratch);
}

/*
 * given an uvid, find an id, or vice-versa
 */
char    *
FindId(id)
	char    *id;
{
	static datum key, rec;

	key.dptr = id;
	key.dsize = strlen(id) + 1;

	rec = dbm_fetch(db, key);

	return (rec.dptr);
}

/*
 * Dump the database
 */
DumpId()
{
	datum    key, rec;
	char     scratch[256];

	for (key = dbm_firstkey(db); key.dptr; key = dbm_nextkey(db))
	{
		strcpy(scratch, key.dptr);
		key.dptr = scratch;
		rec = dbm_fetch(db, key);
		if (rec.dptr)
			printf("%s:%s\n", key.dptr, rec.dptr);
		else
			printf("%s:not found\n", key.dptr);
	}
}
