#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees, and by CSNET.  No warranties of
 * any kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed without prior consent of CSNET.
 * You may direct questions to nameserv@uiuc.edu
 */

/*LINTLIBRARY*/

#define to_lower(a) (((a)>='A'&&(a)<='Z')?((a)|040):(a))

/*
 * Just like strcmp but case independent.
 */
int 
stricmp(s1, s2)
	char *s1, *s2;
{
	register char c1, c2;

	for (c1 = *s1, c2 = *s2; to_lower(c1) == to_lower(c2); c1 = *s1, c2 = *s2)
	{
		s2++;
		if (*s1++ == '\0')
			return (0);
	}
	return (to_lower(c1) - to_lower(c2));
}

/*
 * Just like strncmp, but case independent.
 */
int 
strincmp(s1, s2, n)
	char *s1, *s2;
	int n;
{

	while (--n >= 0 && to_lower(*s1) == to_lower(*s2))
	{
		s2++;
		if (*s1++ == '\0')
			return (0);
	}
	return (n < 0 ? 0 : to_lower(*s1) - to_lower(*s2));
}

/*
 * Return true iff the given string is a blank line.
 */
int 
blankline(str)
	char *str;
{
	while (isspace(*str))
		str++;
	return ((*str == '\0') ? 1 : 0);
}

/*
 * Get rid of trailing spaces (and newlines and tabs ) as well as
 * beginning ones.  This routine just truncates the line in place.
 */
char *
ltrunc(str)
	char *str;
{
	register char *ptr;

	ptr = str;
	while (*ptr)
		ptr++;
	while (isspace(*--ptr))
		if (ptr < str)
			break;
	ptr[1] = '\0';
	while (isspace(*str))
		str++;
	return (str);
}

/*
 * Return true iff character (c) occurs in the string (list).
 */
int 
any(c, list)
	char c, *list;
{
	while (*list)
	{
		if (c == *list)
			return 1;
		list++;
	}
	return 0;
}

void 
mkargv(argc, argv, line)
	int *argc;
	char **argv, *line;
{
	int	count, instring;
	char	*ptr;

	count = 0;
	instring = 0;
	for (ptr = line; *ptr; ptr++)
	{
		if (isspace(*ptr))
		{
			instring = 0;
			*ptr = '\0';
		} else if (!instring)
		{
			argv[count++] = ptr;
			instring = 1;
		}
	}
	argv[count] = 0;
	*argc = count;
}


/*
 * true iff the argument is a null or whitespace filled string
 */
int 
isblank(str)
	char *str;
{
	while (*str && isspace(*str))
		str++;
	return (*str == '\0');
}

/*
 * Just like strcat, except return a ptr to the null byte at the end of
 * cat'ed string.
 */
char *
strecat(s1, s2)
	char *s1, *s2;
{
	while (*s1)
		s1++;
	while (*s1++ = *s2++)
		;
	return (--s1);
}

/*
 * Just like strcpy, except return a ptr to the null byte at the end of
 * cpy'ed string.
 */
char *
strecpy(s1, s2)
	char *s1, *s2;
{
	while (*s1++ = *s2++)
		;
	return (--s1);
}

/*
 * is one string a subset of another?
 */
int 
issub(string, sub)
	char *string, *sub;
{
	int	len;

	len = strlen(sub);
	for (; *string; string++)
		if (!strncmp(string, sub, len))
			return (1);
	return (0);
}

/*
 * copy a string, return the # of chars copied
 */
int 
strcpc(to, from)
	char *to, *from;
{
	char	*old;

	old = to;
	while (*to++ = *from++) ;

	return (to - old - 1);
}

/*
 * count the occurrences of a character in a string
 */
int 
countc(string, c)
	char *string, c;
{
	register int count;

	count = 0;

	while (*string)
		if (*string++ == c)
			count++;

	return (count);
}

/*
 * concatenate strings, handling escaped newlines and tabs
 */
int 
strcate(to, from)
	char *to, *from;
{
	int	escaped;
	char	*orig;

	while (*to)
		to++;
	orig = to;

	for (escaped = 0; *from; from++)
	{
		if (escaped)
		{
			switch (*from)
			{
			case 'n':
				*to++ = '\n';
				break;
			case 't':
				*to++ = '\t';
				break;
			default:
				*to++ = *from;
				break;
			}
			escaped = 0;
		} else if (!(escaped = (*from == '\\')))
			*to++ = *from;
	}
	*to = '\0';
	return (to - orig);
}

/*
 * Make a string of control chars legible
 */
char *
Visible(s, n)
	char *s;
	int n;
{
	static char scratch[4096];
	char	*Spot;
	unsigned char c;
	static char hexDigit[] =
	{'0', '1', '2', '3', '4', '5', '6', '7',
	 '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
	int	wasHex = 0;

	for (Spot = scratch; n--; s++)
	{
		c = *((unsigned char *) s);
		if (c > 127)
		{
			if (!wasHex)
				*Spot++ = '<';
			*Spot++ = hexDigit[(c >> 4) & 0xf];
			*Spot++ = hexDigit[c & 0xf];
			wasHex = 1;
		} else
		{
			if (wasHex)
				*Spot++ = '>';
			wasHex = 0;
			if (c == '^')
			{
				*Spot++ = '\\';
				*Spot++ = c;
			} else if (' ' <= c && c <= '~')
				*Spot++ = c;
			else if (c == 127)
			{
				*Spot++ = '^';
				*Spot++ = '?';
			} else
			{
				*Spot++ = '^';
				*Spot++ = c + '@';
			}
		}
	}
	if (wasHex)
		*Spot++ = '>';
	*Spot = 0;
	return (scratch);
}

/*
 * is a string all metacharacters?
 */
int 
AllMeta(s)
	char *s;
{
	for (; *s; s++)
		if (!any(*s, "[]?*"))
			return (0);
	return (1);
}

/*
 * copy a string, converting to lower case
 */
char *
strlcpy(to, from)
	char *to, *from;
{
	char	*save = to;

	while (*to++ = isupper(*from) ? tolower(*from) : *from)
		from++;

	return (save);
}


/*
 * Remove special characters from a string
 */
int 
RemoveSpecials(str)
	char *str;
{
	for (; *str; str++)
		if (index("()$&<>|;/`", *str))
			*str = ' ';
}
