/* xph.c -- an X-based phonebook program for the CSO Nameserver.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Mon Apr 27 16:59:42 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/AsciiSrcP.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

#include "replies.h"
#include "resource.h"
#include "global.h"

#ifndef lint
static char version[] = "$$Version xph 2.4 beta, (C) 1992 Bradley C. Spatz";
#endif

#include "xph.icon"

#define DEFAULT_SERVER  "eng.ufl.edu"
#define DEFAULT_SERVICE "ns"


/* Provide a Pixmap for our icon. */
Pixmap icon_pixmap;


/* Prototype this horrendous hack.  See XawAsciiAppend(). */
extern XawTextPosition (*TextSrcScanProc)();


/* Prototype some callbacks. */
extern void send_query(), return_send_query(), clear_query();
extern void clear_output(), do_change(), do_fullpage(), about_xph(), do_help();
extern void change_password(), field_info(), do_logout(), site_info();
void usage(), attach_icon(), create_widgets(), create_dialog();
void create_options(), quit();


/* Describe the default resources and behavior. */
String fallback_resources[] = {
   "*allowShellResize:    true"
};


/* This allows RETURN in the query dialog to equal the send button. */
XtActionsRec actionTable[] = {
    {"return_send_query",	return_send_query},
    {"busy_cursor",	        busy_cursor}
};


/* Create a struct to hold our own resources. */
xph_res_t xphres;
static XtResource Resources[] = {
   {"alias", "AliasName", XtRString, sizeof(String), offset(alias),
       XtRString, ""},
   {"server", "ServerName", XtRString, sizeof(String), offset(server),
       XtRString, DEFAULT_SERVER},
   {"service", "ServiceName", XtRString, sizeof(String), offset(service),
       XtRString, DEFAULT_SERVICE}
};


/* Ask Xt to parse the following command line arguments, if they exist. */
static XrmOptionDescRec options[] = {
{"-alias",	"*alias",	XrmoptionSepArg,	NULL},
{"-server",	"*server",	XrmoptionSepArg,	NULL},
{"-service",	"*service",	XrmoptionSepArg,	NULL}
};


/* Some global variables for convenience. */
Widget toplevel;
Widget text;
char login_alias[128];
int read_only=0;

main(argc, argv)
int argc;
char **argv;
{
   XtAppContext app_con;

#ifdef DEBUG
   malloc_debug(2);
#endif

   toplevel = XtAppInitialize(&app_con, "Xph", options, XtNumber(options),
			       &argc, argv, NULL, NULL, ZERO);
   XtVaSetValues(toplevel, XtNtitle, "Xph", NULL);

   /* Check to see that all arguments were processed, and if not then
    * report an error and exit.
    */
   if (argc != 1)		
      usage(app_con, argv[0]);

   /* Initialize this baby for the hack described in XawAsciiAppend(). */
   TextSrcScanProc = asciiSrcClassRec.text_src_class.Scan;

   /* Ok.  Set up our fabulous icon and augment the actions table for
    * the Return key in the query dialog panel.  The create the child
    * widgets.  Next, grok our custom resources and connect to the
    * server.  If everything goes ok, then realize the application and
    * start the main loop.
    */
   attach_icon(toplevel);
   XtAppAddActions(app_con, actionTable, XtNumber(actionTable));

   /* Get our own resources and store them for future use. */
   XtGetApplicationResources(toplevel, &xphres, Resources,
			     XtNumber (Resources), NULL, 0);
   strcpy(login_alias, xphres.alias);

   connect_to_server(xphres.server, xphres.service);

   create_widgets(toplevel);
 
   XtRealizeWidget(toplevel);
   init_busy_cursor();
   check_status();

   XtAppMainLoop(app_con);
}


check_status()
{
   int code, done=0, motd=0;

   write_ns("status\n");
   while (! done) {
      read_ns(buf);
      code = atoi(buf);
      switch (code) {
	 case LR_PROGRESS:
	    /* This is part of the 'motd', so display it. */
	    XawAsciiAppend(text, word(buf, ':', 1));
	    XawAsciiAppend(text, "\n");
	    motd = 1;
	    break;
         case LR_OK:
	    done = 1;
	    break;
         case LR_RONLY:
	    read_only = 1;
	    done = 1;
	    break;
      }
   }
   
   if (motd) XawAsciiAppend(text, "\n");
}


static void
attach_icon(widget)
Widget widget;
{
    Display *disp;

    /* Try and create a pixmap for the application's icon. */
    disp = XtDisplay(widget);
    icon_pixmap = XCreateBitmapFromData(disp, DefaultRootWindow(disp),
					xph_bits, xph_width, xph_height);
    XtVaSetValues(widget, XtNiconPixmap, icon_pixmap, NULL);
}


Widget help;

static void
create_widgets(widget)
Widget widget;
{
   Widget form, label;
   Widget dform, dlabel, dtext, sendbutton, clearq, clearo;
   Widget mform, mode, misc, menu, about, passwd, finfo, logout, sinfo;
   Widget quitbutton;

   /* Create a form to contain the widgets for our application.  Put
    * a label at the top for the applications title of sorts.  Then
    * put a dialog panel for the queries complete with some buttons to
    * send and clear the query field and output window.  Then put a
    * scrollable text window.  Lastly, put a quit button for the program.
    */
   form = XtCreateManagedWidget("form", formWidgetClass, widget, NULL, ZERO);

   /* Make a button for a server list.  Then build the menu by getting the
    * server list from the default server.  Set the label to the first site
    * in the list you receive.
    */
#if 0
   label = XtCreateManagedWidget("label", labelWidgetClass, form, NULL, ZERO);
#else
   label = XtCreateManagedWidget("label", menuButtonWidgetClass, form, NULL,
				 ZERO);
   create_server_menu(label);
#endif

   /* Create my own "dialog" with a form, a label, and some buttons. */
   dform = XtCreateManagedWidget("dform", formWidgetClass, form, NULL, ZERO);
   dlabel = XtCreateManagedWidget("dlabel", labelWidgetClass, dform, NULL,
				  ZERO);
   dtext = XtCreateManagedWidget("dtext", asciiTextWidgetClass, dform, NULL,
				 ZERO);
   sendbutton = XtCreateManagedWidget("sendq", commandWidgetClass,
				      dform, NULL, ZERO);
   XtAddCallback(sendbutton, XtNcallback, send_query, (XtPointer) dtext);
   XtInstallAccelerators(dtext, sendbutton);
   XtInstallAccelerators(dform, sendbutton);
   clearq = XtCreateManagedWidget("clearq", commandWidgetClass, dform, NULL,
				  ZERO);
   XtAddCallback(clearq, XtNcallback, clear_query, (XtPointer) dtext);
   clearo = XtCreateManagedWidget("clearo", commandWidgetClass, dform, NULL,
				  ZERO);
   XtSetKeyboardFocus(dform, dtext);

   /* Create a panel for mode and options. */
   mform = XtCreateManagedWidget("mform", formWidgetClass, form, NULL, ZERO);
   mode = XtCreateManagedWidget("mode", commandWidgetClass, mform, NULL, ZERO);
#if 0
   XtAddCallback(mode, XtNcallback, do_fullpage, (XtPointer) mform);
#else
   XtAddCallback(mode, XtNcallback, do_change, (XtPointer) mform);
#endif
 
   /* Create the Misc menu for various creeping featurism. */
   misc = XtCreateManagedWidget("misc", menuButtonWidgetClass, mform, NULL,
				ZERO);
   menu = XtCreatePopupShell("menu", simpleMenuWidgetClass, misc, NULL,
			     ZERO);
   about = XtCreateManagedWidget("about", smeBSBObjectClass, menu, NULL, ZERO);
   XtAddCallback(about, XtNcallback, about_xph, NULL);
   finfo = XtCreateManagedWidget("finfo", smeBSBObjectClass, menu, NULL, ZERO);
   XtAddCallback(finfo, XtNcallback, field_info, NULL);
   sinfo = XtCreateManagedWidget("sinfo", smeBSBObjectClass, menu, NULL, ZERO);
   XtAddCallback(sinfo, XtNcallback, site_info, NULL);

   /* Create a button for the help system.  Then build the related menu. */
   help = XtCreateManagedWidget("help", menuButtonWidgetClass, mform, NULL,
				ZERO);
   create_help_menu(help);

   text = XtCreateManagedWidget("text", asciiTextWidgetClass, form, NULL,
				ZERO);
   XtAddCallback(clearo, XtNcallback, clear_output, (XtPointer) text);

   /* And finally, a way out. */
   quitbutton = XtCreateManagedWidget("quit", commandWidgetClass, form,
				      NULL, ZERO); 
   XtAddCallback(quitbutton, XtNcallback, quit, NULL);
}


static void
quit(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   XtDestroyApplicationContext(XtWidgetToApplicationContext(widget));
   exit(0);
}


static void 
usage(app_con, call)
XtAppContext app_con;
char *call;
{
    XtDestroyApplicationContext(app_con);
    fprintf(stderr, "Usage: %s [-alias alias] [-server server] [-service service] [-toolkitoption]\n", call);
    exit(1);
}
