/*
 * browser.h : Device-independent browser defs
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#ifndef _BROWSER_H
#define _BROWSER_H

#define NUM_BROWSER_PANES	3
#define MAX_DEPTH		20

extern void initBrowser();
extern void resetBrowser();
extern int paneDepth();
extern void selectBrowserItem(),unselectBrowserItem();
extern void displayEntries();
extern void resortBrowser();
extern int openBrowserAll(),openBrowserDirectories(),openBrowserFiles();
extern void shiftBrowserDown(),shiftBrowserUp(),shiftBrowserTop();

#define BROWSER_READY	0
#define BROWSER_DIRSEND	1
#define BROWSER_FTP	2

extern void setBrowserState();
extern int getBrowserState();

#endif /* _BROWSER_H */
