/*--------------------------------------------------------------------------
 Program to display the first COLS columns of a bunch of text lines.
 Deletes ^M and backspace characters.
 No line length limit (unlike cut or awk).
--------------------------------------------------------------------------*/
#include <stdio.h>

#define COLS 200

main()
{
    char obuf[COLS+1];
    int c;
    int i;

    i = 0;
    while ((c=getchar()) != EOF) {
	switch (c) {
	case '\n':	/* newline */
	    obuf[i] = 0;
	    puts(obuf);
	    i = 0;
	    break;
	case '\r':	/* return */
	    break;
	case '\010': 	/* backspace */
	    if (i > 0) i--;
	    break;
	default:
	    if (i < COLS)
		obuf[i++] = c;
	    break;
	}
    }
    if (i > 0) {
	obuf[i] = 0;
	puts(obuf);
    }
    exit(0);
}
