#!/usr/bin/perl
#
# archieplexform.pl --  Archie search from HTML Forms
#
# $Id: archieplexform.pl,v 1.4 1994/08/07 17:23:33 www Exp $
#
# By Martijn Koster (m.koster@nexor.co.uk)
# This code is placed in the public domain.

# Configure these ones:

# archieplex*.pl files:
$packages = '/nexor/users/www/data/archieplex-info';

unshift(@INC,$packages);
require "archieplexengine.pl";

package archieplexform;

%servers = (
	    'ANS archie server',	'archie.ans.net',
	    'Australia',		'archie.au',
	    'Canada',                   'archie.uqam.ca',
	    'Finland',			'archie.funet.fi',
	    'Germany',			'archie.th-darmstadt.de',
	    'Internic',			'ds.internic.net',
	    'Israel',			'archie.ac.il',
	    'Japan',			'archie.wide.ad.jp',
	    'Korea',		        'archie.kr',
	    'New Zealand',		'archie.nz',
	    'Norway',                   'archie.unit.no',
	    'Rutgers University',	'archie.rutgers.edu',
	    'Sweden',			'archie.luth.se',
	    'Switzerland',              'archie.switch.ch',
	    'Taiwan',			'archie.ncu.edu.tw',
	    'United Kingdom',		'archie.doc.ic.ac.uk',
	    'United Kingdom (London)',		'archie.doc.ic.ac.uk',
	    'United Kingdom (HENSA)',		'archie.hensa.ac.uk',
	    'University of Nebraska',	'archie.unl.edu',
	    );

%orders = (
	  'host',	' ',
	  'date',	'-t',
	  );

%types = (
	 'Exact Match',				'-e',
	 'Substring Match',	                '-c',
	 'Case Sensitive Substring Match',	'-c',
	 'Case Insensitive Substring Match',	'-s',
	 'Regular Expression Match',		'-r',
	 );

%nices = (
	  'Not Nice At All', '0',
	  'Nice',           '500',
	  'Nicer',          '1000',
	  'Very Nice',      '5000',
	  'Extremely Nice', '10000',
	  'Nicest',         '32765',
	 );

&main'do_archieplexform($ENV{'QUERY_STRING'}) unless defined $main'plexus_configured;

sub main'do_archieplexform
{
    local($path_info) = @_;
    for(split('&', $path_info))    # analyse tags and preprocess values
    {
        local($tag, $value) = split('=', $_, 2);
    
	$value =~ s/\+/ /g;
	$value =~ s/%([\da-f]{1,2})/pack(C,hex($1))/eig;

	&main'error('bad_request', "Duplicate tag: '$tag'.") if ($tags{$tag});

	$tags{$tag} = $value;

	next if (!$value || $value eq '');

	if ($tag eq 'type' ) {
	    $type = $types{$value} || &main'error('bad_request', "Unknown type $value");
	}

	elsif ($tag eq 'order' ) {
	    $order = $orders{$value} || &main'error('bad_request', "Unknown order $order");
	}

	elsif ($tag eq 'nice' ) {
	    if ($value =~ /^\d+$/) {
		($value >=0 && $value <35765) || &main'error('bad_request', "Nice level 0-35765");
		
	    } else {
                if( ! defined($nices{$value}) ){
                   &main'error('bad_request', "Unknown nice level '$value'");
                }
                $value = $nices{$value};
	    }
	    $nice = $value;
	}

	elsif ($tag eq 'server' ) {
	    if ($value !~ /\./) {
		$value = $servers{$value} || &main'error('bad_request', "Unknown server '$value'");
	    }
	    $server = $value;
	}

	elsif ($tag eq 'domain' ) {
	    $domain = $value;
	}

	elsif ($tag eq 'hits' ) {
	    $value =~ /^\d+$/ ||  &main'error('bad_request', "Maximum needs to be numeric, got '$value'");
	    $max = $value;
	}

	elsif ($tag eq 'query') {
	    $query = $value;
	}

	else {
	    &main'error('bad_request', "Unknown tag '$tag'");
	}
    }
    if (!$query) {
	&main'MIME_header('ok', 'text/html');
	print 'Please specify a search term.';
	return;
    }

    &archieplexengine'execute($server, $type, $order, $domain, $query, $max, $nice);
}

1;
