/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

#ifndef COMMANDS_H
#define COMMANDS_H
#include <stdio.h>
#include <cdefs.h>
#include "conf.h"
#include "log.h"
#include "field.h"
#include "qi.h"

/*
 * Commands.  Changes made here should also be made in language.l
 */
#define C_QUERY		1
#define C_CHANGE	2
#define C_LOGIN		3
#define C_ANSWER	4
#define C_LOGOUT	5
#define C_FIELDS	6
#define C_ADD		7
#define C_DELETE	8
#define C_SET		9
#define C_QUIT		10
#define C_STATUS	11
#define C_ID		12
#define C_HELP		13
#define C_CLEAR		14
#define C_INFO		15
#define C_EMAIL		16

extern QDIR User;		/* in commands.c */
extern char *UserAlias;		/* in commands.c */
extern int UserEnt;		/* in commands.c */
extern FILE *Input;		/* mqi.c */
extern FILE *Output;		/* mqi.c */
extern QDIR HeroDir;		/* commands.c */
extern char *Hero;		/* commands.c */
extern int AmHero;		/* commands.c */
extern int AmOpr;		/* commands.c */

/*
 * server states
 */
extern int State;		/* in commands.c */

#define S_IDLE		0	/* nothing in the works */
#define S_E_PENDING	1	/* waiting for login response */

/*
 * Reply codes
 */
#include "replies.h"

/*
 * Value types
 */

/* the following types may be or'd together */
#define VALUE	1		/* single value */
#define EQUAL	2		/* an equals sign */
#define VALUE2	4		/* a value AFTER an equals sign */

/* other types */
#define RETURN	8		/* a return token */
#define COMMAND 16		/* a command name */
#define TILD_E 32		/* a tilde */

/*
 * Argument structure
 */
struct argument
{
	int	aType;
	int	aKey;
	char	*aFirst;
	char	*aSecond;
	FDESC	*aFD;
	struct argument	*aNext;
	int	aRating;
};
typedef struct argument ARG;
extern void (*CommandTable[]) __P((ARG *));	/* in commands.c */

/*
 * delimiters for word breakup
 */
#define IDX_DELIM " \t\n,;:"

/*
 * flags
 */
extern int ReadOnly;		/* mqi.c */

/*
 * just in case...
 */
#define MAXSTR 256

#endif
