/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees, and by CSNET.  No warranties of
 * any kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed without prior consent of CSNET.
 * You may direct questions to nameserv@uiuc.edu
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#ifdef SYSV
# include <sys/fcntl.h>
#else /* !SYSV */
# include <sys/file.h>
#endif /* SYSV */
#include "bintree.h"
#include "db.h"

#ifdef __STDC__
# include <stdlib.h>
# include <string.h>
# ifndef index
#  define index strchr
#  define rindex strrchr
# endif /* !index */
#else /* !__STDC__ */
char	*index();
#endif /* __STDC__ */

#define ESC   '\033'

extern QHEADER header;
extern IDX last_node;
extern NODE *node_buf;
extern LEAF_DES *leaf_des_buf;
int	DontLog = 1;
static char *Me;		/* the name of this program */


main(argc, argv)
	int	argc;
	char	*argv[];

{
	char	bdx_file[100];
	char	idx_file[100];
	char	seq_file[100];
	char	line[512];
	struct iindex buf;
	int	fd;
	int	pipe_fd1[2], pipe_fd2[2];
	int	seqflag = 0, Quiet = 0;
	IDX	hash_index;
	FILE	*to_sort, *from_sort;
	int	count = 0;
	char	*cp;

	/* when you're strange, no one remembers your name */
	Me = *argv;

	while (--argc > 0 && **(++argv) == '-')
	{
		char *equal, **opt;

		(*argv)++;
		if (**argv == 's')
			seqflag++;
		else if (**argv == 'q')
			Quiet++;
		else if (equal = index(*argv, '='))
		{
			*equal++ = '\0';
			for (opt = Strings; *opt; opt += 2)
				if (!strcmp(opt[0], *argv))
				{
					opt[1] = equal;
					break;
				}
			if (*opt == '\0')
			{
				fprintf(stderr, "%s: %s: unknown string.\n",
					Me, *argv);
				exit(1);
			}
		} else
		{
			fprintf(stderr, "%s: %s: unknown option.\n", Me, *argv);
			exit(1);
		}
	}
	Database = (argc > 0) ? *argv : DATABASE;
	if (!Quiet)
		fprintf(stderr, "%s: building sequence file for database %s\n",
			Me, Database);
	sleep(5);
	sprintf(idx_file, "%s.idx", Database);
	sprintf(bdx_file, "%s.bdx", Database);
	sprintf(seq_file, "%s.seq", Database);

	DoSysLog(0);		/* report errors to stderr */

	if (seqflag)
	{			/* build a new .seq file */
		new_file(seq_file);
		chmod(seq_file, 0660);

		if ((fd = open(idx_file, O_RDONLY)) == -1)
		{
			perror(idx_file);
			exit(1);
		}
		/* set up the neccessary mechanism to talk to sort */
		pipe(pipe_fd1);
		pipe(pipe_fd2);

		if (fork() == 0)
		{
			dup2(pipe_fd1[0], 0);
			dup2(pipe_fd2[1], 1);

			close(pipe_fd1[1]);
			close(pipe_fd2[0]);

			execlp("sort", "sort", "-r", "+1", 0);
			perror("Execl in build");
			exit(1);
		}
		close(pipe_fd1[0]);
		close(pipe_fd2[1]);

		to_sort = fdopen(pipe_fd1[1], "w");
		from_sort = fdopen(pipe_fd2[0], "r");


		if (fork() == 0)
		{		/* read from .idx file and write to sort */
			fclose(from_sort);
			hash_index = 0;
			while (read(fd, (char *) &buf, sizeof (buf)) > 0)
			{
				if (buf.i_string[0] && buf.i_string[0] != EMPTY)
				{	/* a hit */
					if (buf.i_string[0] != ESC)
					{
						fprintf(to_sort, "%d %s\n", hash_index, buf.i_string);
						/* fprintf(stderr,"%d %s\n",hash_index,buf.i_string); */
					}
				}
				hash_index++;
				count++;
				if (!Quiet && count % 1000 == 1)
					fprintf(stderr, "%d (%s) to sort.\n", count,
						Visible(buf.i_string, strlen(buf.i_string)));
			}
			if (!Quiet)
				fprintf(stderr, "%d to sort\n", count);
			exit(0);
		} else
		{		/* read from sort and insert into .seq file */
			fclose(to_sort);

			while (fgets(line, sizeof line, from_sort))
			{

				count++;
				if (!Quiet && count % 1000 == 1)
					fprintf(stderr, "%d from sort.\n", count);
				/* Get rid of the ending newline */
				if (cp = index(line, '\n'))
					*cp = '\0';

				/* Get the hash table index */
				hash_index = atoi(line);

				/* Skip to the key and inset it into the seq set */
				if (cp = index(line, ' '))
				{
					strcpy(buf.i_string, cp + 1);
					/*
					 * fprintf( stderr, "%d %s\n", hash_index, buf.i_string );
					 */
					insert(buf.i_string, hash_index);
				}
			}
			if (!Quiet)
				fprintf(stderr, "%d from sort\n", count);
		}

		close(fd);
		put_tree_head();
	}
	bintree_init(Database);
	build_leaf_descriptors();
	header.index_root = build_tree((long) 1, header.last_leaf);
	printf("Tree built, %ld nodes\n", last_node);

	write_index(bdx_file);

	put_tree_head();
	exit(0);
}

/*
 * pacify ld
 */
char   **
get_dir_ptrs(iloc)
	long	iloc;
{
	return ((char **) NULL);
}

cleanup()
{
}
