#ifndef PROTOS_H
#define PROTOS_H
#include <cdefs.h>
#include <stdio.h>
#include <ctype.h>
#include "bintree.h"
#include "commands.h"
#include "conf.h"
#include "db.h"
#include "field.h"
#include "log.h"
#include "options.h"
#include "qi.h"
#include "replies.h"

#define NEW(type)	((type *)malloc(sizeof(type)))
#ifdef FCRYPT
# define crypt		fcrypt
#endif /* FCRYPT */

extern int errno;

#ifdef __STDC__
# include <stdlib.h>
# include <string.h>
# ifndef index
#  define index strchr
#  define rindex strrchr
# endif /* !index */
# ifndef bcmp
#  define bcmp memcmp
# endif /* !bcmp */
# ifndef bzero
#  define bzero(s,n) memset(s,0,n)
# endif /* !bzero */
# ifndef bcopy
#  define bcopy(h,a,l) memcpy(a,h,l)
# endif /* !bcopy */
#else /* !__STDC__ */
# include <strings.h>
MEM_TYPE *malloc(), *realloc();
char	*strtok();
#endif /* __STDC__ */

char	*crypt __P((const char *, const char *));

char	*add_string __P((char *));	/* lib/strbuild.c - not used */
void	AddValue __P((char *, int));
int	AliasIsUsed __P((char *, long));
int	AllMeta __P((char *));
IDX	allocate_leaf();
int	any __P((int, char *));		/* 1 char -> int */
int	anyof __P((register char *, register char *));
int	BadAlias __P((char *));
void	bintree_init __P((char *));
int	blankline __P((char *));	/* lib/str.c - not used */
int	CanAddEntries();
int	CanChange __P((QDIR, FDESC *));
int	CanDelete __P((QDIR));
int	CanLookup __P((FDESC *));
int	CanSee __P((QDIR, FDESC *, int));
int	ChangeDir __P((QDIR *, FDESC *, char *));
void	cleanup __P((int));
void	close_tree();
int	countc __P((char *, int));	/* 2 char -> int, str.c - not used */
void	crypt_start __P((char *));
int	CurrentDate();
int	CurrentIndex();
int	dbd_init __P((char *));
int	dbi_init __P((char *));
int	decode __P((unsigned char *, unsigned char *));
char	*decrypt __P((char *, char *));
void	decrypt_end();
int	delete __P((char *));
int	deletestr __P((char *, int));
int	dnext_ent __P((long));
void	DoAdd __P((ARG *));
void	DoChange __P((ARG *));
void	DoCommand __P((int));
void	DoHelp __P((ARG *));
long	*DoLookup __P((ARG *));
long	*do_lookup __P((char **, long *));
void	DoQuery __P((ARG *));
void	DoQuit __P((ARG *));
void	DoReply __P((int, char *, ...));
void	DoSet __P((ARG *));
int	DoSysLog __P((int));
int	encode __P((char *, char *, int));
int	encryptit __P((char *, char *));
int	ent_dead();
void	expand __P((LEAF *, int, ITEM *));
long	*find_all __P((char *));
FDESC	*FindFD __P((char *));
FDESC	*FindFDI __P((int));
int	FindField __P((QDIR, int));
long	*findstr __P((char *));
void	FreeArgs __P((ARG *));
void	free_ary __P((long **));
void	FreeDir __P((QDIR *));
ARG	*FreshArg __P(());
QDIR	GetAliasDir __P((char *));
char	**getdata __P((QDIR *));
DREC	*getdirent __P((long));
void	get_dir_head();
long	*get_dir_ptrs __P((long));
int	GetFieldConfig();
int	GetState();
void	get_tree_head();
char	*getword __P((char *, char *));	/* lib/util.c - not used */
int	GonnaRead();
int	GonnaWrite();
int	icopy __P((char *, char *));
long	ihash __P((char *, long, long));
void	InitializeLogging();
void	InitializeOptions();
void	init_string();
void	insert __P((char *, IDX));
long	*intersect __P((long *, long *));
int	isblank __P((char *));
int	issub __P((char *, char *));
int	IssueMessage __P((int, char *fmt, ...));
int	length __P((long *));
void	LimitHit __P((int));
char	*ltrunc __P((char *));		/* lib/str.c - not used */
void	make_lookup __P((char *, int));
char	*make_str __P((char *));
long	*merge __P((long *, long *));
void	mkargv __P((int *, char **, char *));
int	new_ent();
int	next_ent __P((long));
char	*PasswordOf __P((QDIR));
char	*phonemify __P((char *));
int	putarry __P((struct iindex *, long *, long));
int	putdata __P((char **));
void	putdirent __P((long, DREC *));
void	put_dir_head();
int	putstr __P((char *, int));
void	put_tree_head();
int	quoted __P((char *));
void	read_index __P((char *));
void	read_leaf __P((IDX, LEAF *));
int	RemoveSpecials __P((char *));
int	search __P((char *, LEAF *, int *));
void	set_date __P((int));
void	SetDeleteMark();
void	store_ent();
int	strcate __P((char *, char *));
int	strcpc __P((register char *, register char *));
char	*strecat __P((char *, char *)); /* lib/str.c - not used */
char	*strecpy __P((char *, char *)); /* lib/str.c - not used */
int	stricmp __P((char *, char *));
int	strincmp __P((char *, char *, int));
char	*strlcpy __P((char *, char *));
void	Unknown __P((char *));
void	Unlock();
void	unmake_lookup __P((char *, int));
int	UserCanChange __P((QDIR));
int	UserCanDelete();
void	write_leaf __P((LEAF *));
int	ValidQuery __P((ARG *, int));

#endif	/*PROTOS_H*/
