/* query.c -- routines to query the CSO nameserver.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Wed Apr 29 12:41:58 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/AsciiText.h>

#include "replies.h"
#include "global.h"


char *word(s, c, n)
char *s;
char c;
int n;
{
   int i;
   char *pos;
   char *index();

   pos = s;
   for (i=0; i<n; i++) {
      pos = index(pos, c);
      pos++;
   }

   return(pos);
}


process_results()
{
   int done=0, code, num, last_num=1;
   char *pos;
   
   do {
      read_ns(line);
      sscanf(line, "%d:%d:", &code, &num);

      switch (code) {
         case -(LR_OK):
            /* We're getting responses.  Check if this is a subsequent
	     * stanza and if so, separate it with a blank line.
	     */
	    if (num != last_num) {
	       XawAsciiAppend(text, "\n");
	    }
	    
	    /* Format the string by stripping off the first 2 fields. */
	    pos = word(line, ':', 2);
	    strcat(pos, "\n");
	    XawAsciiAppend(text, pos);

	    last_num = num;
	    break;
         case -(LR_ISCRYPT):
	    /* An encrypted field; skip it. */
	    break;
         case LR_OK:
	    /* We're done. */
	    done = 1;
	    break;
         default:
	    /* Yikes!. */
	    sprintf(buf, "Unrecognized response from server:\n   '%s'\n",
		    line);
	    XawAsciiAppend(text, buf);
	    done = 1;
	    break;
      }
   } while (! done);
}


do_query(query)
char *query;
{
   static char q_cmd[80];
   int code, start_position, foo, matches;
   char *start, foo_p[80];

   /* Form and send the query in a "default" format. */
   sprintf(q_cmd, "query %s\n", query);
   write_ns(q_cmd);

   /* Determine the ending position of the text in the window.  We'll
    * then add the recent query to the window and restore the cursor
    * to the beginning of the new query's output.
    */
   XawAsciiSaveTextPosition(text);
   read_ns(line);
   sscanf(line, "%d:%s %s %d", &code, foo_p, foo_p, &matches);
   switch (code) {
      case LR_NUMRET:
         sprintf(buf, "There %s %d match%s to your query:\n",
		 ((matches > 1) ? "were" : "was"), matches,
		 ((matches > 1) ? "es" : ""));
	 XawAsciiAppend(text, buf);
         process_results();
	 XawAsciiAppend(text, "\n");
	 break;
      case LR_NOMATCH:
	 /* No results, the query failed. */
	 strcat(line, "\n");
         XawAsciiAppend(text, word(line, ':', 1));
	 break;
      default:
	 code = atoi(line);
	 while (code < 0) {
	    strcat(line, "\n");
	    XawAsciiAppend(text, word(line, ':', 1));
	    read_ns(line);
	    sscanf(line, "%d:%s %s %d", &code, foo_p, foo_p, &matches);
	 }
	 strcat(line, "\n");
	 XawAsciiAppend(text, word(line, ':', 1));
	 break;
   }

   /* Now print a blank line and restore the cursor to the start of the
    * new query output.
    */
   XawAsciiAppend(text, "\n");
   XawAsciiRestoreTextPosition(text);
}


/* This routine asks the server for a specific field value and returns
 * the value to the caller.
 */
String lookup_field(alias, field_name)
String alias;
String field_name;
{
   int code;
   String value;
   
   sprintf(buf, "query alias=%s return %s\n", alias, field_name);
   write_ns(buf);

   read_ns(line);
   code = atoi(line);
   if (code == LR_NUMRET) {
      /* Cool, the query succeeded.  Read the next line which should
       * be the result, parse it, and consume the following OK message.
       * Check that the field *has* a value (code negative if so).
       */
      read_ns(line);
      code = atoi(line);
      if (code != LR_OK)
	 read_ns(buf);
      if ((code == -(LR_ABSENT)) || (code == LR_OK)) {
	 value = (char *) malloc(sizeof(char));
	 strcpy(value, "");
	 return(value);   /* Value not present in the entry. */
      }
      else {
	 strcpy(buf, word(line, ':', 3));
	 value = (char *) malloc(strlen(buf) + 1);
	 strcpy(value, &buf[1]);   /* Skip over the leading space. */
	 return(value);
      }
   }
   else {
      /* Yikes, something is wrong; probably a bad alias or field name.
       * This should not have happened.  Deal with it poorly by sending
       * a message into the main window's output window and reading until
       * we read a line with a positive code.
       */
      fprintf(stderr, "lookup_field: Yikes!\n");
      do {
	 strcat(line, "\n");
	 XawAsciiAppend(text, word(line, ':', 1));
	 read_ns(line);
	 code = atoi(line);
      } while (code < 0 );
      strcat(line, "\n");
      XawAsciiAppend(text, word(line, ':', 1));

      value = (char *) malloc(sizeof(char));
      strcpy(value, "");
      return(value);
   }
}


void send_query(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   String query;

   XtVaGetValues((Widget) client_data, XtNstring, &query, NULL);
   if (strcmp(query, "")) {
      busy_cursor();
      do_query(query);
      unbusy_cursor();
   }
}


void return_send_query(widget, event, params, num_params)
Widget widget;		
XEvent *event;		
String *params;	
Cardinal *num_params;
{
    Widget dialog = XtParent(widget);

    send_query(widget, (XtPointer) dialog, (XtPointer) NULL);
}


void clear_query(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
    XtVaSetValues((Widget) client_data, XtNstring, "", NULL);
}


void clear_output(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
    XtVaSetValues((Widget) client_data, XtNstring, "", NULL);
}
