/* Copyright 1990 GROUPE BULL -- See licence conditions in file COPYRIGHT */
/* xpm.h:
 *
 *  XPM
 *  Include file
 *  Developed by Arnaud Le Hors
 */

#ifndef XPM_h
#define XPM_h

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <stdio.h>

/* we keep the same codes as for Bitmap management */
#ifndef _XUTIL_H_
#ifdef VMS
#include "decw$include:Xutil.h"
#else
#include <X11/Xutil.h>
#endif
#endif

#define PixmapSuccess          0
#define PixmapOpenFailed       1
#define PixmapFileInvalid      2
#define PixmapNoMemory         3
#define PixmapParseColorFailed 4
#define PixmapAllocColorFailed 5

typedef struct {
    char *name;
    char *value;
    Pixel pixel;
} ColorSymbol;

typedef struct {
    char *type;
    int ncolors;
    char ***colorTable;
    Pixel *pixels;
    char *hints_cmt;
    char *colors_cmt;
    char *pixels_cmt;
    char *rgb_fname;
} XpmInfo;

/* minimal portability layer between ansi and KR C 
 */

/* forward declaration of functions with prototypes */

#if __STDC__ || defined(__cplusplus) || defined(c_plusplus) /* ANSI || C++*/
#define FUNC(f, t, p) extern t f p
#define LFUNC(f, t, p) static t f p
#else					/* K&R */
#define FUNC(f, t, p) extern t f()
#define LFUNC(f, t, p) static t f()
#endif					/* end of K&R */

#ifdef __cplusplus
extern "C" {
#endif
/* functions declarations
 */

FUNC(XCreatePixmapFromData, int, (Display *display,
				  Visual *visual,
				  Drawable d,
				  Colormap colormap,
				  char **data,
				  unsigned int depth,
				  Pixmap *pixmap_return,
				  unsigned int *width_return, 
				  unsigned int *height_return, 
				  Pixel **pixels_return,
				  unsigned int *npixels_return,
				  ColorSymbol *colorsymbols,
				  unsigned int numsymbols,
				  XpmInfo *infos));

FUNC(XReadPixmapFile, int, (Display *display,
			    Visual *visual,
			    Drawable d,
			    Colormap colormap,
			    char *filename,
			    unsigned int depth,
			    Pixmap *pixmap_return,
			    unsigned int *width_return, 
			    unsigned int *height_return, 
			    Pixel **pixels_return,
			    unsigned int *npixels_return,
			    ColorSymbol *colorsymbols,
			    unsigned int numsymbols,
			    XpmInfo *infos));

FUNC(XWritePixmapFile, int, (Display *display,
			     Colormap colormap,
			     char *filename,
			     Pixmap pixmap,
			     unsigned int width,
			     unsigned int height,
			     char *type,
			     unsigned int cppm,
			     XpmInfo *infos));

FUNC(XFreeXpmInfo, int, (XpmInfo *infos));
#ifdef __cplusplus
}                                             /* for C++ V2.0 */
#endif

#endif
