/* fullpage.c -- routines to perform full-page field editing.
 *
 * Copyright (C) 1991, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Sun Dec 22 23:39:37 1991 by bcs (Bradley C. Spatz) on sophie
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Viewport.h>

#include "fields.h"
#include "replies.h"
#include "global.h"

static Widget fp_popup=NULL;


void position_fpmenu(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   String label;
  
   XtVaGetValues(XtParent(XtParent(widget)), XtNlabel, &label, NULL);
   fprintf(stderr, "position_fpmenu(), %s\n", label);
}


void do_fullpage(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   Widget      fpvp, fpform, fplabel, fpmenu, fpitem, fpvalue, vert, fpdone;
   Position	x, y;
   Dimension	width, height;
   String      *list, label, value;
   int         i;
   Boolean     sensitive;
   
#if 1
   /* Have we logged in yet?  If not, pop up a widget to do that first. */
   if (! logged_in) {
      do_login((Widget) widget, (XtPointer) client_data,
	       (XtPointer) do_fullpage);
      return;
   }
#endif
   
   if (fp_popup == NULL) {
      busy_cursor();
      fp_popup = XtVaCreatePopupShell("xph_fp_edit",
				      applicationShellWidgetClass,
				      widget, XtNtitle, "Xph FullPage Edit",
				      XtNiconPixmap, icon_pixmap, NULL);
      
      /* Create a form for all the fields. */
      fpvp = XtCreateManagedWidget("fpvp", viewportWidgetClass, fp_popup,
				   NULL, ZERO);
      fpform = XtCreateManagedWidget("fpform", formWidgetClass, fpvp,
				     NULL, ZERO);
      
      /* Ask the nameserver for field info.  Store this and then compute
       * a subset.  By default, we show only those changeable fields
       * that are returned by default.
       */
      list = field_list((CHANGE | ENCRYPT | NOPEOPLE), CHANGE);
      
      /* Make a popup menu for each field label. */
      fpmenu = XtCreatePopupShell("fpmenu", simpleMenuWidgetClass, fpform,
				  NULL, ZERO);
      XtAddCallback(fpmenu, XtNpopupCallback, position_fpmenu, NULL);
      fpitem = XtCreateManagedWidget("Field Info", smeBSBObjectClass, fpmenu,
				     NULL, ZERO);
      fpitem = XtCreateManagedWidget("Revert Field", smeBSBObjectClass, fpmenu,
				     NULL, ZERO);
      /* Add callbacks for these items here. */
      
      /* Now make a panel with all the fields; a label widget and
       * a 1-line text widget for the value, one pair per line.
       */
      vert = NULL;
      for (i=0; list[i] != NULL; i++) {
	 sprintf(line, "%s:", list[i]);
	 sensitive = is_default_field(list[i]);
	 sensitive = TRUE;
	 fplabel = XtVaCreateManagedWidget("fplabel", menuButtonWidgetClass,
					   fpform, XtNlabel, line,
					   XtNjustify, XtJustifyRight,
					   XtNfromVert, vert,
					   XtNborderWidth, ZERO,
					   XtNsensitive, sensitive,
					   XtNmenuName, "fpmenu",
					   NULL);
	 fpvalue = XtVaCreateManagedWidget("fpvalue", asciiTextWidgetClass,
					   fpform, XtNfromHoriz, fplabel,
					   XtNfromVert, vert,
					   XtNeditType, XawtextEdit,
					   XtNstring,
					   lookup_field(login_alias, list[i]),
					   XtNsensitive, sensitive,
					   NULL);
	 /* Hack here to force a resize of the text widget. */
	 XtCallActionProc(fpvalue, "beginning-of-line", NULL, NULL, ZERO);

	 vert = fplabel;
      }
      
      /* Put a dismiss button as well. */
      fpdone = XtVaCreateManagedWidget("fpdone", commandWidgetClass,
				       fpform, XtNfromVert, vert, NULL);
      XtAddCallback(fpdone, XtNcallback, pop_down_widget, (XtPointer) fpvp);
   }
   
   unbusy_cursor();
   XtPopup(fp_popup, XtGrabNone);
}


static void
change_dismiss(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   /* Log out and pop down the change widget. */
   logged_in = FALSE;
   XtPopdown(change_popup);
}
