/*
 * mkhpfi - generate HP fontinfo file from HP font file
 *
 * Usage: mkhpfi hp_font_file hp_fontinfo_file
 * You should call the fontinfo file "fiXX", where XX is a one or two
 * character font name.
 *
 * Outputs a binary HP fontinfo file.
 *
 * For soft fonts downloaded from disk, use this program.
 * For fonts resident in font cartridges, you'll have to manually create
 * and compile a C source module defining a struct hpfontinfo.
 *
 * David MacKenzie
 * Latest revision: 07/21/88
 */

#include <stdio.h>
#include "hpfont.h"
#include "hpfinfo.h"

main(argc, argv)
    int argc;
    char **argv;
{
    if (argc != 3) {
	fprintf(stderr, "Usage: %s hp_font_file hp_fontinfo_file\n", argv[0]);
	exit(1);
    }
    makefinfo(argv[1], argv[2]);
}

/*
 * Generate an HP fontinfo file called info based on the HP font file
 * called font.
 */
makefinfo(font, info)
    char *font, *info;
{
    FILE   *ifp, *ofp;
    fontdesc fd;
    struct hpfontinfo fi;

    ifp = fopen(font, "r");
    if (!ifp) {
	perror(font);
	exit(1);
    }
    ofp = fopen(info, "w");
    if (!ofp) {
	perror(info);
	exit(1);
    }

    readfontdesc(ifp, &fd);
    convert(&fd, &fi);
    writefinfo(ofp, &fi);

    fclose(ofp);
    fclose(ifp);
}

readfontdesc(fp, fdp)
    FILE   *fp;
    fontdesc *fdp;
{
    char    buf[500];		/* Trash receptacle. */
    int     fdlen;		/* No. of bytes in font descriptor. */

    if (fscanf(fp, "\033)s%dW", &fdlen) != 1)
	err("Can't read font creation sequence");
    if (!fread(fdp, sizeof(fontdesc), 1, fp))
	err("Can't read font descriptor");
    /* Not necessary, but we might as well, for error checking. */
    if (fdlen > sizeof(fontdesc))
	if (!fread(buf, fdlen - sizeof(fontdesc), 1, fp))
	    err("Can't read continuation of font descriptor");
}

/*
 * Fill in a struct hpfontinfo based on a fontdesc.
 */
convert(fdp, fip)
    fontdesc *fdp;
    struct hpfontinfo *fip;
{
    fip->fi_orient = fdp->f_orient;
    fip->fi_spacing = fdp->f_spacing;
    fip->fi_style = fdp->f_style;
    fip->fi_weight = fdp->f_weight;
    fip->fi_typeface = fdp->f_typeface;
}

writefinfo(fp, fip)
    FILE *fp;
    struct hpfontinfo *fip;
{
    if (fwrite(fip, sizeof(struct hpfontinfo), 1, fp) != 1)
        perror("fwrite");
}
    
err(s)
    char   *s;
{
    fprintf(stderr, "%s\n", s);
    exit(1);
}
