/*
 * hpfinfo.h
 *
 * Format of an HP fontinfo file for troff2lj.
 */

#include "hpconfig.h"

/*
 * Characteristics used in selecting a font, in descending order of
 * priority.  From p.2-19, Technical Reference Manual.
 * Symbol set and point size are dealt with separately.
 */
struct hpfontinfo {
    /* printing orientation */
    uchar    fi_orient;		/* 0:portrait, 1:landscape */
    /* proportional vs. fixed spacing */
    uchar    fi_spacing;	/* 0:fixed, 1:proportional */
    /* character style */
    uchar    fi_style;		/* 0:upright, 1:italic */
    /* stroke weight (light, medium, bold) */
    schar    fi_weight;		/* -7 to 7 */
    /* typeface (courier, pica, elite, etc.) */
    uchar    fi_typeface;	/* 0-10, see table on p. 3-14 */
};
