/*
 * download - download an HP LaserJet font file
 * Usage: download [-d] [-s#] fontfile...
 *
 * Options:
 * -d	delete any previously existing soft fonts
 * -s#	assign font i.d.'s starting with # (default 0)
 *
 * Writes to the standard output.  Should be piped to lpr/lp.
 *
 * David MacKenzie
 * Latest revision: 07/19/88
 */

#include <stdio.h>
#include "hpconfig.h"

main(argc, argv)
    int     argc;
    char  **argv;
{
    extern char *optarg;
    extern int optind;
    int     c;
    int     fid = 0;

    translate();
    
    while ((c = getopt(argc, argv, "ds:")) != EOF)
	switch (c) {
	case 'd':
	    delfonts();
	    break;
	case 's':
	    fid = atoi(optarg);
	    break;
	default:
	    usage(argv[0]);
	}

    if (optind == argc)
	usage(argv[0]);
    else
        for (; optind < argc; ++optind)
	    download(argv[optind], fid++);

    exit(0);
}

/*
 * Open given font file; if leading directory is not specified, assume
 * it's in the standard one.
 */
FILE *
openfont(file)
    register char *file;
{
    FILE *ff;
    char    path[BUFSIZ];
    
    if (file[0] != '/')
	strcpy(path, FONTDIR);
    else
	path[0] = 0;
    strcat(path, file);
    if (!(ff = fopen(path, "r")))
	perror(path);
    return ff;
}

/*
 * Send the codes to download a font file.
 */

download(file, fid)
    char   *file;
    int     fid;
{
    FILE   *openfont();
    FILE   *ff;
    register int c;

    if (!(ff = openfont(file)))
	return;
    
    specfid(fid);

    while ((c = getc(ff)) != EOF)
	putc(c, stdout);
    fclose(ff);

    select(fid);
}

/*
 * Make the font with the specified i.d. permanent.
 */

select(fid)
    int     fid;
{
    specfid(fid);
    permanent();
}

/*
 * Specify font i.d.
 */
specfid(fid)
    int     fid;
{
    printf("\033*c%dD", fid);
}

/*
 * Make the last specified font permanent (not cleared by printer reset).
 */
permanent()
{
    printf("\033*c5F");
}

/*
 * Delete all downloaded fonts, freeing up the printer's memory.
 */
delfonts()
{
    printf("\033*c0F");
}

/*
 * We assume there are no newline translations occurring on the printer
 * port, so as not to mangle downloaded fonts.  Therefore, make sure
 * that the printer is doing them.
 * p. 2-45, 2: CR=>CR; LF=>CRLF; FF=>CRFF
 */
translate()
{
     printf("\033&k2G");
}

usage(file)
    char   *file;
{
    fprintf(stderr, "Usage: %s [-d] [-s#] fontfile...\n", file);
    exit(1);
}
