/*
 * redefines.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.3 $
 * $Date: 1991/09/10 16:58:59 $
 */

/*
 * file of functions which don't work with sun4 gcc unless
 * recompiled.
 */

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <varargs.h>

char *inet_ntoa(in)
	struct in_addr in;
{
	static char b[18];
	register char *p;

	p = (char *)&in;
#define	UC(b)	(((int)b)&0xff)
	sprintf(b, "%d.%d.%d.%d", UC(p[0]), UC(p[1]), UC(p[2]), UC(p[3]));
	return (b);
}


/*VARARGS*/
#define MAX_FORMAT_ARGS 20

void xerror(va_alist)
     va_dcl
{
  char buff[256];
  int ret_val, num_args, i;
  char *fmt_str;
  void *av[MAX_FORMAT_ARGS];
  va_list ap;

  va_start(ap);
  fmt_str = va_arg(ap, char *);
  if ((num_args = find_percents(fmt_str)) > MAX_FORMAT_ARGS) {
    fprintf(stderr, "Too many arguments to cmeg_error\n");
    exit(-1);
  }

  /* clear the argument vector */
  for (i=0; i < MAX_FORMAT_ARGS; i++)
    av[i] = (void *) NULL;

  /* load argument vector off stack */
  for (i=0; i<num_args; i++)
    av[i] = (void *) va_arg(ap, void *);

  va_end(ap);

  /* The number of args here must match MAX_FORMAT_ARGS */
  sprintf(buff, fmt_str, av[0], av[1], av[2], av[3], av[4], av[5],
	  av[6], av[7], av[8], av[9], av[10], av[11], av[12], av[13],
	  av[14], av[15], av[16], av[17], av[18], av[19]);
  
  {
    int *ip;
    fprintf(stderr, "\nx-kernel error: %s\n", buff);
    ip = (int *) 0;
    *ip = 10;
    exit(-1);
  }
}


int find_percents(str)
     char *str;
{
  int num = 0;

  while (*str) {		/* walk the string */
    if (*str == '%') {
      str++;
      if  (*str != '%')		/* skip over %% */
	num++;			/* else bump count */
    }
    str++;
  }

  return num;			/* return total */
}
