/*
 * route.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.8 $
 * $Date: 1992/01/15 01:18:29 $
 */

/*
 * Interface to the routing subsystem
 */

#ifndef route_h
#define route_h

#define IPROUTE_TTL_INFINITE	0xffff
#define RTDEFAULTTTL    60*24	  /* default ttl for a route - 1 day */

typedef struct route {
	IPhost	net; 		/* net for this route */
	IPhost  mask;		/* mask for this net */
 	IPhost  gw;		/* gateway for hop */
	int 	metric; 	/* distance metric */
	XObj 	interface; 	/* interface for this route */
	Sessn 	netSessn; 	/* cached network session */
	u_short key;		/* sort key */
	u_short ttl;		/* time to live */
	struct route *next;	/* next for this hash */
/* stats */
	u_long  refcount;	/* current reference count */
	u_long  usecount;	/* use count */
} route;


#include "ip_i.h"

#ifdef __STDC__
extern int	rt_init( PSTATE *, IPhost * );
extern int 	rt_add( PSTATE *, IPhost *, IPhost *, IPhost *,
		        int, XObj, int );
extern int	rt_add_def( PSTATE *, IPhost * );
extern route *	rt_get( IPhost * );
extern void	rt_free( route * );
extern void	rt_delete( IPhost *, IPhost * );

#else

extern int	rt_init();
extern int 	rt_add();
extern int	rt_add_def();
extern route *	rt_get();
extern void	rt_free();
extern void	rt_delete();

#endif __STDC__

#endif  ! route_h
