/* 
 * part.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.5 $
 * $Date: 1992/02/06 19:05:00 $
 */

#include "xtype.h"
#include "part.h"
#include "assert.h"
#include "x_util.h"

void
partInit(p, n)
    Part *p;
    int n;
{
    int i;

    for (i=0; i < n; i++) {
	p[i].stack.top = 0;
	p[i].len = n;
    }
}


void
partStackPush(s, data)
    PartStack *s;
    VOID *data;
{
    xAssert( s->top >= 0 );
    if ( s->top >= PART_MAX_STACK ) {
	Kabort("participant stack overflow");
    }
    s->arr[s->top++] = data;
}


VOID *
partStackPop(s)
    PartStack *s;
{
    xAssert( s->top >= 0 );
    if ( s->top == 0 || s->top > PART_MAX_STACK ) {
	return 0;
    }
    return s->arr[--s->top];
}
