/* 
 * ip.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.7 $
 * $Date: 1991/11/22 20:52:24 $
 */

#ifndef ip_h
#define ip_h

#include "upi.h"
#include "ip_host.h"


#define CLASSA(ad) (~((ad).a) & 0x80)
#define CLASSB(ad) (((ad).a & 0x80) && (~((ad).a) & 0x40))
#define CLASSC(ad) (((ad).a & 0x80) && ((ad).a & 0x40) && (~((ad).a) & 0x20))

#define IP_NETEQ(a1,a2) (((a1).a == (a2).a) && \
			 (CLASSA(a1) || (((a2).b == (a2).b) && \
					 (CLASSB(a1) || ((a1).c == (a2).c)))))


typedef struct ippseudohdr {
  IPhost src;
  IPhost dst;
  u_char zero;
  u_char prot;
  u_short len;
} IPpseudoHdr;


/*
 * IP control opcodes
 */
#define IP_MYNET	(TMP0_CTL*MAXOPS+0)
#define IP_REDIRECT	(TMP0_CTL*MAXOPS+1)
#define IP_GETRTINFO    (TMP0_CTL*MAXOPS+2)

#endif
