/* 
 * idmap.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.11 $
 * $Date: 1992/01/16 19:24:18 $
 */

#ifndef idmap_h
#define idmap_h


#define MAX_MAP_KEY_SIZE	48


typedef struct mapelement {
  struct mapelement *next;
  int internalid;
  char externalid[1];
} MapElement, *Bind;


typedef struct {
  int tableSize, keySize;
  MapElement *cache;
  MapElement *freelist;
  MapElement **table;
  int	(*resolve)();
  Bind	(*bind)();
  int	(*unbind)();
  int	(*remove)();
} *Map;


#define mapResolve(map, key) (map)->resolve(map, key)
#define mapBind(map, key, value)   (map)->bind(map, key, value)
#define mapRemoveBinding(map, binding)   (map)->remove((map), (binding))
#define mapUnbind(map, key)   (map)->unbind((map), (key))

#ifdef __STDC__

typedef	int (*MapForEachFun)( void *key, int value, void *arg );

extern void 	mapClose( Map );
extern Map 	mapCreate( int tableSize, int keySize );
extern void	mapForEach( Map, MapForEachFun, void * );

#else

typedef	int (*MapForEachFun)();

extern void 	mapClose();
extern Map 	mapCreate();
extern void	mapForEach();

#endif __STDC__


#endif /* idmap_h */
