#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Paned.h>

String fallback_resources[] = {
       "*input:                TRUE",
       "*Viewport*forceBars:   True",
       "*Viewport*allowVert:   True",
       "*fileButton.label:     FILE",
       "*editButton.label:     EDIT",
       "*selectButton.label:   CREATE",
       "*optionButton.label:   OPTION",
       "*Com_box*orientation:      horizontal",
       "*Com_box*hSpace:            20",
       NULL,
 };


void New(), Save(), Quit(), Open();
void Undo(), Cut(), Paste();
void Newnode(), Newedge();
void Reduce(), Enlarge();


typedef struct menu{
        char *names;
        void (*func)();
}menu_entry;

void main(argc,argv)
int argc;
char *argv[];

  {
    XtAppContext app_con;
    Widget top,view, outer,com_box;
    void make_com_bar();
    Arg arg[1];
    int i;

    top = XtAppInitialize(&app_con,"Xg",NULL,ZERO,&argc,argv,fallback_resources,NULL,ZERO);

    outer = XtCreateManagedWidget("box",boxWidgetClass,top,NULL,ZERO);



    com_box = XtCreateManagedWidget("Com_box",boxWidgetClass,outer,NULL,ZERO);
   /* view = XtCreateManagedWidget("View",viewportWidgetClass,outer,NULL,ZERO);
*/
    make_com_bar(com_box);

    XtRealizeWidget(top);
    XtAppMainLoop(app_con);

 }


void make_com_bar(toplevel)
Widget toplevel;

 {

    Widget  file, edit, select, option;

    static menu_entry file_item_names[] = {
    "new", New, "open", Open, "save", Save, "save as", Save, "quit", Quit,
    NULL,
    };

    static menu_entry edit_item_names[] = {
    "undo", Undo, "cut", Cut, "paste",Paste,
    NULL,
    };
    
    static menu_entry select_item_names[] = {
    "node", Newnode,"edge",Newedge,
    NULL,
    };
  
    static menu_entry option_item_names[] = {
    "reduce",Reduce,"enlarge",Enlarge,
    NULL,
    };
    void make_menu();



    file = XtCreateManagedWidget("fileButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(file,file_item_names,5);
   
    edit = XtCreateManagedWidget("editButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(edit,edit_item_names,3);

    select = XtCreateManagedWidget("selectButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(select,select_item_names,2);

    option = XtCreateManagedWidget("optionButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(option,option_item_names,2);

}


void make_menu(command,menu_item_names,x)
Widget command;
menu_entry *menu_item_names;
int x;

 {

   Widget menu,entry;
   int i, size;
   char *item;

   menu = XtCreatePopupShell("menu",simpleMenuWidgetClass,command,NULL,ZERO);

   size = (int) my_size(menu_item_names);
   for(i = 0; i < x /* size */ ; i++) {
       item = menu_item_names[i].names;
       entry = XtCreateManagedWidget(item,smeBSBObjectClass,menu,NULL,ZERO);
       XtAddCallback(entry,XtNcallback,menu_item_names[i].func,NULL);
   }
 }

int my_size(names)
menu_entry *names;
 

 {
   int i;

   for(i=0; names[i].names != NULL; i++)
                ;

    return(i);

  }

void New(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

    fprintf(stderr,"request for a new graph\n");
  }

void Open(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

    fprintf(stderr,"request to open a file \n");

  }

void Save(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

    fprintf(stderr,"request to save  graph\n");
    
 }

void Quit(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

   fprintf(stderr,"application is quiting\n");
   XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
   exit(0);

  }


void Undo(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

    fprintf(stderr,"request to undo last command\n");

 }


void Cut(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

    fprintf(stderr,"request to delete node or edge or text\n");

 }


void Paste(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

    fprintf(stderr,"request to paste node or edge or text\n");

 }

void Newnode(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

    fprintf(stderr,"request to make node \n");

 }
 
void Newedge(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

    fprintf(stderr,"request to make edge\n");

 }

void Reduce(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

    fprintf(stderr,"request to reduce images in screen\n");

 }

void Enlarge(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;

 {

    fprintf(stderr,"request to enlarge images in screen \n");

 }
