#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/AsciiText.h>
#include "draw.h"

#define LABELOFF -15

Widget w_popup,w_outer, w_type, w_name, w_files, w_id, w_device, w_ports;

extern Sc dbase;
extern graphics_data *data;
extern add_entry(),enterfile(),replace_node(); 
extern Graph load_file();
extern save_file();

int showing;

void saveentry(), DestroyPopup(), newfile(),bye();

init_show()
 {
   showing = 0;
  }
Widget get_entry(type,value)
char *type,*value;
  {
     Widget w;
     Arg args[5];
     Cardinal n;

     w = XtCreateManagedWidget("dialog",dialogWidgetClass,w_popup,NULL,0);
     XtSetArg(args[0],XtNlabel,type);
     XtSetArg(args[1],XtNvalue,value);
     XtSetValues(w,args,TWO);
     XtSetArg(args[0],XtNeditType,XawtextAppend);
     XtSetArg(args[1],XtNfromHoriz,XtNameToWidget(w,"label"));
     XtSetArg(args[2],XtNvertDistance,LABELOFF);
     XtSetValues(XtNameToWidget(w,"value"),args,THREE);

     return(w);
  }

void
OpenDialog(button,x,y)
Widget button;
Position x,y;

 {
   Widget out,w;
   Arg args[5];
   Cardinal n;

    n = 0;
    XtSetArg(args[n],XtNx,x);      n++;
    XtSetArg(args[n],XtNy,y);      n++;

    out = XtCreatePopupShell("prompt",transientShellWidgetClass,
                                      button,args,n);

    w = XtCreateManagedWidget("dialog",dialogWidgetClass,out,NULL,0);

    XtSetArg(args[0],XtNlabel,OPEN_MSG);
    XtSetArg(args[1],XtNvalue,"");
    XtSetValues(w,args,TWO);
    XawDialogAddButton(w,"Ok",newfile,NULL );
    XawDialogAddButton(w,"Cancel",bye,NULL);

    XtPopup(out,XtGrabNone);

 }
    

void
PopupPrompt(button,x,y,p)
Widget button;
Position x,y;
te    *p;

  {
     Arg args[5];
     Cardinal n;
     char s[128];
     Widget outside;

     if ( showing == 1 ) 
       {   fprintf(stderr,"showing is  %d\n",showing);
          return;
       }
     showing = 1;
     n = 0;
     XtSetArg(args[n],XtNx,x);      n++;
     XtSetArg(args[n],XtNy,y);      n++;
     XtSetArg(args[n],XtNresize,True);      n++;

    w_outer = XtCreatePopupShell("prompt",transientShellWidgetClass,
                                     button,args,n);

    XtSetArg(args[0],XtNvSpace,5);
    w_popup = XtCreateManagedWidget("box",boxWidgetClass,w_outer,args,1);

    w_type = get_entry("Type:",p->type);   
    if ( data->index == NULL )
             w_name = get_entry("Name:",p->name);   
    else
             w_name = get_entry("Name:",(data->index)->ports[0].name);   
    w_files = get_entry("Files:",p->files);   
    w_id = get_entry("Id:",p->id);   
    w_device = get_entry("Device:",p->device);
    w_ports = get_entry("Ports:",p->ports); 
  
    XawDialogAddButton(w_popup,"Save",saveentry,NULL );
    XawDialogAddButton(w_popup,"Cancel",DestroyPopup,NULL);

     XtPopup(w_outer,XtGrabNone);
  }


void saveentry(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

  {

     te  x;
     String ctype = XawDialogGetValueString(w_type);
     String cname = XawDialogGetValueString(w_name);
     String cfiles = XawDialogGetValueString(w_files);
     String cdevice = XawDialogGetValueString(w_device);
     String cports = XawDialogGetValueString(w_ports);
     String cid = XawDialogGetValueString(w_id);

     (void) sprintf(x.type,"%s",ctype);
     (void) sprintf(x.name,"%s",cname);
     (void) sprintf(x.files,"%s",cfiles);
     (void) sprintf(x.device,"%s",cdevice);
     (void) sprintf(x.ports,"%s",cports);
     (void) sprintf(x.id,"%s",cid);

     if (x.name[0] == '\0' || x.type[0] == '\0' )
        {
         showing = 0;
         XtDestroyWidget(w_outer);
         return;
        }
     if ( data->index == NULL )
      {
         x.pnum = enterfile(&x);
         add_entry(x.type);  
         data->entry =  ScInsert(dbase,&x);
         XtDestroyWidget(w_outer);
      }
     else if (data->index != NULL &&  strcmp(x.type,(data->entry)->type) == 0 && strcmp(x.files,(data->entry)->files)==0 && strcmp(x.device,(data->entry)->device)==0 && strcmp(x.ports,(data->entry)->ports)==0 && strcmp(x.name,(data->index)->ports[0].name) == 0 && strcmp(x.id,(data->entry)->id) == 0  )
          XtDestroyWidget(w_outer);
     else if (data->index != NULL &&  strcmp(x.type,(data->entry)->type) == 0 && strcmp(x.files,(data->entry)->files)==0 && strcmp(x.device,(data->entry)->device)==0 && strcmp(x.ports,(data->entry)->ports)==0 && strcmp(x.name,(data->index)->ports[0].name) != 0 && strcmp(x.id,(data->entry)->id) == 0  )
           {
             
             replace_name(data->index,x.name); 
             XtDestroyWidget(w_outer);
           }
     else if (data->index != NULL &&  (strcmp(x.type,(data->entry)->type) != 0 || strcmp(x.files,(data->entry)->files)!=0 || strcmp(x.device,(data->entry)->device)!=0 ||strcmp(x.name,(data->index)->ports[0].name)!= 0 || strcmp(x.id,(data->entry)->id) != 0) && strcmp(x.ports,(data->entry)->ports)==0  )
           {
             ScUpdate(data->entry,&x);
             XtDestroyWidget(w_outer);
           }
    else if (data->index != NULL &&  strcmp(x.type,(data->entry)->type) == 0 )
      {
          
          x.pnum = enterfile(&x);
          x.pnum = countports(&x);
          ScUpdate(data->entry,&x);
          data->width = ((x.pnum-1) * HALF_WIDTH) + NODE_W;
          XtDestroyWidget(w_outer);
          replace_node(data->index,&x);
     }
     else if ( data->index != NULL && strcmp(x.type,(data->entry)->type) != 0)
      {
          x.pnum = enterfile(&x);
          add_entry(x.type);
          data->entry = ScInsert(dbase,&x);
          strcpy((data->index)->type,x.type);
          data->width = ((x.pnum-1) * HALF_WIDTH) + NODE_W;
          XtDestroyWidget(w_outer);
          replace_node(data->index,&x);
       }
     else
          XtDestroyWidget(w_outer);
          
    showing = 0;

 }

void DestroyPopup(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

 {

    showing = 0;
    XtDestroyWidget(w_outer);

 }

void newfile(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

{
     Graph g;
     char s[100];
     String name = XawDialogGetValueString(XtParent(w));
     (void) sprintf(s,"%s",name);

    XtDestroyWidget(XtParent(XtParent(w)));
    if ( data->key == OPEN )
      {
          g =  load_file(s);
          if ( g != NULL )
           {
             gpDestroy(data->g);
	     XClearWindow(XtDisplay(data->w),XtWindow(data->w));
             data->g = g;
              refresh(g);
           }
       }
     else if ( data->key == SAVE && (data->g)->root != NULL )
       {
          save_file(data->g,s);
        }
}

void bye(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;

{

    XtDestroyWidget(XtParent(XtParent(w)));

}

