#include <stdio.h>
#include "draw.h"
#include <X11/Shell.h>
#include <X11/Xaw/Box.h> 
#include <X11/Xaw/Paned.h> 
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/StripChart.h>
#include <X11/cursorfont.h>

 extern init_show();
extern Graph load_file();

String fallback_resources[] = {
       "*input:   True",
       "*showGrip:   off",
       "*allowShellResize: True",
       "*outer.width:  650",
       "*outer.height: 400",
       "*Box*allowResize: True",
       "*outer.orientation: vertical",
       "*command.height: 30",
       "*command.width:  650",
       "*command.hSpace: 20",
       "*command.orientation: horizontal",
       "*Dialog*allowResize:  True",
       "*work.width:   650",
       "*work.height:  250",
       "*fileButton.label: File",
       "*fileButton*Foreground: red",
       "*editButton.label: Edit",
       "*editButton*Background: lightblue",
       "*selectButton.label: Delete",
       "*selectButton*Background: green",
       "*newButton.label: Protocols",
       "*newButton*Background: orange",
       "*optionButton.label: Refresh",
       "*optionButton*Background: orange",
       "*edgeButton.label: Edge",
       "*edgeButton*Foreground: red",
       "*edgeButton*Background: yellow",
       "*Dialog*value.resizable: TRUE",
       "*Dialog*value.resize: width",
       "*prompt*Background: black",
       "*dialog*Foreground: white",
       "*h_scroll.label: East_West",
       "*h_scroll*Background: green",
       "*v_scroll.label: North_South",
       "*v_scroll*Background: lightblue",
       "*work*Background: gray",
	 NULL,
};

graphics_data temp, *data;

void  resize(),expose();
extern built_base();
int WORK_H = 400;

void
getarguments(argc,argv,font,file)
int argc;
char **argv;
int  *font, *file;

 {
	int i;
	
	for(i=1; i < argc && argv[i] != NULL; i++)
	 {
		if ( !strcmp(argv[i],"-f") )
		     (*font) = ++i;
		else if ( *argv[i] != '-' )
		     (*file) = i;
	 }

 }
		
main(argc, argv)
    int argc;
    char **argv;
{
    XtAppContext app_con;
    Widget      toplevel, outer,command,work;
    int fonts = 0, file = 0;

    data = &temp;  

    toplevel = XtAppInitialize(&app_con, "Xhw", NULL,ZERO, &argc, argv,
                               fallback_resources,NULL,ZERO);

    outer = XtCreateManagedWidget("outer", panedWidgetClass,
			   toplevel, NULL, ZERO);
    
    command = XtCreateManagedWidget("command",boxWidgetClass,outer,NULL,ZERO);  
    make_com_bar(command);

    create_h_scroll(command);
    create_v_scroll(command);

    work = XtCreateManagedWidget("work",stripChartWidgetClass,outer,NULL,ZERO);


    data->w = work;
    getarguments(argc,argv,&fonts,&file);

    init_data(work,(fonts > 0 ? argv[fonts] : NULL));
    built_base();
    init_show();

    XtAddEventHandler(work,ButtonPressMask,FALSE,start_rubber_band,NULL);
    XtAddEventHandler(work,ButtonMotionMask,FALSE,track_rubber_band,NULL);
    XtAddEventHandler(work,ButtonReleaseMask,FALSE,end_rubber_band,NULL);

    XtAddEventHandler(work,ExposureMask,FALSE,expose,NULL);   
    
    XtRealizeWidget(toplevel);


   XGrabButton(XtDisplay(work),AnyButton,AnyModifier,XtWindow(work),
                TRUE, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
                GrabModeAsync, GrabModeAsync, XtWindow(work),
                XCreateFontCursor(XtDisplay(work),XC_crosshair));

   data->g =  file > 0 ? load_file(argv[file]) : gpNew();

    XtAppMainLoop(app_con);
}


void menu_expose(w,client_data,call_data)
Widget w;
caddr_t client_data, call_data;

 {
    XClearWindow(XtDisplay(data->w),XtWindow(data->w));
    refresh(data->g);

  }

void expose(w,client_data,call_data)
Widget w;
caddr_t client_data,call_data;

 {
  
   XClearWindow(XtDisplay(w),XtWindow(w));
   refresh(data->g);
 
 }

