/* 
 * filereceive.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>

#define max(A, B) ((A) < (B) ? (B) : (A))

main()
{
  struct  sockaddr_in	addr;
  struct  sockaddr_in	from;
  char  filename[256];
  char  buffer[64*1024];
  int   filesize;
  int	on = 1;
  int	s;
  int	size,n;
  long	buf[2*1024];
  int	len=8*1024, newlen;
  int	i;

  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = INADDR_ANY;
  addr.sin_port = htons(2051);
  if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
    printf("cannot open socket\n");
    exit(1);
  }	
  setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &on, sizeof (on));
  if (bind(s, &addr, sizeof(addr))) {
    printf("init_ether: cannot bind socket\n");
    exit(1);
  }
  while (1) {
    size = sizeof(from);
    newlen = recvfrom(s, buf, len, 0, &from, &size);
    if (buf[0] == -1) {
      strcpy(filename, &buf[1]);
      filesize = 0;
      bzero(buffer, sizeof buffer);
    } else if (buf[0] == -2) {
      FILE *x;
      printf("writing \"%s\", %d bytes\n", filename, filesize);
      fflush(stdout);
      x = fopen(filename, "w");
      fwrite(buffer, 1, filesize, x);
      fclose(x);
    } else {
      bcopy(&buf[2], &buffer[buf[0]], buf[1]);
      if (filesize != buf[0]) {
	printf("Old size = %d, new offset = %d\n", filesize, buf[0]);
	fflush(stdout);
      }
      filesize = max(filesize, buf[0] + buf[1]);
    }
  }
}
