/*
 * timerpc.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/********************************************************************
 *
 * Test/time Sprite RPC:  This user program will run a ping-pong timing test
 * for any protocol which uses the RPCaddr address type (e.g., spc,
 * select, lrpc).
 *
 * Boot parameters: (choose one of -s or -c, all others optional)
 *	
 *	-cHostname:  boot as client of Hostname 
 *
 *	-s:	     boot as server
 *
 *	-tTrips:     Number of round trips per test
 *
 *	-xTimes:     Number of tests run for each size
 *
 *	-pProtocol:  Top level RPC protocol to use
 *
 * The array "lens" lists the size for the arguments (and return value) of
 * each test.
 *
 ********************************************************************/

#include "xkernel.h"
#include "ip.h"
#include "rpcTypes.h"

static Protl IP, SELECT;
static unsigned short server_service_proc = 99;

#define IP_NULL { 0, 0, 0, 0 };

static  char	Request_buf[16*1024];
static  char	Reply_buf[16*1024];

IPhost client_host  = IP_NULL;
IPhost server_host  = IP_NULL;

RPCaddr SERVER;
char *SERVERNAME;

typedef struct {
  int sec, usec;
} time;

static time starttime, now, total;
#define TIMES 1
#define TRIPS 100
#define DELAY 3000
#define TOP_PROTOCOL "spc"

static times = TIMES;
static trips = TRIPS;
static char top_protocol[80];

static int lens[] = {
/*    2048, 3072 */
    1, 3*1024, 4*1024, 8*1024, 15*1024 
/*    15*1024, 15*1024, 15*1024, 8*1024, 15*1024, 4*1024, 3*1024, 2*1024, 1024, 1 */
/*    15*1024, 15*1024, 15*1024, 8*1024, 15*1024, 4*1024, 3*1024, 2*1024, 1024, 1, 1024, 2*1024, 3*1024, 4*1024, 8*1024, 15*1024 */
/*    1, 1024, 2*1024, 3*1024, 1024, 1*/
  }
;


int strtoi(s)
    char *s;
{
    int i = 0;

    while(1) {
	if (*s < '0' || *s > '9') return i;
	i *= 10;
	i += (*s - '0');
	s++;
    }
}


client()
{
  int p, s, i;
  int null();
  Part whom[2];
  int test = 0;
  int lenindex;
  int len;
  
  
  s = NULL;
  p = xcreateprotl(null, null, null);
  printf("I am the client, talking to %s\n", SERVERNAME);

  init_partlist(whom, 1, RPCaddr);
  set_part(whom, 0, SERVER);
  
  s = xopen(p, SELECT, whom);
  if (s > 0) {
    for (lenindex = 0; ; lenindex++) {
      if (lenindex >= sizeof(lens)/sizeof(long)) {
	  while(1);
      }
      len = lens[lenindex];
      for (test = 0; test < times; test++) {
	printf("Starting test (%d) ...\n", test);
	xgettime(&starttime);
	try_call(s, trips, len);
	xgettime(&now);
	subtime(&starttime, &now, &total);
	printf("len = %d/%d, %d trips: %6d.%-6d\n", 
	       len, len, trips, total.sec, total.usec);
	xpause(DELAY);
      }
    }
  } else {
    printf("Not sending, other host not up\n");
  }
}
  
server()
{
  int serverdemux(), null(), p;
  Part whom[2];
  printf("I am the  server (%s) %d\n", SERVERNAME, server_service_proc);

  
  init_partlist(whom, 1, RPCaddr);
  set_part(whom, 0, SERVER);
  
  p = xcreateprotl(serverdemux, null, null);
  (void) xopenenable(p, SELECT, whom);
}


user(argc, argv)
int argc;
char **argv;
{
  IPhost my_iphost, nametoip();
  
  printf("RPC timing test\n");
  IP = xgetprotlbyname("ip");
  SERVER.host = server_host;
  SERVER.command = server_service_proc;
  SERVERNAME = SITE_SERVER_NAME;
  strcpy(top_protocol, TOP_PROTOCOL);
  if (xcontrolprotl(IP, GETMYADDR, &my_iphost, sizeof(IPhost)) != 
      sizeof(IPhost)) {
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("My IP addr = %d.%d.%d.%d\n", my_iphost.a, my_iphost.b,
	   				 my_iphost.c, my_iphost.d);
  }

  while (argc > 1) {
    if (!strncmp(argv[1], "-s", 2)) {
      SERVER.host = my_iphost;
      SERVERNAME = malloc(24);
      iptoname(SERVER.host, SERVERNAME);
    } else if (!strncmp(argv[1], "-c", 2)) {
      client_host = my_iphost;
      SERVERNAME = &argv[1][2];
      SERVER.host = nametoip(SERVERNAME);
    } else if (!strncmp(argv[1], "-x", 2)) {
	times = strtoi(&argv[1][2]);
    } else if (!strncmp(argv[1], "-t", 2)) {
	trips = strtoi(&argv[1][2]);
    } else if (!strncmp(argv[1], "-p", 2)) {
	strcpy(top_protocol, &argv[1][2]);
    } else {
	printf("Unrecognized flag %s\n", argv[1]);
    }
    argc --;
    argv++;
  }
  if ((SELECT = xgetprotlbyname(top_protocol)) == NULL) {
      printf("Could not open protocol %s\n", top_protocol);
      return;
  } else {
      printf("protocol: %s\n", top_protocol);
  }
  if (IP_EQUAL(my_iphost, SERVER.host)) {
    xcreateprocess(server, 5, 0);
  }
  if (IP_EQUAL(my_iphost, client_host)) {
    xcreateprocess(client, 6, 0);
  }
}

null(s,m,length)
int s, length;
char *m;
{
}

serverdemux(s, m, length)
int s, length;
char *m;
{
  xpush(s, Reply_buf, length, 0, 0);
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}

try_call(sessn, times, length)
Sessn		sessn;
int		times;
int		length;
{
  int reply_len;
  int ret_val;
  int i;
  int l = sizeof(Reply_buf);

  for (i=0; i<times; i++) {
      reply_len = l;
      ret_val = xpush(sessn,Request_buf,length,Reply_buf,&reply_len);

      if (reply_len != length) {
	  printf("Bizarre reply length.  Expected %d, received %d\n",
		 length, reply_len);
      }

      if( ret_val < 0 ) {
	  printf( "SELECT CLIENT: SELECT CALL GOT ERR %d\n",ret_val );
      }
  }
}
