/********************************************************************
/*
/* Test Lightweight RPC
/*	TRIPS: number of round trips per test
/*	TESTS: number of tests run
/*	REQ_BUF_SZ: size of request message (range between 1 and 16k)
/*	REQ_BUF_SZ: size of reply message (range between 1 and 16k)
/*
/********************************************************************/

#include "xkernel.h"
#include "lrpc.h"
#include "aspace.h"
#include "site.h"

static PROTL LRPC,ASPACE;

static LRPCaddr server_proc = 99;

#define REQ_BUF_SZ  0
#define REP_BUF_SZ 0
/* #define REP_BUF_SZ  8*1024 */

static  char	Request_buf[16*1024];
static  char	Reply_buf[16*1024];

typedef struct {
  int sec, usec;
} time;

static time starttime, now, total;
#define TRIPS 10000
#define TIMES 5
#define DELAY 2000

static char new[] = "notuser\0";

client()
{
  int p, s, i;
  int null();
  PART whom[3];
  int test = 0;

  s = NULL;
  p = xcreateprotl(null, null, null);
  printf("I am the client\n");
  whom[0].address = (char *)&server_proc;
  whom[0].length = sizeof(LRPCaddr);
  whom[1].address = (char *)0;
  whom[1].length = 0;
  s = xopen(p, LRPC, whom);
  for (test = 0; test < TIMES; test++) {
    startProfile();
    printf("Starting test (%d) ...\n", test);
    xgettime(&starttime);
    for (i = 0; i<TRIPS; i++)
	 try_call(s);
    xgettime(&now);
    endProfile();
    subtime(&starttime, &now, &total);
    printf("len = %d/%d, %d trips: %6d.%-6d\n", 
      REQ_BUF_SZ, REP_BUF_SZ, TRIPS, total.sec, total.usec);
    xpause(DELAY);
  }
}
  
server()
{
  int serverdemux(), null(), p;
  PART whom[2];

  printf("I am the  server (%d)\n", server_proc);
  whom[0].address = (char *)&server_proc;
  whom[0].length = sizeof(LRPCaddr);
  whom[1].address = (char *)0;
  whom[1].length = 0;
  p = xcreateprotl(serverdemux, null, null);
  (void) xopenenable(p, LRPC, whom);
}

user(argc, argv)
int argc;
char **argv;
{
  LRPC = xgetprotlbyname("lrpc");
  ASPACE = xgetprotlbyname("aspace");

  if (!strcmp(argv[0], "user")) {
    printf("Lightweight RPC timing test\n");
    xcontrolprotl(ASPACE, ASPACE_CLONE, new, sizeof(new));
    xpause(DELAY);
    client();
  } else
    server();
}

null(s,m,length)
int s, length;
char *m;
{
}

serverdemux(s, m, length)
int s, length;
char *m;
{
  xpush(s, Reply_buf, REP_BUF_SZ, 0, 0);
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}

try_call(sessn)
SESSN		sessn;
{
  int		reply_len;
  int		ret_val;

  reply_len = REP_BUF_SZ;
  ret_val = xpush(sessn,Request_buf,REQ_BUF_SZ,Reply_buf,&reply_len);
  if( ret_val < 0 ) {
    printf( "LRPC CLIENT: LRPC CALL GOT ERR %d\n",ret_val );
  }
}
