h44489
s 00053/00003/00193
d D 1.4 91/02/04 16:06:59 menze 4 3
c hosts can now be specified with numeric IP addresses
e
s 00014/00013/00182
d D 1.3 91/01/10 11:27:19 llp 3 2
c Prepared for 3.1 Distribution
e
s 00036/00031/00159
d D 1.2 90/12/09 00:47:37 menze 2 1
c 
e
s 00190/00000/00000
d D 1.1 90/12/09 00:47:07 menze 1 0
c date and time created 90/12/09 00:47:07 by menze
e
u
U
f e 0
t
T
I 2
/*
 * timeudp.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
D 3
 *
E 3
I 3
 */

E 3
E 2
I 1
/********************************************************************
D 3
/*
/* Test UDP
/*	TRIPS: number of round trips per test
/*	TIMES: number of tests run
/*	Set message size by defining one of the following:
/*		ONESHOT = 1 byte
/*		LITTLE = 1, 200, 400, ... 1400 bytes
/*
/********************************************************************/
E 3
I 3
 *
 * Test UDP
 *	TRIPS: number of round trips per test
 *	TIMES: number of tests run
 *	Set message size by defining one of the following:
 *		ONESHOT = 1 byte
 *		LITTLE = 1, 200, 400, ... 1400 bytes
 *
 ********************************************************************/
E 3

D 2
#define BIG
E 2
I 2
#define LITTLE
E 2

#include "xkernel.h"
#include "ip.h"
#include "udp.h"
D 3
#include "site.h"
E 3
I 2
#undef assert
#define assert(x) 
E 2

I 4
#define IP_NULL { 0, 0, 0, 0 };


E 4
D 3
static PROTL IP, UDP;
E 3
I 3
static Protl IP, UDP;
E 3
static unsigned short clientport = 2001;
static unsigned short serverport = 2002;

D 2
IPaddr client_host = SITE_CLIENT_IP;
IPaddr server_host = SITE_SERVER_IP;
E 2
I 2
IPhost client_host = SITE_CLIENT_IP;
IPhost server_host = SITE_SERVER_IP;
I 4
IPhost ip_null = IP_NULL;

E 4
E 2
UDPaddr CLIENT, SERVER;
char *SERVERNAME;

typedef struct {
  int sec, usec;
} time;

static time starttime;
static int gotone;
static int count;
D 2
#define TRIPS 1000
#define TIMES 1
E 2
I 2
D 4
#define TRIPS 10000
E 4
I 4
#define TRIPS 1000
E 4
#define TIMES 5
E 2
#define DELAY 2000
D 2
static char message[8 * 1024];
static int len;
E 2

client()
{
  int p, s;
  int clientdemux(), null();
D 2
  PART whom[3];
E 2
I 2
  Part whom[3];
  static char message[8 * 1024];
E 2
  int test = 0;
D 2
  int lenindex;
E 2
I 2
  int lenindex, len;
E 2
  static int lens[] = { 
#ifdef ONESHOT
    1,
#endif
#ifdef LITTLE
    1, 200, 400, 600, 800, 1000, 1200, 1400, 1024,
#endif  
D 2
#ifdef BIG
    1024, 2048, 3072, 4096, 5120, 6144, 7168, 8192,
#endif  
E 2
  };

  s = NULL;
  p = xcreateprotl(clientdemux, null, null);
D 2
  printf("I am the client, talking to %s\n", SERVERNAME);
  whom[0].address = (char *) &CLIENT;
  whom[0].length = sizeof(UDPaddr);
  whom[1].address = (char *)&SERVER;
  whom[1].length = sizeof(UDPaddr);
  whom[2].address = (char *)0;
  whom[2].length = 0;
E 2
I 2
  printf("I am the client, talking to %s <%d.%d.%d.%d>\n", SERVERNAME,
	 SERVER.host.a, SERVER.host.b, SERVER.host.c, SERVER.host.d);
  init_partlist(whom, 2, UDPaddr);
  set_part(whom, 0, CLIENT);
  set_part(whom, 1, SERVER);
E 2
  for (lenindex = 0; ; lenindex++) {
    if (lenindex >= sizeof(lens)/sizeof(long)) lenindex = 0;
    len = lens[lenindex];
    for (test = 0; test < TIMES; test++) {
      if (s <= 0) s = xopen(p, UDP, whom);
      if (s > 0) {
	printf("Sending (%d) ...\n", test);
	count = 0;
#ifdef PROFILE
	startProfile();
#endif
	xgettime(&starttime);
	xpush(s, message, len, 0, 0);
      } else {
	printf("Not sending, other host not up\n");
      }
      do {
	gotone = 0;
	xpause(DELAY);
      } while (gotone);
I 2
      if (count < TRIPS) {
	printf("Test failed after receiving %d packets\n", count);
      }
E 2
    }
  }
}
  
server()
{
  int serverdemux(), null(), p;
D 2
  PART whom[2];
E 2
I 2
  Part whom[2];
E 2
  printf("I am the  server (%s)\n", SERVERNAME);
D 2
  whom[0].address = (char *) &SERVER.port;
  whom[0].length = 2;
  whom[1].address = (char *)0;
  whom[1].length = 0;
E 2
I 2
  init_partlist(whom, 1, UDPaddr);
  set_part(whom, 0, SERVER);
E 2
  p = xcreateprotl(serverdemux, null, null);
  (void) xopenenable(p, UDP, whom);
}

I 4

int strtoi(s)
    char *s;
{
    int i = 0;

    while(1) {
	if (*s < '0' || *s > '9') return i;
	i *= 10;
	i += (*s - '0');
	s++;
    }
}


IPhost addresstoip(s)
  char *s;
{
  IPhost h;
  char *t;
  int i;

  t = s;
  for (i=0; i<3; i++) {
      if (t = index(s, '.')) {
	  *((char *)&h + i) = strtoi(s);
	  s = t+1;
      } else {
	  return ip_null;
      }
  }
  h.d = strtoi(s);
  return h;
}    



E 4
user(argc, argv)
int argc;
char **argv;
{
D 2
  IPaddr ipaddr, nametoip();
E 2
I 2
  char arr[24];
  IPhost ipaddr, nametoip();
E 2
  printf("UDP timing test\n");
  IP = xgetprotlbyname("ip");
  UDP = xgetprotlbyname("udp");
  CLIENT.host = client_host;
  SERVER.host = server_host;
  SERVERNAME = SITE_SERVER_NAME;
D 2
  if (xcontrolprotl(IP, MYADDR, &ipaddr, sizeof(IPaddr)) != sizeof(IPaddr)) {
E 2
I 2
D 3
  if (xcontrolprotl(IP, MYADDR, &ipaddr, sizeof(IPhost)) != sizeof(IPhost)) {
E 3
I 3
  if (xcontrolprotl(IP, GETMYADDR, &ipaddr, sizeof(IPhost)) != 
      sizeof(IPhost)) {
E 3
E 2
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("My IP addr = %d.%d.%d.%d\n", ipaddr.a, ipaddr.b, ipaddr.c, ipaddr.d);
  }

  while (argc > 1) {
    if (!strncmp(argv[1], "-s", 2)) {
      SERVER.host = ipaddr;
      SERVERNAME = malloc(24);
      iptoname(SERVER.host, SERVERNAME);
      CLIENT.host.a = CLIENT.host.b = CLIENT.host.c = CLIENT.host.d = 0;
    } else if (!strncmp(argv[1], "-c", 2)) {
      CLIENT.host = ipaddr;
D 2
      SERVERNAME = &argv[1][2];
E 2
I 2
      SERVERNAME = malloc(24);
      strcpy(SERVERNAME, &argv[1][2]);
E 2
D 4
      SERVER.host = nametoip(SERVERNAME);
E 4
I 4
      if (*SERVERNAME >= '0' && *SERVERNAME <= '9') {
	SERVER.host = addresstoip(SERVERNAME);
      } else {
	SERVER.host = nametoip(SERVERNAME);
      }
E 4
    }
    argc --;
    argv++;
  }
  CLIENT.port = clientport;
  SERVER.port = serverport;
  if (IP_EQUAL(ipaddr, SERVER.host)) {
    xcreateprocess(server, 5, 0);
  }
  if (IP_EQUAL(ipaddr, CLIENT.host)) {
    xcreateprocess(client, 6, 0);
  }
}

null(s,m,length)
int s, length;
char *m;
{
}

clientdemux(s, m, length)
int s, length;
char *m;
{
  time now, total;
  gotone = 1;
  if (++count < TRIPS) {
D 2
    xpush(s, message, len, 0, 0);
E 2
I 2
D 4
    xpush(s, m, length, 0, 0);
E 4
I 4
#if 0
    printf("\nround trip %d\n\n", count);  
    DisplayProcesses();  
#endif
    xpush(s, m, length, (char *)0, (int *)0); 
E 4
E 2
  } else {
    xgettime(&now);
    subtime(&starttime, &now, &total);
    printf("len = %4d, %d trips: %6d.%-6d\n", 
D 2
      len, TRIPS, total.sec, total.usec);
E 2
I 2
      length, TRIPS, total.sec, total.usec);
E 2
#ifdef PROFILE
	endProfile();
#endif
  }
}

serverdemux(s, m, length)
int s, length;
char *m;
{
D 2
  static char answer[1];
  xpush(s, answer, 1, 0, 0);
E 2
I 2
  xpush(s, m, length, 0, 0);
E 2
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}
E 1
