h15207
s 00158/00000/00000
d D 1.1 90/12/09 00:24:13 menze 1 0
c date and time created 90/12/09 00:24:13 by menze
e
u
U
f e 0
t
T
I 1
/********************************************************************
/*
/* Test Sprite RPC
/*	TRIPS: number of round trips per test
/*	TESTS: number of tests run
/*	REQ_BUF_SZ: size of request message (range between 1 and 16k)
/*	REQ_BUF_SZ: size of reply message (range between 1 and 16k)
/*
/********************************************************************/

#include "xkernel.h"
#include "ip.h"
#include "spc.h"
#include "site.h"

static PROTL IP, SPC;

static unsigned short server_service_proc = 99;

#define REQ_BUF_SZ  1
#define REP_BUF_SZ  8*1024

static  char	Request_buf[16*1024];
static  char	Reply_buf[16*1024];

IPaddr client_host  = SITE_CLIENT_IP;
IPaddr server_host  = SITE_SERVER_IP;

SPCaddr SERVER;
char *SERVERNAME;

typedef struct {
  int sec, usec;
} time;

static time starttime, now, total;
#define TRIPS 100
#define TIMES 5
#define DELAY 2000

client()
{
  int p, s, i;
  int null();
  PART whom[3];
  int test = 0;

  s = NULL;
  p = xcreateprotl(null, null, null);
  printf("I am the client, talking to %s\n", SERVERNAME);
  whom[0].address = (char *) &p;
  whom[0].length = sizeof(p);
  whom[1].address = (char *)&SERVER;
  whom[1].length = sizeof(SPCaddr);
  whom[2].address = (char *)0;
  whom[2].length = 0;
  s = xopen(p, SPC, whom);
  for (test = 0; test < TIMES; test++) {
    printf("Starting test (%d) ...\n", test);
    xgettime(&starttime);
    for (i = 0; i<TRIPS; i++)
	 try_call(s);
    xgettime(&now);
    subtime(&starttime, &now, &total);
    printf("len = %d/%d, %d trips: %6d.%-6d\n", 
      REQ_BUF_SZ, REP_BUF_SZ, TRIPS, total.sec, total.usec);
    xpause(DELAY);
  }
}
  
server()
{
  int serverdemux(), null(), p;
  PART whom[2];
  printf("I am the  server (%s) %d\n", SERVERNAME, server_service_proc);
  whom[0].address = (char *) &server_service_proc;
  whom[0].length = 2;
  whom[1].address = (char *)0;
  whom[1].length = 0;
  p = xcreateprotl(serverdemux, null, null);
  (void) xopenenable(p, SPC, whom);
}

user(argc, argv)
int argc;
char **argv;
{
  IPaddr ipaddr, nametoip();
  printf("SPC timing test\n");
  IP = xgetprotlbyname("ip");
  SPC = xgetprotlbyname("spc");
  SERVER.srvr_host = server_host;
  SERVER.service_proc = server_service_proc;
  SERVERNAME = SITE_SERVER_NAME;
  if (xcontrolprotl(IP, MYADDR, &ipaddr, sizeof(IPaddr)) != sizeof(IPaddr)) {
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("My IP addr = %d.%d.%d.%d\n", ipaddr.a,ipaddr.b,ipaddr.c,ipaddr.d);
  }

  while (argc > 1) {
    if (!strncmp(argv[1], "-s", 2)) {
      SERVER.srvr_host = ipaddr;
      SERVERNAME = malloc(24);
      iptoname(SERVER.srvr_host, SERVERNAME);
    } else if (!strncmp(argv[1], "-c", 2)) {
      client_host = ipaddr;
      SERVERNAME = &argv[1][2];
      SERVER.srvr_host = nametoip(SERVERNAME);
    }
    argc --;
    argv++;
  }
  if (IP_EQUAL(ipaddr, SERVER.srvr_host)) {
    xcreateprocess(server, 5, 0);
  }
  if (IP_EQUAL(ipaddr, client_host)) {
    xcreateprocess(client, 6, 0);
  }
}

null(s,m,length)
int s, length;
char *m;
{
}

serverdemux(s, m, length)
int s, length;
char *m;
{
  xpush(s, Reply_buf, REP_BUF_SZ, 0, 0);
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}

try_call(sessn)
SESSN		sessn;
{
  int		reply_len;
  int		ret_val;

  reply_len = REP_BUF_SZ;
  ret_val = xpush(sessn,Request_buf,REQ_BUF_SZ,Reply_buf,&reply_len);
  if( ret_val < 0 ) {
    printf( "SPC CLIENT: SPC CALL GOT ERR %d\n",ret_val );
  }
}
E 1
