h63782
s 00015/00018/00204
d D 1.2 91/01/10 11:27:32 llp 2 1
c Prepared for 3.1 Distribution
e
s 00222/00000/00000
d D 1.1 90/12/09 00:49:22 menze 1 0
c date and time created 90/12/09 00:49:22 by menze
e
u
U
f e 0
t
T
I 1
/*
 * timeip.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
D 2
 *
E 2
I 2
 */

E 2
/********************************************************************
D 2
/*
/* Test IP
/*	TRIPS: number of round trips per test
/*	TIMES: number of tests run
/*	Set message size by defining one of the following:
/*		ONESHOT = 1 byte
/*		LITTLE = 1, 200, 400, ... 1400 bytes
/*		BIG = 1k, 2k, 3k, ... 8k bytes
/*
/*  Modified for version 3.1 071890 cliff
/********************************************************************/
E 2
I 2
 *
 * Test IP
 *	TRIPS: number of round trips per test
 *	TIMES: number of tests run
 *	Set message size by defining one of the following:
 *		ONESHOT = 1 byte
 *		LITTLE = 1, 200, 400, ... 1400 bytes
 *		BIG = 1k, 2k, 3k, ... 8k bytes
 *
 *********************************************************************/
E 2

#define BIG

#include "xkernel.h"
#include "eth.h"
D 2



E 2
#include "ip.h"
D 2
#include "site.h"
E 2

static IPhost CLIENT = SITE_CLIENT_IP;
static IPhost SERVER = SITE_SERVER_IP;
char *CLIENTNAME;
char *SERVERNAME;

D 2
PROTL IP;
E 2
I 2
Protl IP;
E 2

typedef struct {
  int sec, usec;
} time;

#define TRIPS 10000
#define TIMES 5
#define DELAY 2000

static unsigned char myprotocol = 87;
static int gotone = 0;
static time starttime;
static int count = 0;

client()
{
  int p, s1, test;
  int clients(), null(), i;
  Part whom[3];
  static long message[8*1024/sizeof(long)];
  IPhost ipa;
  IPaddr clnt, srvr;
  int lenindex, len;
  static int lens[] = { 
#ifdef ONESHOT
    1,
#endif
#ifdef LITTLE
    1, 200, 400, 600, 800, 1000, 1200, 1400,
#endif  
#ifdef BIG
    1*1024, 2*1024, 3*1024, 4*1024, 5*1024, 6*1024, 7*1024, 8*1024,
#endif
  };

  init_partlist(whom, 2, IPaddr);
  clnt.protocolnum = myprotocol;
  clnt.host = CLIENT;
  srvr.protocolnum = myprotocol;
  srvr.host = SERVER;  
  set_part(whom, 0, clnt);
  set_part(whom, 1, srvr);

/* these lines replaced by above 7 lines -- may be removed if it works
                                                        071890 cliff
  whom[0].address = (char *) &myprotocol;
  whom[0].length = sizeof(char);
  whom[1].address = (char *) &SERVER;
  whom[1].length = sizeof(IPaddr);
  whom[2].address = (char *)0;
  whom[2].length = 0;
*/
  p = xcreateprotl(clients, null, null);
  printf("I am the client (%s) talking to %s\n", CLIENTNAME, SERVERNAME);
  s1 = NULL;
  for (lenindex = 0; ; lenindex++) {
    if (lenindex >= sizeof(lens)/sizeof(long)) lenindex = 0;
    len = lens[lenindex];
    for (test = 0; test < TIMES; test++) {
      if (s1 <= 0) s1 = xopen(p, IP, whom);
      if (s1 > 0) {
	printf("Sending (%d bytes) (%d) ...\n", len, test);
	count = 0;
	xgettime(&starttime);
	xpush(s1, message, len, 0, 0);
      } else {
	printf("Not sending, other host not up\n");
      }
      do {
	gotone = 0;
	xpause(DELAY);
      } while (gotone);
    }
  }
}

server()
{
  int p, s1, test;
  int servers(), null(), i;
  Part whom[2];
  IPaddr srvr;
  IPhost ipa;
  printf("I am the server (%s)\n", SERVERNAME);
  p = xcreateprotl(servers, null, null);
  s1 = NULL;

  init_partlist(whom, 1, IPaddr);
  srvr.protocolnum = myprotocol;
  srvr.host = SERVER;  
  set_part(whom, 0, srvr);

/* these lines replaced by above macros -- can be removed if it works
  whom[0].address = (char *) &myprotocol;
  whom[0].length = sizeof(char);
  whom[1].address = (char *)0;
  whom[1].length = 0;
*/

  s1 = xopenenable(p, IP, whom);
}

user(argc, argv)
int argc;
char **argv;
{
  IPhost ipaddr, nametoip();
  printf("IP timing test\n");
  IP = xgetprotlbyname("ip");
  CLIENTNAME = SITE_CLIENT_NAME;
  SERVERNAME = SITE_SERVER_NAME;
D 2
  if (xcontrolprotl(IP, MYADDR, &ipaddr, sizeof(IPhost)) != sizeof(IPhost)) {
E 2
I 2
  if (xcontrolprotl(IP, GETMYADDR, &ipaddr, sizeof(IPhost)) != 
      sizeof(IPhost)) {
E 2
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("My IP addr = %d.%d.%d.%d\n",ipaddr.a,ipaddr.b,ipaddr.c,ipaddr.d);
  }

  while (argc > 1) {
    if (!strncmp(argv[1], "-s", 2)) {
      SERVER = ipaddr;
      SERVERNAME = malloc(24);
      iptoname(SERVER, SERVERNAME);
      CLIENT.a = CLIENT.b = CLIENT.c = CLIENT.d = 0;
    } else if (!strncmp(argv[1], "-c", 2)) {
      CLIENT = ipaddr;
      CLIENTNAME = malloc(24);
      iptoname(CLIENT, CLIENTNAME);
      SERVERNAME = &argv[1][2];
      SERVER = nametoip(SERVERNAME);
    }
    argc --;
    argv++;
  }
  if (IP_EQUAL(ipaddr, SERVER)) {
    xcreateprocess(server, 5, 0);
  }
  if (IP_EQUAL(ipaddr, CLIENT)) {
    xcreateprocess(client, 6, 0);
  }
}

printtime(m, t)
char *m;
time *t;
{
  printf("%s%6d:%-6d\n", m, t->sec, t->usec);
}

null()
{
}

clients(s, m, length)
int s, length;
char *m;
{
  time now, total;
  gotone = 1;
  if (++count < TRIPS) {
    xpush(s, m, length, 0, 0);
  } else {
    xgettime(&now);
    subtime(&starttime, &now, &total);
    printf("len = %d, %d trips: %d.%-6d\n", 
      length, TRIPS, total.sec, total.usec);
  }
}

servers(s, m, length)
int s, length;
char *m;
{
  xpush(s, m, length, 0, 0);
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}
E 1
