h58215
s 00004/00003/00050
d D 1.2 91/01/10 11:27:27 llp 2 1
c Prepared for 3.1 Distribution
e
s 00053/00000/00000
d D 1.1 90/12/09 00:48:32 menze 1 0
c date and time created 90/12/09 00:48:32 by menze
e
u
U
f e 0
t
T
I 1
/*
 * testboot.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "eth.h"
#include "ip.h"
#include "dns.h"

D 2
static PROTL IP, ETH, DNS;
E 2
I 2
static Protl IP, ETH, DNS;
E 2

user(argc, argv)
int argc;
char **argv;
{
  IPhost ipaddr;
  ETHhost eaddr;
  Result r;
  int sz;

  printf("x-kernel booted successfully (go ahead, \"ping\" me)\n\n");
  IP = xgetprotlbyname("ip");
  ETH = xgetprotlbyname("eth");
  DNS = xgetprotlbyname("dns");

D 2
  if (xcontrolprotl(ETH, MYADDR, &eaddr, 6) != 6) {
E 2
I 2
  if (xcontrolprotl(ETH, GETMYADDR, &eaddr, 6) != 6) {
E 2
    printf("Cannot get my own ethernet address\n");
    return;
  } else {
    printf("Ethernet Address = %x.%x.%x\n",eaddr.high,eaddr.mid,eaddr.low);
  }

D 2
  if (xcontrolprotl(IP, MYADDR, &ipaddr, sizeof(IPhost)) != sizeof(IPhost)) {
E 2
I 2
  if (xcontrolprotl(IP, GETMYADDR, &ipaddr, sizeof(IPhost)) != 
      sizeof(IPhost)) {
E 2
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("IP Address = %d.%d.%d.%d\n",ipaddr.a,ipaddr.b,ipaddr.c,ipaddr.d);
    sprintf((char* )&r, "%d.%d.%d.%d",ipaddr.a,ipaddr.b,ipaddr.c,ipaddr.d);
  }
  sz = sizeof(Result);
  if (xcontrolprotl(DNS, RRESOLVE, (char *)&r, sz) < 0) {
    printf("Cannot translate my ip address into my domain name\n");
    return;
  } else {
    printf("Domain Name = %s\n", r.name);
  }
}


E 1
