#include "upi.h"
#include "ether.h"
#include "ip.h"
#include "udp.h"

extern	IPaddr	myipaddr;
extern SESSN xopen();

user(argc,argv)
int	argc;
char	*argv[];
{
  IPaddr yripaddr;
  UDPaddr myudpaddr, yrudpaddr;
  SESSN	s;
  PART	part[2];
  int	i,j, usr;
  unsigned long you;
  int server_demux(), client_demux(), user_opendone();

  if (argc==0) {				/* be the server */
    printf("I'm a server\n");
    usr = xcreateprotocol(server_demux, user_opendone);
    myudpaddr.port = 1200;
    myudpaddr.host = myipaddr;
    part[0].address = (char *) &myudpaddr;
    part[0].length = UDPADLEN;
    xopenenable(usr, UDP, part);
  }
  else {					/* be the client */
    printf("I'm a client\n");
    usr = xcreateprotocol(client_demux, user_opendone);
    you=inet_addr(argv[0]);
    yripaddr = *(IPaddr *)&you;
    for (i=0; i<1000; i++) xyield();
    myudpaddr.port = 1300;
    myudpaddr.host = myipaddr;
    part[0].address = (char *) &myudpaddr;
    part[0].length = UDPADLEN;
    yrudpaddr.port = 1200;
    yrudpaddr.host = yripaddr;
    part[1].address = (char *) &yrudpaddr;
    part[1].length = UDPADLEN;
    if ((s=xopen(usr, UDP, part)) < 0) {
      printf("unknown receiver\n");
    } else {
      xpush(s, "hello user", 11);
/*      xclose(s); */
    }
  }
}

user_opendone(s)
SESSN s;
{
  printf("--->in user_opendone\n");
}

server_demux(s, buf, len)
SESSN	s;
char	*buf;
int len;
{
  printf("--->in server_demux with msg **%.*s**\n", len, buf);
  xpush(s, "hello to you", 13);
  return(0);
}

#define LIMIT 100
client_demux(s, buf, len)
SESSN	s;
char *buf;
int len;
{
  static int nreceived = 0;
  printf("--->in client_demux with msg **%.*s**\n", len, buf);
  if (++nreceived < LIMIT) {
    xpush(s, buf, len);
  } else {
    xclose(s);
    xexit(0);
  }
}
