/* 
 * debug.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "debug.h"
#include "process.h"

#ifndef NDEBUG
int
	tracebuserror,
	tracecustom,
	traceether,
	traceevent,
	tracefixme,
	traceidle,
	traceie,
	tracememoryinit,
	traceprocesscreation,
	traceprocessswitch,
	traceprotocol,
	tracetick,
	tracetrap,
	traceuser;

/*VARARGS2*/
void trace(level, format, nargs, a1, a2, a3, a4, a5)
int level;
char *format;
int nargs;
int a1, a2, a3, a4, a5;
{
#ifndef XSIMUL
  register int x = spl7();
#endif
  while (--level > 0) printf(" ");
  switch (nargs) {
    case 0:
      printf(format);
      break;
    case 1:
      printf(format, a1);
      break;
    case 2:
      printf(format, a1, a2);
      break;
    case 3:
      printf(format, a1, a2, a3);
      break;
    case 4:
      printf(format, a1, a2, a3, a4);
      break;
    case 5:
      printf(format, a1, a2, a3, a4, a5);
      break;
    default:
      break;
  }
  printf("\n");
#ifndef XSIMUL
  splx(x);
#endif
}
char assertMessage[] = "Assertion failed: file %s, line %d\n";
#endif
