h11437
s 00036/00000/00000
d D 1.1 91/01/10 11:14:46 llp 1 0
c date and time created 91/01/10 11:14:46 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * idmap.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef idmap_h
#define idmap_h

typedef struct mapelement {
  struct mapelement *next;
  int internalid;
  char externalid[1];
} MapElement, *Bind;

typedef struct {
  int nEntries, keySize;
  MapElement *cache;
  MapElement *freelist;
  MapElement **table;
  int	(*resolve)();
  Bind	(*bind)();
  int	(*unbind)();
} *Map;

#define map_resolve(map, key) (map)->resolve(map, key)
#define map_bind(map, key, value)   (map)->bind(map, key, value)
#define map_unbindbinding(map, binding) \
  (map)->unbind((map), (binding)->externalid, (binding)->internalid)
#define map_unbind(map, key, value) (map)->unbind(map, key, value)
extern void map_close();
extern Map map_create(/* int nEntries, int keySize */);

#endif /* idmap_h */
E 1
