/* 
 * spc_clnt.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 *
 */

#include "xkernel.h"
#include "ip.h"
#include "spc.h"
#include "spc_internal.h"


/*
 * SPC_OPEN
 *
 * This is invoked only by "client protocols" (servers will use openenable).
 */

XObj spc_open( self, higher_level_protl, spc_participants )
     XObj	self;
     XObj	higher_level_protl;
     Part*	spc_participants;
{
  RPCaddr*	srvr_spc_addr_ptr;
  CLNT_KEY	clnt_key;
  XObj		sessn;
  SPCstate*	state_ptr;
  
  TRACE0(spcp,3,"spc_open");
  
  /* check if there is already a sessn for this client key */
  /* client key == srvr_host + srvrId */
  srvr_spc_addr_ptr = (RPCaddr*)spc_participants[0].address;
  clnt_key.srvr_host = srvr_spc_addr_ptr->host;
  clnt_key.srvrId = srvr_spc_addr_ptr->command;
  sessn = (XObj) map_resolve( Clnt_map, (char*) &clnt_key );
  if( sessn != ERR_XOBJ ){
    /* the sessn already exists, share it */
    TRACE0(spcp,1,"spc_open: sessn already exists");
    sessn->rcnt++;
    return( sessn );
  }
  
  /* create the SPC sessn, and add it to the Clnt_map */
  TRACE5(spcp,4,"spc_open: creating new sessn for call to %d.%d.%d.%d (%d)",
	 srvr_spc_addr_ptr->host.a,srvr_spc_addr_ptr->host.b,
	 srvr_spc_addr_ptr->host.c,srvr_spc_addr_ptr->host.d,
	 srvr_spc_addr_ptr->command);
  sessn = x_createsession( ERR_XOBJ, SPC_SELF, 1 ); /* wildcard hlp */
  sessn->binding = map_bind( Clnt_map, (char*) &clnt_key, (int) sessn );
  sessn->rcnt = 1;	/* is this necessary? */
  
  /* start building an initial state for the SPC client-type sessn */
  state_ptr = (SPCstate*) malloc( sizeof( SPCstate ) );
  state_ptr->is_clnt = TRUE;
  state_ptr->remote_host = srvr_spc_addr_ptr->host;
  state_ptr->srvrId = srvr_spc_addr_ptr->command;
  sessn->state = (char*) state_ptr;
  
  /* make sure there are channels to this server host */
  ensure_chans_to_srvr( srvr_spc_addr_ptr->host );
  
  TRACE1(spcp,4,"spc_open: returning %x", sessn);
  return( sessn );
  
} /* end spc_open */


/*
 * SPC_CLNT_PUSH
 *
 * This push is really a call.
 */

spc_clnt_push( sessn, higher_level_msg, reply_msg_ptr )
     XObj	sessn;
     Msg	higher_level_msg;
     Msg*	reply_msg_ptr;
{
  CSTATE*	cstate_ptr;
  int		ret_val;
  
  TRACE0(spcp,4,"spc_clnt_push");
  
  cstate_ptr = select_chan( sessn );
  
  /* push the msg down the channel, blocking there till get reply */
  ret_val = spc_clnt_chan_push( cstate_ptr, higher_level_msg,
			       ((SPCstate*) sessn->state)->srvrId,
			       reply_msg_ptr );
  free_chan( cstate_ptr );
  return( ret_val );
} /* end spc_clnt_push */


/*
 * SPC_CLNT_DEMUX
 * SHOULDN'T BE ANY, BECAUSE CALLER WILL RETURN (WITH REPLY)
 * FROM SPC_CLNT_CHAN_PUSH, SIGNALLED FROM SPC_CLNT_CHAN_POP.
 */


/*
 * SPC_CLNT_POP
 * SHOULDN'T BE ANY, BECAUSE CALLER WILL RETURN (WITH REPLY)
 * FROM SPC_CLNT_CHAN_PUSH, SIGNALLED FROM SPC_CLNT_CHAN_POP.
 */
