/*
 * pmapper.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 * For special use the by port mapper to stash 
 * <prog,vers,protocol> tuples mapped to the 
 * appropriate port number.  Specifically, this 
 * is an x-kernel implementation.
 */

#include <rpc/rpc.h>
#include "xkernel.h"
#include "pmap.h"
#include "pmap_internal.h"

Map port_map; 
  
/* xdr a port mapper argument list  */
xdr_pmap(xdrs,hdr)
XDR  *xdrs;
PMAP_ARGS *hdr;
{
  if (!xdr_u_int(xdrs,&hdr->prog)) {
    return(0);
  }
  if (!xdr_u_int(xdrs,&hdr->vers)) {
    return(0);
  }
  if (!xdr_u_int(xdrs,&hdr->prot)) {
    return(0);
  }
  if (!xdr_u_int(xdrs,&hdr->port)) {
    return(0);
  }
  return(1);
}

print_pmap(hdr)
PMAP_ARGS *hdr;
{
  printf("pmap-prog = %d\n",hdr->prog);
  printf("pmap-vers = %d\n",hdr->vers);
  printf("pmap-prot = %d\n",hdr->prot);
  printf("pmap-port = %d\n",hdr->port);
}

