h14439
s 00001/00002/00718
d D 1.3 91/01/18 13:23:40 llp 3 2
c fixed copyright
e
s 00399/00399/00321
d D 1.2 91/01/10 12:13:44 llp 2 1
c Prepared for 3.1 Distribution
e
s 00720/00000/00000
d D 1.1 90/12/08 23:38:37 menze 1 0
c date and time created 90/12/08 23:38:37 by menze
e
u
U
f e 0
t
T
I 1
/*
 * nfs_xdr.c
 *
D 3
 * x-kernel v3.1	12/10/90
E 3
I 3
 * Copyright (C) 1984, Sun Microsystems, Inc.
E 3
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
D 3
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 3
E 2
 */


/* we must define KERNEL in at least mbuf.h and param.h to get everything
 * we need */

#define KERNEL

#include <sys/param.h>

#include <sys/systm.h>
#include <sys/user.h>
#include <sys/vnode.h>
#include <sys/file.h>
#include <sys/dir.h>

#include <sys/mbuf.h>

#include <sys/vfs.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <nfs/nfs.h>
#include <netinet/in.h>
#include <rpcsvc/mount.h>
#include "nfs_xdr.h"

#ifdef NFSDEBUG
extern int stderr;

char *xdropnames[] = {"encode", "decode", "free"};
#endif

/*
 * These are the XDR routines used to serialize and deserialize
 * the various structures passed as parameters accross the network
 * between NFS clients and servers.
 */

/*
 * File access handle
 * The fhandle struct is treated a opaque data on the wire
 */
bool_t
D 2
xdr_fhandle(xdrs, fh)
	XDR *xdrs;
	fhandle_t *fh;
E 2
I 2
  xdr_fhandle(xdrs, fh)
XDR *xdrs;
fhandle_t *fh;
E 2
{
D 2

	if (xdr_opaque(xdrs, (caddr_t)fh, NFS_FHSIZE)) {
E 2
I 2
  
  if (xdr_opaque(xdrs, (caddr_t)fh, NFS_FHSIZE)) {
E 2
#		ifdef NFSDEBUG
D 2
		printf("xdr_fhandle: %s %x\n",
		    xdropnames[(int)xdrs->x_op], fh);
E 2
I 2
    printf("xdr_fhandle: %s %x\n",
	   xdropnames[(int)xdrs->x_op], fh);
E 2
#		endif
D 2
		return (TRUE);
	}
E 2
I 2
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf("xdr_fhandle %s FAILED\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf("xdr_fhandle %s FAILED\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}


/*
 * Arguments to remote write and writecache
 */
bool_t
D 2
xdr_writeargs(xdrs, wa)
	XDR *xdrs;
	struct nfswriteargs *wa;
E 2
I 2
  xdr_writeargs(xdrs, wa)
XDR *xdrs;
struct nfswriteargs *wa;
E 2
{
D 2
	if (xdr_fhandle(xdrs, &wa->wa_fhandle) &&
	    xdr_long(xdrs, (long *)&wa->wa_begoff) &&
	    xdr_long(xdrs, (long *)&wa->wa_offset) &&
	    xdr_long(xdrs, (long *)&wa->wa_totcount) &&
	    xdr_bytes(xdrs, &wa->wa_data, (u_int *)&wa->wa_count,
	      NFS_MAXDATA) ) {
E 2
I 2
  if (xdr_fhandle(xdrs, &wa->wa_fhandle) &&
      xdr_long(xdrs, (long *)&wa->wa_begoff) &&
      xdr_long(xdrs, (long *)&wa->wa_offset) &&
      xdr_long(xdrs, (long *)&wa->wa_totcount) &&
      xdr_bytes(xdrs, &wa->wa_data, (u_int *)&wa->wa_count,
		NFS_MAXDATA) ) {
E 2
#		ifdef NFSDEBUG
D 2
		printf("xdr_writeargs: %s off %d ct %d\n",
		    xdropnames[(int)xdrs->x_op],
		    wa->wa_offset, wa->wa_totcount);
E 2
I 2
    printf("xdr_writeargs: %s off %d ct %d\n",
	   xdropnames[(int)xdrs->x_op],
	   wa->wa_offset, wa->wa_totcount);
E 2
#		endif
D 2
		return (TRUE);
	}
E 2
I 2
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf("xdr_writeargs: %s FAILED\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf("xdr_writeargs: %s FAILED\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}


/*
 * Arguments to remote read
 */
bool_t
D 2
xdr_readargs(xdrs, ra)
	XDR *xdrs;
	struct nfsreadargs *ra;
E 2
I 2
  xdr_readargs(xdrs, ra)
XDR *xdrs;
struct nfsreadargs *ra;
E 2
{
D 2

	if (xdr_fhandle(xdrs, &ra->ra_fhandle) &&
	    xdr_long(xdrs, (long *)&ra->ra_offset) &&
	    xdr_long(xdrs, (long *)&ra->ra_count) &&
	    xdr_long(xdrs, (long *)&ra->ra_totcount) ) {
E 2
I 2
  
  if (xdr_fhandle(xdrs, &ra->ra_fhandle) &&
      xdr_long(xdrs, (long *)&ra->ra_offset) &&
      xdr_long(xdrs, (long *)&ra->ra_count) &&
      xdr_long(xdrs, (long *)&ra->ra_totcount) ) {
E 2
#		ifdef NFSDEBUG
D 2
		printf("xdr_readargs: %s off %d ct %d\n",
		    xdropnames[(int)xdrs->x_op],
		    ra->ra_offset, ra->ra_totcount);
E 2
I 2
    printf("xdr_readargs: %s off %d ct %d\n",
	   xdropnames[(int)xdrs->x_op],
	   ra->ra_offset, ra->ra_totcount);
E 2
#		endif
D 2
		return (TRUE);
	}
E 2
I 2
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf("xdr_raedargs: %s FAILED\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf("xdr_raedargs: %s FAILED\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}

/*
 * Info necessary to free the bp which is also an mbuf
 */
struct rrokinfo {
D 2
	int	(*func)();
	int	done;
	struct vnode *vp;
	struct buf *bp;
E 2
I 2
  int	(*func)();
  int	done;
  struct vnode *vp;
  struct buf *bp;
E 2
};
D 2
	
E 2

I 2

E 2
/*
 * File attributes which can be set
 */
bool_t
D 2
xdr_sattr(xdrs, sa)
	XDR *xdrs;
	struct nfssattr *sa;
E 2
I 2
  xdr_sattr(xdrs, sa)
XDR *xdrs;
struct nfssattr *sa;
E 2
{
D 2

	if (xdr_u_long(xdrs, &sa->sa_mode) &&
	    xdr_u_long(xdrs, &sa->sa_uid) &&
	    xdr_u_long(xdrs, &sa->sa_gid) &&
	    xdr_u_long(xdrs, &sa->sa_size) &&
	    xdr_timeval(xdrs, &sa->sa_atime) &&
	    xdr_timeval(xdrs, &sa->sa_mtime) ) {
E 2
I 2
  
  if (xdr_u_long(xdrs, &sa->sa_mode) &&
      xdr_u_long(xdrs, &sa->sa_uid) &&
      xdr_u_long(xdrs, &sa->sa_gid) &&
      xdr_u_long(xdrs, &sa->sa_size) &&
      xdr_timeval(xdrs, &sa->sa_atime) &&
      xdr_timeval(xdrs, &sa->sa_mtime) ) {
E 2
#		ifdef NFSDEBUG
D 2
		printf( 
		    "xdr_sattr: %s mode %o uid %d gid %d size %d\n",
		    xdropnames[(int)xdrs->x_op], sa->sa_mode, sa->sa_uid,
		    sa->sa_gid, sa->sa_size);
E 2
I 2
    printf( 
	   "xdr_sattr: %s mode %o uid %d gid %d size %d\n",
	   xdropnames[(int)xdrs->x_op], sa->sa_mode, sa->sa_uid,
	   sa->sa_gid, sa->sa_size);
E 2
#		endif
D 2
		return (TRUE);
	}
E 2
I 2
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_sattr: %s FAILED\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf( "xdr_sattr: %s FAILED\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}

struct xdr_discrim attrstat_discrim[2] = {
D 2
	{ (int)NFS_OK, xdr_fattr },
	{ __dontcare__, NULL_xdrproc_t }
E 2
I 2
  { (int)NFS_OK, xdr_fattr },
  { __dontcare__, NULL_xdrproc_t }
E 2
};

/*
 * Reply status with file attributes
 */
bool_t
D 2
xdr_attrstat(xdrs, ns)
	XDR *xdrs;
	struct nfsattrstat *ns;
E 2
I 2
  xdr_attrstat(xdrs, ns)
XDR *xdrs;
struct nfsattrstat *ns;
E 2
{
D 2

	if (xdr_union(xdrs, (enum_t *)&(ns->ns_status),
	      (caddr_t)&(ns->ns_attr), attrstat_discrim, xdr_void) ) {
E 2
I 2
  
  if (xdr_union(xdrs, (enum_t *)&(ns->ns_status),
		(caddr_t)&(ns->ns_attr), attrstat_discrim, xdr_void) ) {
E 2
#		ifdef NFSDEBUG
D 2
		printf( "xdr_attrstat: %s stat %d\n",
		    xdropnames[(int)xdrs->x_op], ns->ns_status);
E 2
I 2
    printf( "xdr_attrstat: %s stat %d\n",
	   xdropnames[(int)xdrs->x_op], ns->ns_status);
E 2
#		endif
D 2
		return (TRUE);
	}
E 2
I 2
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_attrstat: %s FAILED\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf( "xdr_attrstat: %s FAILED\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}


struct xdr_discrim rdlnres_discrim[2] = {
D 2
	{ (int)NFS_OK, xdr_srok },
	{ __dontcare__, NULL_xdrproc_t }
E 2
I 2
  { (int)NFS_OK, xdr_srok },
  { __dontcare__, NULL_xdrproc_t }
E 2
};


#define	nextdp(dp)	((struct direct *)((int)(dp) + (dp)->d_reclen))
#undef DIRSIZ
#define DIRSIZ(dp)	(sizeof(struct direct) - MAXNAMLEN + (dp)->d_namlen)


#define	roundtoint(x)	(((x) + (sizeof(int) - 1)) & ~(sizeof(int) - 1))
#define	reclen(dp)	roundtoint(((dp)->d_namlen + 1 + sizeof(u_long) +\
D 2
				2 * sizeof(u_short)))
E 2
I 2
				    2 * sizeof(u_short)))
E 2


/*
 * Arguments for directory operations
 */
bool_t
D 2
xdr_diropargs(xdrs, da)
	XDR *xdrs;
	struct nfsdiropargs *da;
E 2
I 2
  xdr_diropargs(xdrs, da)
XDR *xdrs;
struct nfsdiropargs *da;
E 2
{
D 2

	if (xdr_fhandle(xdrs, &da->da_fhandle) &&
	    xdr_string(xdrs, &da->da_name, NFS_MAXNAMLEN) ) {
E 2
I 2
  
  if (xdr_fhandle(xdrs, &da->da_fhandle) &&
      xdr_string(xdrs, &da->da_name, NFS_MAXNAMLEN) ) {
E 2
#		ifdef NFSDEBUG
D 2
		printf( "xdr_diropargs: %s '%s'\n",
		    xdropnames[(int)xdrs->x_op], da->da_name);
E 2
I 2
    printf( "xdr_diropargs: %s '%s'\n",
	   xdropnames[(int)xdrs->x_op], da->da_name);
E 2
#		endif
D 2
		return (TRUE);
	}
E 2
I 2
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_diropargs: FAILED\n");
E 2
I 2
  printf( "xdr_diropargs: FAILED\n");
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}


/*
 * arguments to create and mkdir
 */
bool_t
D 2
xdr_creatargs(xdrs, argp)
	XDR *xdrs;
	struct nfscreatargs *argp;
E 2
I 2
  xdr_creatargs(xdrs, argp)
XDR *xdrs;
struct nfscreatargs *argp;
E 2
{
D 2

	if (xdr_diropargs(xdrs, &argp->ca_da) &&
	    xdr_sattr(xdrs, &argp->ca_sa) ) {
		return (TRUE);
	}
E 2
I 2
  
  if (xdr_diropargs(xdrs, &argp->ca_da) &&
      xdr_sattr(xdrs, &argp->ca_sa) ) {
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_creatargs: FAILED\n");
E 2
I 2
  printf( "xdr_creatargs: FAILED\n");
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}


/*
 * NFS_OK part of statfs operation
 */
xdr_fsok(xdrs, fsok)
D 2
	XDR *xdrs;
	struct nfsstatfsok *fsok;
E 2
I 2
     XDR *xdrs;
     struct nfsstatfsok *fsok;
E 2
{
D 2

	if (xdr_long(xdrs, (long *)&fsok->fsok_tsize) &&
	    xdr_long(xdrs, (long *)&fsok->fsok_bsize) &&
	    xdr_long(xdrs, (long *)&fsok->fsok_blocks) &&
	    xdr_long(xdrs, (long *)&fsok->fsok_bfree) &&
	    xdr_long(xdrs, (long *)&fsok->fsok_bavail) ) {
E 2
I 2
  
  if (xdr_long(xdrs, (long *)&fsok->fsok_tsize) &&
      xdr_long(xdrs, (long *)&fsok->fsok_bsize) &&
      xdr_long(xdrs, (long *)&fsok->fsok_blocks) &&
      xdr_long(xdrs, (long *)&fsok->fsok_bfree) &&
      xdr_long(xdrs, (long *)&fsok->fsok_bavail) ) {
E 2
#		ifdef NFSDEBUG
D 2
		printf( 
		    "xdr_fsok: %s tsz %d bsz %d blks %d bfree %d bavail %d\n",
		    xdropnames[(int)xdrs->x_op], fsok->fsok_tsize,
		    fsok->fsok_bsize, fsok->fsok_blocks, fsok->fsok_bfree,
		    fsok->fsok_bavail);
E 2
I 2
    printf( 
	   "xdr_fsok: %s tsz %d bsz %d blks %d bfree %d bavail %d\n",
	   xdropnames[(int)xdrs->x_op], fsok->fsok_tsize,
	   fsok->fsok_bsize, fsok->fsok_blocks, fsok->fsok_bfree,
	   fsok->fsok_bavail);
E 2
#		endif
D 2
		return (TRUE);
	}
E 2
I 2
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_fsok: FAILED\n");
E 2
I 2
  printf( "xdr_fsok: FAILED\n");
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}

struct xdr_discrim statfs_discrim[2] = {
D 2
	{ (int)NFS_OK, xdr_fsok },
	{ __dontcare__, NULL_xdrproc_t }
E 2
I 2
  { (int)NFS_OK, xdr_fsok },
  { __dontcare__, NULL_xdrproc_t }
E 2
};




struct xdr_discrim rdres_discrim[2] = {
D 2
	{ (int)NFS_OK, xdr_rrok },
	{ __dontcare__, NULL_xdrproc_t }
E 2
I 2
  { (int)NFS_OK, xdr_rrok },
  { __dontcare__, NULL_xdrproc_t }
E 2
};

/*
 * Reply from remote read
 */
bool_t
D 2
xdr_rdresult(xdrs, rr)
	XDR *xdrs;
	struct nfsrdresult *rr;
E 2
I 2
  xdr_rdresult(xdrs, rr)
XDR *xdrs;
struct nfsrdresult *rr;
E 2
{
D 2

E 2
I 2
  
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_rdresult: %s\n", xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf( "xdr_rdresult: %s\n", xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	if (xdr_union(xdrs, (enum_t *)&(rr->rr_status),
	      (caddr_t)&(rr->rr_ok), rdres_discrim, xdr_void) ) {
		return (TRUE);
	}
E 2
I 2
  if (xdr_union(xdrs, (enum_t *)&(rr->rr_status),
		(caddr_t)&(rr->rr_ok), rdres_discrim, xdr_void) ) {
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_rdresult: %s FAILED\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf( "xdr_rdresult: %s FAILED\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}


struct xdr_discrim diropres_discrim[2] = {
D 2
	{ (int)NFS_OK, xdr_drok },
	{ __dontcare__, NULL_xdrproc_t }
E 2
I 2
  { (int)NFS_OK, xdr_drok },
  { __dontcare__, NULL_xdrproc_t }
E 2
};

/*
 * Results from directory operation 
 */
bool_t
D 2
xdr_diropres(xdrs, dr)
	XDR *xdrs;
	struct nfsdiropres *dr;
E 2
I 2
  xdr_diropres(xdrs, dr)
XDR *xdrs;
struct nfsdiropres *dr;
E 2
{
D 2
	if (xdr_union(xdrs, (enum_t *)&(dr->dr_status),
	      (caddr_t)&(dr->dr_drok), diropres_discrim, xdr_void) ) {
E 2
I 2
  if (xdr_union(xdrs, (enum_t *)&(dr->dr_status),
		(caddr_t)&(dr->dr_drok), diropres_discrim, xdr_void) ) {
E 2
#		ifdef NFSDEBUG
D 2
		printf( "xdr_diropres: %s stat %d\n",
		    xdropnames[(int)xdrs->x_op], dr->dr_status);
E 2
I 2
    printf( "xdr_diropres: %s stat %d\n",
	   xdropnames[(int)xdrs->x_op], dr->dr_status);
E 2
#		endif
D 2
		return (TRUE);
	}
E 2
I 2
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_diropres: FAILED\n");
E 2
I 2
  printf( "xdr_diropres: FAILED\n");
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}


/*
 * File attributes
 */
bool_t
D 2
xdr_fattr(xdrs, na)
	XDR *xdrs;
	register struct nfsfattr *na;
E 2
I 2
  xdr_fattr(xdrs, na)
XDR *xdrs;
register struct nfsfattr *na;
E 2
{
D 2
	register long *ptr;

E 2
I 2
  register long *ptr;
  
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_fattr: %s\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf( "xdr_fattr: %s\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	if (xdrs->x_op == XDR_ENCODE) {
		ptr = XDR_INLINE(xdrs, 17 * BYTES_PER_XDR_UNIT);
		if (ptr != NULL) {
			IXDR_PUT_ENUM(ptr, na->na_type);
			IXDR_PUT_LONG(ptr, na->na_mode);
			IXDR_PUT_LONG(ptr, na->na_nlink);
			IXDR_PUT_LONG(ptr, na->na_uid);
			IXDR_PUT_LONG(ptr, na->na_gid);
			IXDR_PUT_LONG(ptr, na->na_size);
			IXDR_PUT_LONG(ptr, na->na_blocksize);
			IXDR_PUT_LONG(ptr, na->na_rdev);
			IXDR_PUT_LONG(ptr, na->na_blocks);
			IXDR_PUT_LONG(ptr, na->na_fsid);
			IXDR_PUT_LONG(ptr, na->na_nodeid);
			IXDR_PUT_LONG(ptr, na->na_atime.tv_sec);
			IXDR_PUT_LONG(ptr, na->na_atime.tv_usec);
			IXDR_PUT_LONG(ptr, na->na_mtime.tv_sec);
			IXDR_PUT_LONG(ptr, na->na_mtime.tv_usec);
			IXDR_PUT_LONG(ptr, na->na_ctime.tv_sec);
			IXDR_PUT_LONG(ptr, na->na_ctime.tv_usec);
			return (TRUE);
		}
	} else {
		ptr = XDR_INLINE(xdrs, 17 * BYTES_PER_XDR_UNIT);
		if (ptr != NULL) {
			na->na_type = IXDR_GET_ENUM(ptr, enum nfsftype);
			na->na_mode = IXDR_GET_LONG(ptr);
			na->na_nlink = IXDR_GET_LONG(ptr);
			na->na_uid = IXDR_GET_LONG(ptr);
			na->na_gid = IXDR_GET_LONG(ptr);
			na->na_size = IXDR_GET_LONG(ptr);
			na->na_blocksize = IXDR_GET_LONG(ptr);
			na->na_rdev = IXDR_GET_LONG(ptr);
			na->na_blocks = IXDR_GET_LONG(ptr);
			na->na_fsid = IXDR_GET_LONG(ptr);
			na->na_nodeid = IXDR_GET_LONG(ptr);
			na->na_atime.tv_sec = IXDR_GET_LONG(ptr);
			na->na_atime.tv_usec = IXDR_GET_LONG(ptr);
			na->na_mtime.tv_sec = IXDR_GET_LONG(ptr);
			na->na_mtime.tv_usec = IXDR_GET_LONG(ptr);
			na->na_ctime.tv_sec = IXDR_GET_LONG(ptr);
			na->na_ctime.tv_usec = IXDR_GET_LONG(ptr);
			return (TRUE);
		}
	}
	if (xdr_enum(xdrs, (enum_t *)&na->na_type) &&
	    xdr_u_long(xdrs, &na->na_mode) &&
	    xdr_u_long(xdrs, &na->na_nlink) &&
	    xdr_u_long(xdrs, &na->na_uid) &&
	    xdr_u_long(xdrs, &na->na_gid) &&
	    xdr_u_long(xdrs, &na->na_size) &&
	    xdr_u_long(xdrs, &na->na_blocksize) &&
	    xdr_u_long(xdrs, &na->na_rdev) &&
	    xdr_u_long(xdrs, &na->na_blocks) &&
	    xdr_u_long(xdrs, &na->na_fsid) &&
	    xdr_u_long(xdrs, &na->na_nodeid) &&
	    xdr_timeval(xdrs, &na->na_atime) &&
	    xdr_timeval(xdrs, &na->na_mtime) &&
	    xdr_timeval(xdrs, &na->na_ctime) ) {
		return (TRUE);
	}
E 2
I 2
  if (xdrs->x_op == XDR_ENCODE) {
    ptr = XDR_INLINE(xdrs, 17 * BYTES_PER_XDR_UNIT);
    if (ptr != NULL) {
      IXDR_PUT_ENUM(ptr, na->na_type);
      IXDR_PUT_LONG(ptr, na->na_mode);
      IXDR_PUT_LONG(ptr, na->na_nlink);
      IXDR_PUT_LONG(ptr, na->na_uid);
      IXDR_PUT_LONG(ptr, na->na_gid);
      IXDR_PUT_LONG(ptr, na->na_size);
      IXDR_PUT_LONG(ptr, na->na_blocksize);
      IXDR_PUT_LONG(ptr, na->na_rdev);
      IXDR_PUT_LONG(ptr, na->na_blocks);
      IXDR_PUT_LONG(ptr, na->na_fsid);
      IXDR_PUT_LONG(ptr, na->na_nodeid);
      IXDR_PUT_LONG(ptr, na->na_atime.tv_sec);
      IXDR_PUT_LONG(ptr, na->na_atime.tv_usec);
      IXDR_PUT_LONG(ptr, na->na_mtime.tv_sec);
      IXDR_PUT_LONG(ptr, na->na_mtime.tv_usec);
      IXDR_PUT_LONG(ptr, na->na_ctime.tv_sec);
      IXDR_PUT_LONG(ptr, na->na_ctime.tv_usec);
      return (TRUE);
    }
  } else {
    ptr = XDR_INLINE(xdrs, 17 * BYTES_PER_XDR_UNIT);
    if (ptr != NULL) {
      na->na_type = IXDR_GET_ENUM(ptr, enum nfsftype);
      na->na_mode = IXDR_GET_LONG(ptr);
      na->na_nlink = IXDR_GET_LONG(ptr);
      na->na_uid = IXDR_GET_LONG(ptr);
      na->na_gid = IXDR_GET_LONG(ptr);
      na->na_size = IXDR_GET_LONG(ptr);
      na->na_blocksize = IXDR_GET_LONG(ptr);
      na->na_rdev = IXDR_GET_LONG(ptr);
      na->na_blocks = IXDR_GET_LONG(ptr);
      na->na_fsid = IXDR_GET_LONG(ptr);
      na->na_nodeid = IXDR_GET_LONG(ptr);
      na->na_atime.tv_sec = IXDR_GET_LONG(ptr);
      na->na_atime.tv_usec = IXDR_GET_LONG(ptr);
      na->na_mtime.tv_sec = IXDR_GET_LONG(ptr);
      na->na_mtime.tv_usec = IXDR_GET_LONG(ptr);
      na->na_ctime.tv_sec = IXDR_GET_LONG(ptr);
      na->na_ctime.tv_usec = IXDR_GET_LONG(ptr);
      return (TRUE);
    }
  }
  if (xdr_enum(xdrs, (enum_t *)&na->na_type) &&
      xdr_u_long(xdrs, &na->na_mode) &&
      xdr_u_long(xdrs, &na->na_nlink) &&
      xdr_u_long(xdrs, &na->na_uid) &&
      xdr_u_long(xdrs, &na->na_gid) &&
      xdr_u_long(xdrs, &na->na_size) &&
      xdr_u_long(xdrs, &na->na_blocksize) &&
      xdr_u_long(xdrs, &na->na_rdev) &&
      xdr_u_long(xdrs, &na->na_blocks) &&
      xdr_u_long(xdrs, &na->na_fsid) &&
      xdr_u_long(xdrs, &na->na_nodeid) &&
      xdr_timeval(xdrs, &na->na_atime) &&
      xdr_timeval(xdrs, &na->na_mtime) &&
      xdr_timeval(xdrs, &na->na_ctime) ) {
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_fattr: %s FAILED\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf( "xdr_fattr: %s FAILED\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}



/*
 * Status OK portion of remote read reply
 */
bool_t
D 2
xdr_rrok(xdrs, rrok)
	XDR *xdrs;
	struct nfsrrok *rrok;
E 2
I 2
  xdr_rrok(xdrs, rrok)
XDR *xdrs;
struct nfsrrok *rrok;
E 2
{
D 2

	if (xdr_fattr(xdrs, &rrok->rrok_attr)) {
			/* client side */
			if (xdr_bytes(xdrs, &rrok->rrok_data,
			    (u_int *)&rrok->rrok_count, NFS_MAXDATA) ) {
E 2
I 2
  
  if (xdr_fattr(xdrs, &rrok->rrok_attr)) {
    /* client side */
    if (xdr_bytes(xdrs, &rrok->rrok_data,
		  (u_int *)&rrok->rrok_count, NFS_MAXDATA) ) {
E 2
#				ifdef NFSDEBUG
D 2
				printf( 
				    "xdr_rrok: %s %d addr %x\n",
				    xdropnames[(int)xdrs->x_op],
				    rrok->rrok_count, rrok->rrok_data);
E 2
I 2
      printf( 
	     "xdr_rrok: %s %d addr %x\n",
	     xdropnames[(int)xdrs->x_op],
	     rrok->rrok_count, rrok->rrok_data);
E 2
#				endif
D 2
				return (TRUE);
			}
		
	}
E 2
I 2
      return (TRUE);
    }
    
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_rrok: %s FAILED\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf( "xdr_rrok: %s FAILED\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}


/*
 * NFS_OK part of read sym link reply union
 */
bool_t
D 2
xdr_srok(xdrs, srok)
	XDR *xdrs;
	struct nfssrok *srok;
E 2
I 2
  xdr_srok(xdrs, srok)
XDR *xdrs;
struct nfssrok *srok;
E 2
{
D 2

	if (xdr_bytes(xdrs, &srok->srok_data, (u_long *)&srok->srok_count,
	    NFS_MAXPATHLEN) ) {
		return (TRUE);
	}
E 2
I 2
  
  if (xdr_bytes(xdrs, &srok->srok_data, (u_long *)&srok->srok_count,
		NFS_MAXPATHLEN) ) {
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_srok: %s FAILED\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf( "xdr_srok: %s FAILED\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}

/*
 * Time structure
 */
bool_t
D 2
xdr_timeval(xdrs, tv)
	XDR *xdrs;
	struct timeval *tv;
E 2
I 2
  xdr_timeval(xdrs, tv)
XDR *xdrs;
struct timeval *tv;
E 2
{
D 2

	if (xdr_long(xdrs, &tv->tv_sec) &&
	    xdr_long(xdrs, &tv->tv_usec) ) {
		return (TRUE);
	}
E 2
I 2
  
  if (xdr_long(xdrs, &tv->tv_sec) &&
      xdr_long(xdrs, &tv->tv_usec) ) {
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_timeval: FAILED\n");
E 2
I 2
  printf( "xdr_timeval: FAILED\n");
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}


/*
 * NFS_OK part of directory operation result
 */
bool_t
D 2
xdr_drok(xdrs, drok)
	XDR *xdrs;
	struct nfsdrok *drok;
E 2
I 2
  xdr_drok(xdrs, drok)
XDR *xdrs;
struct nfsdrok *drok;
E 2
{
D 2
	if (xdr_fhandle(xdrs, &drok->drok_fhandle)) {
	    if (xdr_fattr(xdrs, &drok->drok_attr)) {
		return (TRUE);
            }
	}
E 2
I 2
  if (xdr_fhandle(xdrs, &drok->drok_fhandle)) {
    if (xdr_fattr(xdrs, &drok->drok_attr)) {
      return (TRUE);
    }
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_drok: FAILED\n");
E 2
I 2
  printf( "xdr_drok: FAILED\n");
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}

/* 
 * reply from mount
 */
struct xdr_discrim fhstatus_discrim[2] = {
D 2
	{ (int) NFS_OK, xdr_fhandle },
	{ __dontcare__, NULL_xdrproc_t }
E 2
I 2
  { (int) NFS_OK, xdr_fhandle },
  { __dontcare__, NULL_xdrproc_t }
E 2
};

bool_t
D 2
xdr_fhstatus(xdrs, rm)
	XDR *xdrs;
	struct fhstatus *rm;
E 2
I 2
  xdr_fhstatus(xdrs, rm)
XDR *xdrs;
struct fhstatus *rm;
E 2
{
D 2
	if (xdr_union(xdrs, (enum_t *) &(rm->fhs_status),
E 2
I 2
  if (xdr_union(xdrs, (enum_t *) &(rm->fhs_status),
E 2
		(caddr_t) &(rm->fhs_fh), fhstatus_discrim, xdr_void) ) {
D 2
		return TRUE;
	}

	return FALSE;
E 2
I 2
    return TRUE;
  }
  
  return FALSE;
E 2
}


bool_t
D 2
xdr_linkargs(xdrs, la)
	XDR *xdrs;
	struct nfslinkargs *la;
E 2
I 2
  xdr_linkargs(xdrs, la)
XDR *xdrs;
struct nfslinkargs *la;
E 2
{
D 2
	if (xdr_fhandle(xdrs, &la->la_from) &&
	    xdr_diropargs(xdrs, &la->la_to)) {
		return (TRUE);
	}
	return (FALSE);
E 2
I 2
  if (xdr_fhandle(xdrs, &la->la_from) &&
      xdr_diropargs(xdrs, &la->la_to)) {
    return (TRUE);
  }
  return (FALSE);
E 2
}


bool_t
D 2
xdr_slargs(xdrs, la)
	XDR  *xdrs;
	struct nfsslargs *la;
E 2
I 2
  xdr_slargs(xdrs, la)
XDR  *xdrs;
struct nfsslargs *la;
E 2
{
D 2
    
	if (xdr_diropargs(xdrs, &la->sla_from)  &&
	    xdr_string(xdrs, &la->sla_tnm, NFS_MAXNAMLEN) &&
	    xdr_sattr(xdrs, &la->sla_sa)) {
	       return(TRUE);
	}
	return(FALSE);
E 2
I 2
  
  if (xdr_diropargs(xdrs, &la->sla_from)  &&
      xdr_string(xdrs, &la->sla_tnm, NFS_MAXNAMLEN) &&
      xdr_sattr(xdrs, &la->sla_sa)) {
    return(TRUE);
  }
  return(FALSE);
E 2
}

bool_t 
D 2
xdr_rnmargs(xdrs, la)
       XDR    *xdrs;
       struct nfsrnmargs *la;
E 2
I 2
  xdr_rnmargs(xdrs, la)
XDR    *xdrs;
struct nfsrnmargs *la;
E 2
{
D 2
   
       if (xdr_diropargs(xdrs, &la->rna_from) &&
	   xdr_diropargs(xdrs, &la->rna_to)) {
	      return(TRUE);
       }
       return(FALSE);
E 2
I 2
  
  if (xdr_diropargs(xdrs, &la->rna_from) &&
      xdr_diropargs(xdrs, &la->rna_to)) {
    return(TRUE);
  }
  return(FALSE);
E 2
}


bool_t
D 2
xdr_saargs(xdrs, la)
      XDR   *xdrs;
      struct nfssaargs *la;
E 2
I 2
  xdr_saargs(xdrs, la)
XDR   *xdrs;
struct nfssaargs *la;
E 2
{
D 2
      if (xdr_fhandle(xdrs, &la->saa_fh) &&
	  xdr_sattr(xdrs, &la->saa_sa)) {
	     return(TRUE);
      }
      return(FALSE);
E 2
I 2
  if (xdr_fhandle(xdrs, &la->saa_fh) &&
      xdr_sattr(xdrs, &la->saa_sa)) {
    return(TRUE);
  }
  return(FALSE);
E 2
}

bool_t 
D 2
xdr_rdlnres(xdrs, rl)
      XDR   *xdrs;
      struct nfsrdlnres *rl;
E 2
I 2
  xdr_rdlnres(xdrs, rl)
XDR   *xdrs;
struct nfsrdlnres *rl;
E 2
{
D 2
      
      if (xdr_union(xdrs, (enum_t *)&(rl->rl_status),
	     (caddr_t)&(rl->rl_srok), rdlnres_discrim, xdr_void)) {
	     return(TRUE);
      }
      return(FALSE);
E 2
I 2
  
  if (xdr_union(xdrs, (enum_t *)&(rl->rl_status),
		(caddr_t)&(rl->rl_srok), rdlnres_discrim, xdr_void)) {
    return(TRUE);
  }
  return(FALSE);
E 2
}


bool_t
D 2
xdr_nfsrddirargs(xdrs, objp)
	XDR *xdrs;
	struct nfsrddirargs *objp;
E 2
I 2
  xdr_nfsrddirargs(xdrs, objp)
XDR *xdrs;
struct nfsrddirargs *objp;
E 2
{
D 2
	if (!xdr_fhandle(xdrs, &objp->rda_fh)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->rda_offset)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->rda_count)) {
		return (FALSE);
	}
	return (TRUE);
E 2
I 2
  if (!xdr_fhandle(xdrs, &objp->rda_fh)) {
    return (FALSE);
  }
  if (!xdr_u_long(xdrs, &objp->rda_offset)) {
    return (FALSE);
  }
  if (!xdr_u_long(xdrs, &objp->rda_count)) {
    return (FALSE);
  }
  return (TRUE);
E 2
}
extern bool_t xdr_char();


bool_t
D 2
xdr_filename(xdrs, objp)
	XDR *xdrs;
	char  *objp;
E 2
I 2
  xdr_filename(xdrs, objp)
XDR *xdrs;
char  *objp;
E 2
{
D 2
	if (!xdr_string(xdrs, objp, NFS_MAXNAMLEN)) {
		return (FALSE);
	}
	return (TRUE);
E 2
I 2
  if (!xdr_string(xdrs, objp, NFS_MAXNAMLEN)) {
    return (FALSE);
  }
  return (TRUE);
E 2
}

bool_t
D 2
xdr_nfscookie(xdrs, objp)
	XDR *xdrs;
	nfscookie objp;
E 2
I 2
  xdr_nfscookie(xdrs, objp)
XDR *xdrs;
nfscookie objp;
E 2
{
D 2
	if (!xdr_opaque(xdrs, objp, NFS_COOKIESIZE)) {
		return (FALSE);
	}
	return (TRUE);
E 2
I 2
  if (!xdr_opaque(xdrs, objp, NFS_COOKIESIZE)) {
    return (FALSE);
  }
  return (TRUE);
E 2
}



bool_t
D 2
xdr_entry(xdrs, objp)
	XDR *xdrs;
	entry *objp;
E 2
I 2
  xdr_entry(xdrs, objp)
XDR *xdrs;
entry *objp;
E 2
{
D 2
	if (!xdr_u_int(xdrs, &objp->fileid)) {
		return (FALSE);
	}
	if (!xdr_filename(xdrs, &objp->name)) {
		return (FALSE);
	}
	if (!xdr_nfscookie(xdrs, objp->cookie)) {
		return (FALSE);
	}
	if (!xdr_pointer(xdrs, (char **)&objp->nextentry, sizeof(entry), xdr_entry)) {
		return (FALSE);
	}
	return (TRUE);
E 2
I 2
  if (!xdr_u_int(xdrs, &objp->fileid)) {
    return (FALSE);
  }
  if (!xdr_filename(xdrs, &objp->name)) {
    return (FALSE);
  }
  if (!xdr_nfscookie(xdrs, objp->cookie)) {
    return (FALSE);
  }
  if (!xdr_pointer(xdrs, (char **)&objp->nextentry, sizeof(entry), xdr_entry)) {
    return (FALSE);
  }
  return (TRUE);
E 2
}




bool_t
D 2
xdr_dirlist(xdrs, objp)
	XDR *xdrs;
	dirlist *objp;
E 2
I 2
  xdr_dirlist(xdrs, objp)
XDR *xdrs;
dirlist *objp;
E 2
{
D 2
	if (!xdr_pointer(xdrs, (char **)&objp->entries, sizeof(entry), xdr_entry)) {
		return (FALSE);
	}
	if (!xdr_bool(xdrs, &objp->eof)) {
		return (FALSE);
	}
	return (TRUE);
E 2
I 2
  if (!xdr_pointer(xdrs, (char **)&objp->entries, sizeof(entry), xdr_entry)) {
    return (FALSE);
  }
  if (!xdr_bool(xdrs, &objp->eof)) {
    return (FALSE);
  }
  return (TRUE);
E 2
}


struct xdr_discrim nfsrddirres_discrim[2] = {
D 2
	{ (int)NFS_OK, xdr_dirlist },
	{ __dontcare__, NULL_xdrproc_t }
E 2
I 2
  { (int)NFS_OK, xdr_dirlist },
  { __dontcare__, NULL_xdrproc_t }
E 2
};
bool_t
D 2
xdr_nfsrddirres(xdrs, ns)
	XDR *xdrs;
	struct readdirres *ns;
E 2
I 2
  xdr_nfsrddirres(xdrs, ns)
XDR *xdrs;
struct readdirres *ns;
E 2
{
D 2

	if (xdr_union(xdrs, (enum_t *)&(ns->status),
	      (caddr_t)&(ns->readdirres_u.reply), nfsrddirres_discrim, xdr_void) ) {
E 2
I 2
  
  if (xdr_union(xdrs, (enum_t *)&(ns->status),
		(caddr_t)&(ns->readdirres_u.reply), nfsrddirres_discrim, xdr_void) ) {
E 2
#		ifdef NFSDEBUG
D 2
		printf( "xdr_nfsrddirres: %s stat %d\n",
		    xdropnames[(int)xdrs->x_op], ns->rd_status);
E 2
I 2
    printf( "xdr_nfsrddirres: %s stat %d\n",
	   xdropnames[(int)xdrs->x_op], ns->rd_status);
E 2
#		endif
D 2
		return (TRUE);
	}
E 2
I 2
    return (TRUE);
  }
E 2
#	ifdef NFSDEBUG
D 2
	printf( "xdr_nfsrddirres: %s FAILED\n",
	    xdropnames[(int)xdrs->x_op]);
E 2
I 2
  printf( "xdr_nfsrddirres: %s FAILED\n",
	 xdropnames[(int)xdrs->x_op]);
E 2
#	endif
D 2
	return (FALSE);
E 2
I 2
  return (FALSE);
E 2
}



E 1
