h51155
s 00006/00006/01797
d D 1.4 91/02/07 12:03:36 menze 5 4
c fixed the ocsum routine for VAX
e
s 00065/00077/01738
d D 1.3 91/01/10 11:44:52 llp 4 3
c Prepared for 3.1 Distribution
e
s 00006/00006/01809
d D 1.2 90/12/03 14:22:00 norm 3 1
c Fixed the local labels in ocsum
e
s 00005/00005/01810
d R 1.2 90/12/03 14:19:26 norm 2 1
c Fixed the local labels in ocsum
e
s 01815/00000/00000
d D 1.1 90/11/16 10:53:07 menze 1 0
c date and time created 90/11/16 10:53:07 by menze
e
u
U
f e 0
t
T
I 1
/*
 * ip.c
 *
 * x-kernel v3.1	12/10/90
 *
D 4
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 *
 *
 * x-kernel implementation of the Internet Protocol
 *
E 4
I 4
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
E 4
 * Bug list: byte ordering! byte ordering! byte ordering!
 * Options are not supported
 */
D 4
#include "assert.h"
#include "site.h"
#include "upi.h"
E 4
I 4

#include "xkernel.h"
E 4
#include "eth.h"
#include "ip.h"
#include "ip_internal.h"
#include "icmp.h"
#include "arp.h"
D 4
#include "debug.h"
E 4

static XObj IP_SELF = 0;

#ifndef NDEBUG
#define X_POP(A, DS, B) x_pop((A), (DS), (B))
#else
#define X_POP(A, DS, B) x_demux((A), (msg_pop((B), IPHLEN),B))
#endif

int traceipp;
extern char *malloc(), *calloc();
extern unsigned long inet_addr();
extern IPhost myipaddr;

/* forwards */
/* from the ip-xkernel (main) module */
int
  ip_init(),
  ip_openenable(),
  ip_close(),
  ip_controlprotl(),
  ip_controlsessn(),
  ip_push(),
  ip_demux(),
  ip_pop(),
  ip_getproc();

Sessn ip_open();

/* from the ip-fragmentation submodule */
int
  ip_dispatch(),
  ip_reassembly_done(),
  ip_repatch(),
  ip_recycle(),
  ip_garbageman();

/* from the ip_options submodule */
int ip_option_handler();
D 4
MSG
E 4
I 4
Msg
E 4
  fragment_header(),
  ip_add_option(),
  ip_delete_option();

/* from the ip routing table submodule */
int
  ip_rt_insert(),
  ip_rt_init();
OLD_PROTL ip_router();

/* from the miscellaneous utilities submodule */
char *inet_iptoa();
int ip_me(), mycksum(), ntoh_iphdr();
D 4

E 4


D 4

E 4
/* global data for IP */

struct {
  short      type;
  char	     address[6];
} my_ether_address = { 0x0800 };

short      ip_i_am_a_gateway;
static Map activemap;
static Map passivemap;
int netInterfaces;		/* # of physical IP nets */



/* IP routing table data */

#define LASTDEVICEPROTOCOL 10

IPhost	my_ip_addresses[2 * (LASTDEVICEPROTOCOL+1)];
int	num_ip_addresses;   /* # of ip addresses (from rom, or wherever)  */

IPhost	ip_Default_Gateway = SITE_IP_GTW;
OLD_PROTL	ip_Default_Interface = -1;

OLD_PROTL	interface2resolution_protocol[LASTDEVICEPROTOCOL+1];

Map	ip_routing_table;

IPhost	interface2ipaddr[LASTDEVICEPROTOCOL+1];

/* IP fragmentation data */

int mtu[LASTDEVICEPROTOCOL+1];
IPtimer *(ip_timeouts[256]);
int timeout_cursor;
D 4

E 4



/* ip_init
 *
 * initialize the routing table (ip_rt_init)
 * openenable device interfaces (ETH,...)
 * fire up garbage collector (ip_garbageman)
 */
ip_init(self)
XObj self;
{
  TRACE0(ipp, 1, "IP init");
  if (IP_SELF) {
    Kabort("ip_init: can't init ip twice!");
  }
  IP_SELF = self;
  activemap = map_create(101, sizeof(ActiveId));
  passivemap = map_create(23, sizeof(PassiveId));
  ip_rt_init();

  event_register(ip_garbageman, 0, 1000 /*1 second*/, EV_REPEAT | EV_CREATEPROCESS);
  return 0;
}

/* ip_open
 *
 * Sessions are maintained for each remote IPaddr+protocol.  If a
 * remote address+protocol is talking to two different IPaddrs on a
 * single host (e.g. a gateway), it *perhaps* should have two sessions.
 */
/*ARGSUSED*/
Sessn ip_open(self,hlp, p)
XObj 	self;
XObj	hlp;
Part	*p;
{
  Sessn	    s;
  IPstate  *ip_state;
  IPaddr		localaddr, remoteaddr;
  IPheader *iph;
  Part	    part[3];
  ActiveId  activeid;
  OLD_PROTL     interface;

  TRACE0(ipp, 5, "In ip_open");

  localaddr =  get_part(p, 0, IPaddr);
  remoteaddr = get_part(p, 1, IPaddr);
  activeid.protocolnum = localaddr.protocolnum;
  activeid.pad[0] = activeid.pad[1] = activeid.pad[2] = 0;
  activeid.host =  remoteaddr.host;
  TRACE5(ipp,6,"ip_pnum is %d, addr is %d,%d,%d,%d",
	 activeid.protocolnum,
	 activeid.host.a,
	 activeid.host.b,
	 activeid.host.c,
	 activeid.host.d);
  s=(Sessn)map_resolve(activemap, (char *)&activeid);
  if (s != ERR_SESSN) {
    s->rcnt++;
    if (s->state == ST_INITIALIZING) {
      /* it is being created */
      P((Semaphore *)s->mutex);
    }
    if (s->state == ST_BROKEN) {
      /* it could not be created */
      ip_close(s);
      s = ERR_SESSN;
      x_errno = BAD_ADDR;
    }
  } else {
    struct {
      unsigned short type;
      char nbuf[6];
    } ethaddr;
    int nlen = 6;
    s = x_createsession(hlp, IP_SELF, 1);
    s->numdown = 0;
    P((Semaphore *)s->mutex);
    s->binding = map_bind(activemap, (char *)&activeid, (int)s);

    ip_state = (IPstate *) malloc(sizeof(IPstate));
    ip_state->ip_id = 0;
    ip_state->buffers = map_create(REASSEMBLY_WINDOW, sizeof(ReassemblyKey));
    msg_make_allstack(ip_state->options,IPMAXOPTLEN+100,(char *)0,0);

    iph = &ip_state->hdr;
    iph->ip_v = IPVERS;
    iph->ip_hl = 5; /* number of 32-bit blocks */
    iph->ip_tos = 0;

    /* assert: the following fields are always set elsewhere */
    iph->ip_len = iph->ip_id = iph->ip_off = iph->ip_sum = 0;

    iph->ip_ttl = 100;
    iph->ip_protocol = localaddr.protocolnum;
    iph->ip_dest = remoteaddr.host;
    interface = ip_router(remoteaddr.host, (IPhost *)NULL, ethaddr.nbuf,&nlen);
    if (interface == ERR_OLD_PROTL) {
      x_errno = BAD_ADDR;
      TRACE0(ipp,3,"ip open error #2");
      s->state = ST_BROKEN;
      ip_close(s);
      s = ERR_SESSN;
    } else {
      iph->ip_src = interface2ipaddr[interface];
      ethaddr.type = my_ether_address.type;

      init_partlist(part, 2, ETHaddr);
      set_part(part, 0, my_ether_address);
      set_part(part, 1, (*(ETHaddr *)&ethaddr));
      s->down[0]= ip_state->down_s = x_open(IP_SELF, x_tonew(interface), part);
      s->numdown = 1;
      s->state = (char *) ip_state;
      VAll((Semaphore *)s->mutex);
      V((Semaphore *)s->mutex);
    }
  }
  TRACE1(ipp, 3, "IP open returns %x", s);
  return s;
}

/* ip_openenable
 *
 * grabs exclusive rights to this protocol number for the client protocol
 */
/*ARGSUSED*/
ip_openenable(self,hlp, p)
XObj	self;
XObj	hlp;
Part	*p;
{
  int reply = 0;
  IPaddr localaddr;
  PassiveId passiveid;

  localaddr = get_part(p, 0, IPaddr);
  passiveid = localaddr.protocolnum;
  TRACE1(ipp, 7, "in ip_openenable protocolnum = %d", passiveid);
  if (map_bind(passivemap, (char *)&passiveid, (int)hlp) == ERR_BIND) {
    x_errno = ALREADY_OPEN;
    reply = -1;
  }
  TRACE1(ipp, 3, "IP open enable returns %d", reply);
  return reply;
}

/*
 *ip_close
 */
ip_close(s)
XObj	s;
{
  IPstate *ip_state;

  assert(x_is_session(s));

  TRACE0(ipp, 7, "in ip_close");
  if (--s->rcnt > 0) return 0;

  map_unbindbinding(activemap, s->binding);
  if (s->state > ST_BROKEN) {
    ip_state = (IPstate *) s->state;
    msg_free(ip_state->options);
    map_close(ip_state->buffers);
    x_close(ip_state->down_s);
  }
  x_destroysession(s);
  return 0;
}

ip_controlprotl(self,opcode, buf, len)
XObj self;
int opcode;
char *buf;
int len;
{
  TRACE3(ipp,7,"in ip_controlprotl, opcode = %d, buf = %x, len = %d",
	 opcode, buf, len);
  assert(x_is_protocol(self));
  switch (opcode) {

D 4
  case MAXPACKET:
E 4
I 4
  case GETMAXPACKET:
E 4
    checkLen(len, sizeof(int));
    *(int*)buf = 64*1024;
    return sizeof(int);

D 4
  case MAXOPTIMALPACKET:
E 4
I 4
  case GETOPTPACKET:
E 4
    checkLen(len, sizeof(int));
    /*
     * TODO:  TOFIX:  This must do a minimum over all the MAXPACKETS of all
     * the delivery protocols that this IP may ever use to deliver a packet.
     * I can't find them, therefore I lie.
     */
    *(int *)buf = 1500 - sizeof(IPheader);
    return sizeof(int);

D 4
  case MYADDR:
E 4
I 4
  case GETMYADDR:
E 4
    checkLen(len, sizeof(IPhost));
    *(IPhost *)buf = my_ip_addresses[0];
    return sizeof(IPhost);

  case IP_REDIRECT:
    {
      IPhost net, gateway;
      RTE *rte;
      OLD_PROTL interface;

      checkLen(len, 2*sizeof(IPhost));
      net = *(IPhost *)buf;
      gateway = *(IPhost *)(buf+4);

#ifdef UNDEF
      /* disabled-the decision for whether a redirect is for a whole net or
	 just a single host is made by the sender of the control message.
	 ICMP, for instance, does the right thing BEFORE this point. */
      /* get the network of this ip_addr */
      if (CLASSA(net)) net.b = 0;
      if (!CLASSC(net)) net.c = 0;
      net.d = 0;
#endif
      TRACE4(ipp, 4, "ip_control receives redirect for address %d.%d.%d.%d",
	     net.a,net.b,net.c,net.d);
      TRACE4(ipp, 4, "new gateway to send to: %d.%d.%d.%d",
	     gateway.a,gateway.b,gateway.c,gateway.d);
      if ((rte = (RTE *)map_resolve(ip_routing_table,(char *)&net))
	  == (RTE *)-1){
	char nbuf[64];
	int nlen = 64;
	interface = ip_router(gateway,(IPhost *)NULL,nbuf,&nlen);
	ip_rt_insert(net,interface,gateway);
      } else {
	rte->GWaddr = gateway;
      }
    }
    return 0;
D 4
  case MYNET:
E 4
I 4
  case IP_MYNET:
E 4
    checkLen(len, sizeof(IPhost));
#define ip_addr (*(IPhost *)buf)
    ip_addr = my_ip_addresses[0];
    /* get the network of this ip_addr */
    if(CLASSA(ip_addr)) ip_addr.b = 0;
    if(!CLASSC(ip_addr)) ip_addr.c = 0;
    ip_addr.d = 0;
#undef ip_addr
    return sizeof(IPhost);

  default:
    x_errno = INVALID_OPCODE;
    return -1;
  }
}

ip_controlsessn(s, opcode, buf, len)
XObj	s;
int	opcode;
char	*buf;
int	len;
{
  IPstate *ip_state;

  
  TRACE2(ipp, 7, "in ip_control_sessn, s = %x, buf = %x", s, buf);
  assert(x_is_session(s));
  ip_state = (IPstate *) s->state;
  TRACE1(ipp, 7, "ip_state=%x", ip_state);
  switch (opcode) {

D 4
  case MAXPACKET:
E 4
I 4
  case GETMAXPACKET:
E 4
    checkLen(len, sizeof(int));
    *(int*)buf = 64*1024;
    return sizeof(int);

D 4
  case MAXOPTIMALPACKET:
E 4
I 4
  case GETOPTPACKET:
E 4
    {
      int lowerMax;
      checkLen(len, sizeof(int));
D 4
      if (x_controlsessn(s->down[0], MAXOPTIMALPACKET, (char *)&lowerMax,
E 4
I 4
      if (x_controlsessn(s->down[0], GETOPTPACKET, (char *)&lowerMax,
E 4
			 sizeof lowerMax) != sizeof lowerMax) {
	return -1;
      }
      *(int *)buf = lowerMax - sizeof(IPheader);
      return sizeof(int);
    }

D 4
  case MYADDRANDPEERADDR:
E 4
I 4
  case GETALLADDRS:
E 4
    checkLen(len, 2 * sizeof(IPhost));
    *(IPhost *)buf = ip_state->hdr.ip_src;
    buf += sizeof(IPhost);
    *(IPhost *)buf =ip_state->hdr.ip_dest;
    return 2 * sizeof(IPhost);
  
D 4
  case PEERADDRANDMYADDR:
    checkLen(len, 2 * sizeof(IPhost));
    *(IPhost *)buf =ip_state->hdr.ip_dest;
    buf += sizeof(IPhost);
    *(IPhost *)buf = ip_state->hdr.ip_src;
    return 2 * sizeof(IPhost);
  
  case MYADDR:
E 4
I 4
  case GETMYADDR:
E 4
    checkLen(len, sizeof(IPhost));
    *(IPhost *)buf =ip_state->hdr.ip_src;
    return sizeof(IPhost);

D 4
  case PEERADDR:
E 4
I 4
  case GETPEERADDR:
E 4
    checkLen(len, sizeof(IPhost));
    *(IPhost *)buf =ip_state->hdr.ip_dest;
    return sizeof(IPhost);

D 4
  case MYNET:
E 4
I 4
  case IP_MYNET:
E 4
    checkLen(len, sizeof(IPhost));
#define ip_addr (*(IPhost *)buf)
    ip_addr = ip_state->hdr.ip_src;
    /* get the network of this ip_addr */
    if(CLASSA(ip_addr)) ip_addr.b = 0;
    if(!CLASSC(ip_addr)) ip_addr.c = 0;
    ip_addr.d = 0;
#undef ip_addr
    return sizeof(IPhost);

  case IP_REDIRECT:
    {
      IPhost net, gateway;
      RTE *rte;
      OLD_PROTL interface;

      checkLen(len, 2*sizeof(IPhost));
      net = *(IPhost *)buf;
      gateway = *(IPhost *)(buf+4);

#ifdef UNDEF
      /* disabled-the decision for whether a redirect is for a whole net or
	 just a single host is made by the sender of the control message.
	 ICMP, for instance, does the right thing BEFORE this point. */
      /* get the network of this ip_addr */
      if(CLASSA(net)) net.b = 0;
      if(!CLASSC(net)) net.c = 0;
      net.d = 0;
#endif
      TRACE4(ipp, 4, "ip_control receives redirect for address %d.%d.%d.%d",
	     net.a,net.b,net.c,net.d);
      TRACE4(ipp, 4, "new gateway to send to: %d.%d.%d.%d",
	     gateway.a,gateway.b,gateway.c,gateway.d);
      if((rte = (RTE *)map_resolve(ip_routing_table,(char *)&net))
	 == (RTE *)-1){
	char nbuf[64];
	int nlen = 64;
	interface = ip_router(gateway,(IPhost *)NULL,nbuf,&nlen);
	ip_rt_insert(net,interface,gateway);
      } else {
	rte->GWaddr = gateway;
      }
    }
    return 0;

  case IP_SHOWSETTINGS:
    checkLen(len, IPHLEN);
    *(IPheader *)buf = ip_state->hdr;
    return IPHLEN;

  case IP_SETV:
    ip_state->hdr.ip_v = *(u_char *)buf;
    return *buf;

  case IP_SETTOS:
    ip_state->hdr.ip_tos = *(u_char *)buf;
    return *buf;

  case IP_SETID:
    ip_state->ip_id = *(u_short *)buf;
    return *(u_short *)buf;

  case IP_SETTTL:
    ip_state->hdr.ip_ttl = *(u_char *)buf;
    return *buf;

D 4
  case IP_SETPROT:
    ip_state->hdr.ip_protocol = *(u_char *)buf;
    return *buf;

E 4
  case IP_SETSRC:
    { u_long foo;
      foo = *(u_long *)buf;
      ip_state->hdr.ip_src = *(IPhost *)&foo;
      return *(int *)buf;
    }

  case IP_SETDEST:
    { u_long foo;
      foo = *((u_long *)buf);
      ip_state->hdr.ip_dest = *(IPhost *)&foo;
      return *(int *)buf;
    }
D 4
  case IP_SET_SECURITY:
  case IP_SET_LOOSE_RT:
  case IP_SET_STRICT_RT:
  case IP_SET_RECORD_RT:
  case IP_SET_STREAM_ID:
  case IP_SET_TIMESTAMP:
E 4
I 4
  case IP_SETSECURITY:
  case IP_SETLOOSERT:
  case IP_SETSTRICTRT:
  case IP_SETRECORDRT:
  case IP_SETSTREAMID:
  case IP_SETTIMESTAMP:
E 4
    ip_state->options = ip_add_option(&ip_state->hdr,ip_state->options,buf,len);
    break;

D 4
  case IP_CLR_SECURITY:
  case IP_CLR_LOOSE_RT:
  case IP_CLR_STRICT_RT:
  case IP_CLR_RECORD_RT:
  case IP_CLR_STREAM_ID:
  case IP_CLR_TIMESTAMP:
E 4
I 4
  case IP_CLRSECURITY:
  case IP_CLRLOOSERT:
  case IP_CLRSTRICTRT:
  case IP_CLRRECORDRT:
  case IP_CLRSTREAMID:
  case IP_CLRTIMESTAMP:
E 4
    ip_state->options = ip_delete_option(&ip_state->hdr,ip_state->options,opcode);
    break;

D 4
  case IP_GET_PROTO:
E 4
I 4
  case GETPROTO:
E 4
    checkLen(len, sizeof(unsigned char));
    *(unsigned char *)buf = ip_state->hdr.ip_protocol;
    return sizeof(unsigned char);

I 4
  case SETPROTO:
    ip_state->hdr.ip_protocol = *(u_char *)buf;
    return *buf;

E 4
  default:
    x_errno = INVALID_OPCODE;
    return -1;
  }
  /*NOTREACHED*/
}

/*ARGSUSED*/
ip_push(s, msg, rmsg)
Sessn	s;
D 4
MSG	msg, *rmsg;
E 4
I 4
Msg	msg, *rmsg;
E 4
{
  IPstate  *ip_state;

  TRACE1(ipp, 3, "in ip push, s is %x",s);
  IFTRACE(ipp, 3) msg_display(msg,0);

  ip_state = (IPstate *) s->state;
  TRACE1(ipp, 3, "in ip push, s->state is %x",s->state);
  TRACE1(ipp, 3, "in ip push, ip_state->down_s is %x",ip_state->down_s);
  return ip_dispatch(ip_state, msg, FALSE);
}

/*ARGSUSED*/
ip_demux(self,s, dg)
XObj	self;
XObj	s;
D 4
MSG	dg;
E 4
I 4
Msg	dg;
E 4
{
  register IPheader *h;
  Part    part[3];
  XObj	  hlp;
  Sessn   ip_s;
  ActiveId activeid;
  PassiveId passiveid;
  int i;
  IPhost gw;

  TRACE0(ipp, 3, "in ip demux");
  IFTRACE(ipp, 3) msg_display(dg,0);
  h = (IPheader *) msg_top(dg, IPHLEN);

  /* Check the IP checksum of the header */
  {
    unsigned short cksum = my_cksum((char *)h);
    if (cksum != 0) {
D 4
      printf("IP header cksum problem = %x\n", cksum);
E 4
I 4
      TRACE1(ipp, 3, "IP header cksum problem = %x", cksum);
E 4
      msg_free(dg);
      return;
    }
  }

  ntoh_iphdr(h);

  /* dump the entire header out */
  TRACE4(ipp,7,
	 "h->ip_v = %d, h->ip_hl  = %d, h->ip_tos = %d, h->ip_len = %d,",
	 h->ip_v,h->ip_hl,h->ip_tos,h->ip_len);
  TRACE4(ipp,7,
	 "h->ip_id = %d, h->ip_off = %d, h->ip_ttl = %d, h->ip_pro = %x,"
	 ,h->ip_id,h->ip_off,h->ip_ttl,h->ip_protocol);
  TRACE4(ipp,7,"h->ip_src = %d.%d.%d.%d,",
	 h->ip_src.a,h->ip_src.b,h->ip_src.c,h->ip_src.d);
  TRACE4(ipp,7,"h->ip_dest = %d.%d.%d.%d,",
	 h->ip_dest.a,h->ip_dest.b,h->ip_dest.c,h->ip_dest.d);
  TRACE2(ipp, 7, "h->ip_sum = %d, msg_len = %d", h->ip_sum, msg_len(dg));

  
  if (h->ip_len != msg_len(dg))  msg_chopright(dg, dg, (int)h->ip_len);

  if (((IP_OPTION_HANDLER(dg,h))!= -1) && !ip_me(h->ip_dest)) {
    if(ip_i_am_a_gateway) { /* forward it */
      OLD_PROTL interface;
      IPstate baz;
D 4
      MSG fdg;
E 4
I 4
      Msg fdg;
E 4
      struct {
	unsigned short type;
	char nbuf[6];
      } remoteaddr;
      int nlen = 6;

      TRACE4(ipp,6,"ip attempting to forward packet to %d.%d.%d.%d",
	     h->ip_dest.a,h->ip_dest.b,h->ip_dest.c,h->ip_dest.d);
      if((interface = ip_router(h->ip_dest, (IPhost *)NULL, remoteaddr.nbuf, &nlen)) == ERR_OLD_PROTL){
	x_errno = BAD_ADDR;
	TRACE0(ipp,3,"ip open error #2");
	return 0;
      } else {
	remoteaddr.type = my_ether_address.type;
	init_partlist(part, 2, ETHaddr);
	set_part(part, 0, my_ether_address);
	set_part(part, 1, remoteaddr);

	if((baz.down_s = x_open(IP_SELF, x_tonew(interface), part)) == ERR_SESSN) {
	  TRACE4(ipp, 3, "...dropping a message sent to %d.%d.%d.%d",
		 h->ip_dest.a, h->ip_dest.b, h->ip_dest.c, h->ip_dest.d);
	  TRACE0(ipp, 3, "can't open session to forward!");
	  msg_free(dg);
	  return 0;
	} else {
	  msg_save(fdg,dg);
	  msg_pop(fdg,IPHLEN);

	  if(!(--(h->ip_ttl))){
	    TRACE5(ipp,5,
		   "...ttl expires on a message (id %d) sent to %d.%d.%d.%d",
		   h->ip_id, h->ip_dest.a, h->ip_dest.b,
		   h->ip_dest.c, h->ip_dest.d);
	    msg_free(dg);
	    msg_free(fdg);
	    return 0;
	  }
	  for(i=0;i<netInterfaces;i++){
	    /* if source is on one of my directly attached nets */
	    if(IP_NETEQ(h->ip_src,interface2ipaddr[i])){
	      ip_router(h->ip_dest,&gw,remoteaddr.nbuf,&nlen);
	      /* if router selects a gateway on that same net */
	      if(IP_NETEQ(h->ip_src,gw)) {
		char foo[5];
		*(IPhost *)(foo+1) = gw;
		*foo = (char)h->ip_hl;
		/* then generate an ICMP redirect message */
		icmp_control_pop(ICMP_REDIRECT,dg,foo,sizeof(foo));
	      }
	      break;
	    }
	  }
	  baz.hdr = *h;
	  baz.buffers = (Map)0;
	  if(ip_dispatch(&baz,fdg,TRUE)== -1){
	    TRACE0(ipp, 3, "can't forward message!");
	  }
#ifndef UNDEF
	  x_close(baz.down_s);
#endif
	  msg_free(dg);		/* Rice fix; 7/2/90 */
	  return 0;
	}
      }
    } else {			/* it isn't to me, but I am not a gateway! */
      TRACE4(ipp, 3, "...dropping a message sent to %d.%d.%d.%d",
	     h->ip_dest.a, h->ip_dest.b, h->ip_dest.c, h->ip_dest.d);
      msg_free(dg);
      return 0;
    }
  }
  activeid.pad[0] = activeid.pad[1] = activeid.pad[2] = 0;
  activeid.protocolnum = h->ip_protocol;
  activeid.host = h->ip_src;
  ip_s = (Sessn)map_resolve(activemap, (char *)&activeid);
  if (ip_s != ERR_SESSN) {
    char *state;
    if ((state = ip_s->state) <= ST_BROKEN) {
      if (state == ST_INITIALIZING) {
	ip_s->rcnt++;
	P((Semaphore *)ip_s->mutex);
	state = ip_s->state;
	ip_close(ip_s);
      }
      if (state == ST_BROKEN) {
	/* this session is dead */
	msg_free(dg);
	return(0);
      }
    }
    
    if(COMPLETEPACKET(*h)) {
      IP_CLEAR_RESOURCES(ip_s,h);
      return X_POP(ip_s, s, dg);
    } else {
      return ip_repatch(ip_s,dg,h);
    }
  }
  /*
   * This packet is not for an existing session.
   */
  {
    static XObj arp = 0, eth = 0;
    if (arp == 0) arp = x_getprotlbyname("arp");
    if (eth == 0) eth = x_getprotlbyname("eth");
    if (s->myprotl == eth) {
      /*
       * Help arp out, tell it the eth to ip mapping for the source.
       */
      struct foo {
	IPhost ipaddr;
	ETHhost  eaddr;
      } f;
      
      f.ipaddr = activeid.host;
D 4
      if (x_controlsessn(s, PEERADDR, (char *)&f.eaddr, sizeof f.eaddr)<0) {
	TRACE1(ipp, 2, "ip_demux:  control (PEERADDR) on %X failed", s);
E 4
I 4
      if (x_controlsessn(s, GETPEERADDR, (char *)&f.eaddr, sizeof f.eaddr)<0) {
	TRACE1(ipp, 2, "ip_demux:  control (GETPEERADDR) on %X failed", s);
E 4
      } else {
	TRACE4(ipp, 2,
	  "ip_demux: telling arp about %4x.%4x.%4x -> %X",
	  f.eaddr.high, f.eaddr.mid, f.eaddr.low, *(long *)&f.ipaddr);
	if (x_controlprotl(arp, ARP_INSTALL, (char *)&f, sizeof f) < 0) {
	  TRACE0(ipp, 2, "ip_demux: can't install mapping in arp");
	}
      }
    }
  }
  /*
   * Check for openenables
   */
  passiveid = activeid.protocolnum;
  hlp = (XObj)map_resolve(passivemap, (char *)&passiveid);
  if (hlp != ERR_XOBJ) {
    IPaddr localaddr, remoteaddr;
    init_partlist(part, 2, IPaddr);
    localaddr.protocolnum = h->ip_protocol;
    remoteaddr.protocolnum = localaddr.protocolnum;
    remoteaddr.host = h->ip_src;
    set_part(part, 0, localaddr);
    set_part(part, 1, remoteaddr);
    TRACE1(ipp, 3, "Calling self.open for prot %d", hlp);
    ip_s = x_open(hlp, self, part);
    if (ip_s != ERR_XOBJ) {
      TRACE1(ipp, 3, "Calling open done for prot %d", hlp);
      x_callopendone(hlp, ip_s, part);
      TRACE1(ipp, 3, "Popping to session %x", ip_s);
      
      if(COMPLETEPACKET(*h)) {
	IP_CLEAR_RESOURCES(ip_s,h);
	return X_POP(ip_s, (XObj)NULL, dg);
      } else {
	return ip_repatch(ip_s,dg,h);
      }
    }
  }
  TRACE1(ipp, 3, "...dropping the message, proto = %d", h->ip_protocol);
  msg_free(dg);
  return 0;
}

/*
  Although the llp school of design specified reassembly logic here,
  it actually goes in demux, where the header is actually decoded.
*/
/*ARGSUSED*/
ip_pop(s, ds, dg)
Sessn	s, ds;
D 4
MSG	dg;
E 4
I 4
Msg	dg;
E 4
{
  TRACE0(ipp, 3, "in ip pop");
  msg_pop(dg, IPHLEN);
  return x_demux(s, dg);
}

/* fill in a protocol or session object with correct stuff */
ip_getproc(p,type)
XObj p;
D 4
XobjType type;
E 4
I 4
XObjType type;
E 4
{
  TRACE1(ipp, 3, "in ip getproc, type = %s", type == Session ? "Session" : "Protocol");
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = ip_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = ip_controlprotl;
  } else {
    p->push = ip_push;
    p->pop = ip_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = ip_close;
    p->control = ip_controlsessn;
  }
  p->demux = ip_demux;
  p->open = (Pfi) ip_open;
  p->openenable = ip_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->getproc = ip_getproc;
  TRACE0(ipp, 3, "done ip getproc");
}

/* inline this */
ntoh_iphdr(hdr)
register IPheader *hdr;
{
#ifdef UNDEF
  (*((u_short *)hdr)) = ntohs(*((u_short *)hdr)); /* ip_v, ip_hl, ip_tos */
#endif
  hdr->ip_len = ntohs(hdr->ip_len);
  hdr->ip_id  = ntohs(hdr->ip_id);
  hdr->ip_off = ntohs(hdr->ip_off);
  hdr->ip_sum = ntohs(hdr->ip_sum);
}

/* IP fragmentation submodule */


/* ip_dispatch - fragment routine from RFC 791, p 26 */
/* Make this an inline procedure...*/
ip_dispatch(state, msg, forwarding)
IPstate *state;
D 4
MSG msg;
E 4
I 4
Msg msg;
E 4
int forwarding; /* are we merely forwarding this packet? */
{
D 4
  MSG dg;
E 4
I 4
  Msg dg;
E 4
  Sessn s;
  IPheader *iph,*hptr;
  IPheader hdr;
  int llp;
  u_short off,ihl,len,nfb,metamore=FALSE;
#ifndef NDEBUG
  int firsttime = 1;
#endif

  TRACE1(ipp, 3, "in ip dispatch%s",(forwarding?", forwarding":""));

  s = state->down_s;
  llp = s->index;
  hdr = state->hdr;
  iph = &hdr;
  ihl = iph->ip_hl<<2;

  /* commit invariants to network order */
  if(!forwarding) {
    iph->ip_id = htons(state->ip_id++);
    iph->ip_off = 0;
  }
/*
  (*((u_short *)iph)) = htons(*((u_short *)iph));
*/

  /* determine the mtu */
  if(!mtu[llp] &&
D 4
     x_controlsessn(s,MAXPACKET,(char *)&(mtu[llp]),sizeof(int))!=sizeof(int)){
E 4
I 4
     x_controlsessn(s, GETMAXPACKET, (char *)&(mtu[llp]), sizeof(int)) !=
     sizeof(int)) {
E 4
    TRACE0(ipp,3,"ip dispatch fails to determine mtu!");
    return -1;
  }

#ifndef UNDEF
  off = iph->ip_off;
  metamore = off & MOREFRAGMENTS;
#else
  off = 0;
#endif
  TRACE3(ipp, 5, "ip dispatch reports mtu of %d, off 0x%x, %s",
	 mtu[llp],off,(metamore? "more to follow" : "no more"));

  len = msg_len(msg);
  while(1) {
    if((len+20) <= mtu[llp]) { /* produce the last fragment */
      TRACE0(ipp,7,"ip dispatch sending the last fragment");
      iph->ip_len  = htons(len+20);

      iph->ip_off  = off;

#ifndef UNDEF
      if(metamore) iph->ip_off = htons(iph->ip_off | MOREFRAGMENTS);
      else iph->ip_off = htons(iph->ip_off & ~MOREFRAGMENTS);
#else
      iph->ip_off  = htons(iph->ip_off & ~MOREFRAGMENTS);
#endif
      iph->ip_sum  = 0;
      iph->ip_sum  = my_cksum((char *)iph);

      hptr = (IPheader *)msg_push(msg,IPHLEN);
      *hptr = *iph;
      dg = msg;

      TRACE2(ipp,5,"pushing %d bytes at offset %x",
	     msg_len(dg)/*nfb<<3*/,(off&OFFSET)<<3);
D 4
      return x_push(s, dg,(MSG *)0);
E 4
I 4
      return x_push(s, dg,(Msg *)0);
E 4
    } else if (DONTFRAGMENT & (off)) {     /* discard datagram */
      msg_free(msg); /* check this*/
      return DISCARDED_DF;
    } else {                            /* produce the first fragment */
      TRACE0(ipp,5,"ip dispatch sending a nonfinal fragment");
#define ORIGINALLENGTHCALCULATION
#ifdef ORIGINALLENGTHCALCULATION
      nfb = (mtu[llp] - ihl)>>3;
#else
      nfb = (len % 1024) > 100 ? (len % 1024) : len % 1024 + 1024;
      nfb >>= 3;
#endif
      TRACE1(ipp,11,"ip dispatch number of fragment blocks %d",nfb);
      iph->ip_len  = htons((nfb<<3)+ihl);
      iph->ip_off  = off;
      TRACE2(ipp,7,"::off %d, ip_off %d",off, iph->ip_off);
      iph->ip_off  = htons(iph->ip_off | MOREFRAGMENTS);
      iph->ip_sum  = 0;
      iph->ip_sum  = my_cksum((char *)iph);

      /* dump message stats */

      {
D 4
	MSG rest;
E 4
I 4
	Msg rest;
E 4
	msg_break(msg,rest,(int)(nfb<<3),MSG_SSIZE);
        hptr = (IPheader *)msg_push(msg,IPHLEN);
        *hptr = *iph;
        dg = msg;
        msg = rest;
      }

      /* dump message stats */
      TRACE0(ipp,8,"after:");

      TRACE2(ipp,5,"pushing %d bytes at offset %d",
	     msg_len(dg)/*nfb<<3*/,(off&OFFSET)<<3);

#ifndef NDEBUG
      assert(!firsttime || (ntohs(iph->ip_off) & OFFSET) == 0);
      firsttime = 0;
#endif
#ifdef UNDEF
      /*hardwire a fault into boclin's IP!
	test reassembly garbage collection*/
      {
	char foo[100];
	extern gethostname();
	gethostname(foo,99);
	if(foo[0]=='b'){
D 4
	  return x_push(s,dg,(MSG *)0);
E 4
I 4
	  return x_push(s,dg,(Msg *)0);
E 4
	}
      }
#else
D 4
      if(x_push(s,dg,(MSG *)0)== -1) { /* push failed */
E 4
I 4
      if(x_push(s,dg,(Msg *)0)== -1) { /* push failed */
E 4
	msg_free(dg);
	msg_free(msg);
	return -1;
      }
#endif
      /* reset values and resubmit */

/* length of options not copied */
#define LOONC 0
/*
      iph->ip_hl  = (ihl-LOONC+3)>>2;
*/
      len -= ((nfb<<3) + LOONC);

      TRACE2(ipp,7,"off = %d, nfb = %d",off,nfb);
      off  = (off & OFFSET)+nfb;
    }
  }
}

/*
 * ip_reassembly_done
 */
ip_reassembly_done(rr)
RR *rr;
{
  return rr->nHoles == 0 && rr->length != 0;
}


/*
 * ip_repatch - reassemble (and maybe deliver) datagram fragments
 * If we have gotten this far, we have already sorted out protocol and
 * source address.  To find the correct reassembly resource, we must also
 * consult the destination (here, but which internet address?) and
 * message ID.  Another layer of maps is therefore added here.  The key for
 * reassembly is the combination of the source IP host address and the id
 * in the packet header.
 */

ip_repatch(s, dg, hdr)
Sessn s;
D 4
MSG   dg;
E 4
I 4
Msg   dg;
E 4
IPheader *hdr;
{
  RR *rr;
  Map rrmap;
D 4
  MSG reassembled_message;
E 4
I 4
  Msg reassembled_message;
E 4
  ReassemblyKey key;
  u_short offset, nfb;
  int finished =0;
  int deadline;

  TRACE0(ipp,5,"In ip_repatch\n");

  offset = hdr->ip_off;

  /* find the right reassembly resource (or 'buffer' for you white folks) */
  key.id = hdr->ip_id;
  key.host = hdr->ip_dest;
  rrmap = ((IPstate *)(s->state))->buffers;
  if ((rr = (RR *)map_resolve(rrmap, (char *)&key)) == ERR_RR) {
    /* allocate a reassembly resource */
    rr = (RR *)malloc(sizeof(RR));
    rr->binding = map_bind(rrmap, (char *)&key, (int)rr);
    rr->rrmap   = rrmap;
    rr->length  = 0;
    rr->data    = (MSGlist *)malloc(sizeof(MSGlist));
    TRACE1(ipp, 7, "Allocated msglist at %X", rr->data);
    rr->data->m = dg;

    rr->data->off = (offset & OFFSET);
    nfb = (hdr->ip_len-((hdr->ip_hl)<<2));
    rr->data->len = nfb = ((nfb>>3) + ((nfb & 0x07) ? 1 : 0));
    rr->data->next = NULL;
    
    rr->nHoles = rr->data->off ? 1 : 0;

    /* insert rr into timer structure */
    deadline = (timeout_cursor+hdr->ip_ttl)%256;
    if(ip_timeouts[deadline]){
      rr->t.next = ip_timeouts[deadline];
      rr->t.prev = ip_timeouts[deadline]->prev;
      ip_timeouts[deadline]->prev->next = (IPtimer *)rr;
      ip_timeouts[deadline]->next->prev = (IPtimer *)rr;
    }else{
      rr->t.next = (IPtimer *)rr;
      rr->t.prev = (IPtimer *)rr;
    }
    rr->t.deadline = deadline;
    ip_timeouts[deadline] = (IPtimer *)rr;

    TRACE5(ipp,5,"ip_repatch:Allocated a rr for id %d, dest %d.%d.%d.%d",
	   hdr->ip_id,
	   hdr->ip_dest.a,hdr->ip_dest.b,hdr->ip_dest.c,hdr->ip_dest.d);
    TRACE2(ipp,11,"ip_repatch: inserted msg frag at [%d:%d]",
	     rr->data->off,rr->data->off+nfb-1);

  } else {  /* insert the fragment into the list */
    MSGlist *thismsg, *d1, *d2;

    deadline = (timeout_cursor+hdr->ip_ttl)%256;
    TRACE5(ipp,5,"ip_repatch: found a rr for id %d, dest %d.%d.%d.%d",
	   hdr->ip_id,
	   hdr->ip_dest.a,hdr->ip_dest.b,hdr->ip_dest.c,hdr->ip_dest.d);
    thismsg = (MSGlist *)malloc(sizeof(MSGlist));
    TRACE1(ipp, 7, "Allocated msglist at %X", thismsg);
    thismsg->m = dg;
    thismsg->off = (offset & OFFSET);
    nfb = (hdr->ip_len-((hdr->ip_hl)<<2));
    thismsg->len = nfb = ((nfb>>3) + ((nfb & 0x07) ? 1 : 0));

    for(d1=d2= (rr)->data; d1 && ((d1->off+d1->len) > thismsg->off);NEXT(d1))
      d2 = d1;
    if(d1 == (rr)->data) {
      TRACE2(ipp,11,"fragment [%d:%d] arrives inorder",
	     thismsg->off,thismsg->off+nfb-1);
      (rr)->data = thismsg;
      thismsg->next = d1;
      if (thismsg->off != d1->off + d1->len) rr->nHoles++;
    } else if ((thismsg->off+thismsg->len)<=d2->off) { /* insert cleanly */
      TRACE2(ipp,11,"fragment [%d:%d] arrives late",
	     thismsg->off,thismsg->off+nfb-1);
      thismsg->next = d1;
      d2->next = thismsg;
      --rr->nHoles;
      if (d2->off != thismsg->off + thismsg->len) ++rr->nHoles;
      if (thismsg->off != (d1 ? d1->off + d1->len : 0)) ++rr->nHoles;
    } else {
      TRACE2(ipp,11,"bloody fragments!  fragment [%d:%d] is dropped",
	     thismsg->off,thismsg->off+nfb-1);
#ifdef BUGGY
      TRACE0(fixme, 1, "Free this message!!!!");
#else
      /*
       * Apparently, this code is done if the recieved fragment
       * has already been recieved.  In which case, deallocate
       * the MSGlist made for it and free the actual fragment
       * message.  
       *
       * I'm not sure if we should extend the IP fragmentation
       * timeout or not.  If we do, we could "possibly"
       * never make progress since we could just recieve the
       * same packet fragments without ever getting the missing
       * ones.  On the otherhand, we have evidence that the IP
       * fragments are still coming so why not extend the timeout.
       *
       * I think the "no progress" contigency is more annoying,
       * so I don't make an effort to extend the timeout.
       *
       * -mjk 7/18/90
       */
      msg_free(dg);
      free(thismsg);
      return 0;
#endif
    }

    /* possibly extend this resource's life a little longer */
    if((!(timeout_cursor < deadline && deadline < rr->t.deadline)) ||
       (rr->t.deadline < deadline && deadline < timeout_cursor)){
      int olddeadline;

      olddeadline = rr->t.deadline;
      /* remove from current queue */
      if(ip_timeouts[olddeadline]==(IPtimer *)rr) {
	if(rr->t.next == (IPtimer *)rr) ip_timeouts[olddeadline]= 0;
	else ip_timeouts[olddeadline] = rr->t.next;
      }
      rr->t.deadline = deadline;
      rr->t.prev->next = rr->t.next;
      rr->t.next->prev = rr->t.prev;

      /* insert into later queue */
      if(ip_timeouts[deadline]){
	rr->t.next = ip_timeouts[deadline];
	rr->t.prev = ip_timeouts[deadline]->prev;
	ip_timeouts[deadline]->prev->next = (IPtimer *)rr;
	ip_timeouts[deadline]->next->prev = (IPtimer *)rr;
      }else{
	rr->t.next = (IPtimer *)rr;
	rr->t.prev = (IPtimer *)rr;
      }
      ip_timeouts[deadline] = (IPtimer *)rr;
    }
  }
  if(!(offset & MOREFRAGMENTS)) { /* compute the total data length */
    TRACE1(ipp,11,"Received message suffix, offset = %x",offset);
    rr->length = ((offset & OFFSET)<<3) + hdr->ip_len - (hdr->ip_hl<<2);
  } else {
    TRACE0(ipp,11,"More to follow...");
  }

  if (rr->length) {
    TRACE1(ipp, 11, "rr->length is %d, completion test", rr->length);
  } else {
    TRACE0(ipp,11, "message length unknown, repatch unfinished (no bit test)");
    return 0;
  }
  finished = ip_reassembly_done(rr);
  TRACE1(ipp,5,"ip_repatch reports %s",finished ? "finished" : "unfinished");

  if (finished) {
    MSGlist *d1;
D 4
    MSG temp;
E 4
I 4
    Msg temp;
E 4

    reassembled_message = NULL_MSG;
    for (d1 = rr->data; d1; NEXT(d1)) {
      TRACE2(ipp,9,"Reattaching [%d:%d]",d1->off,d1->off+d1->len-1);
      if (d1->next) {
     
	msg_pop(d1->m,IPHLEN);
        temp = d1->m;
      } else {
	temp = d1->m;
      }
      if (!msg_isnull(reassembled_message)) { 
	msg_join(reassembled_message, temp, reassembled_message);
      } else {
	reassembled_message = temp;
      }
    }
    /* Deallocate RR, and remove it from the timeout thingy */
  
    if (&rr->t == rr->t.next) {
      assert(ip_timeouts[deadline] == &rr->t);
      ip_timeouts[deadline]=NULL;
    }
    if (ip_timeouts[deadline] == &rr->t) ip_timeouts[deadline] = rr->t.next;
    rr->t.next->prev = rr->t.prev;
    rr->t.prev->next = rr->t.next;
    ip_recycle(rr, 0);
  }
  return finished ? X_POP(s, (XObj)NULL, reassembled_message) : 0;
}

ip_recycle(rr, freemsgs)
RR *rr;
int freemsgs;
{
  MSGlist *ml;

  TRACE1(ipp,5,"old fragment (rr=0x%08x) being recycled",rr);
  /* recycle messages */
  while(ml=rr->data){
    rr->data = rr->data->next;
    if (ml->off == 0) TRACE0(fixme, 1, "generate an ICMP timeout message");
    if (freemsgs) msg_free(ml->m);
    TRACE1(ipp, 7, "Freed msglist at %X", ml);
    free((char *)ml);
  }
  map_unbindbinding(rr->rrmap, rr->binding);
  free((char *)rr);
}

/* wakes up once a second and purges the reassembly resources */
ip_garbageman()
{
  IPtimer *bar;

  TRACE1(ipp, 12, "in ip_garbageman, cleaning up %d",timeout_cursor);
  while(bar=ip_timeouts[timeout_cursor]){
    TRACE2(ipp, 7, "in ip_garbageman, cleaning up %d, resourcelist 0x%08x",
	   timeout_cursor,bar);
    if(bar==bar->next){
      ip_recycle((RR *)bar, 1);
      ip_timeouts[timeout_cursor]=NULL;
      continue;
    }
    ip_timeouts[timeout_cursor] = bar->next;
    bar->next->prev = bar->prev;
    bar->prev->next = bar->next;
    ip_recycle((RR *)bar, 1);
  }
  timeout_cursor = ((timeout_cursor+1) % 256);
}



/*
 * ip_options.c
 * Clinton Jeffery 5-8-88
 *
 * This module implements the IP option package.  The following options are
 * implemented:
 *
 * Record route
 * Strict source route
 * Loose source route
 * Stream identifier
 *
 * The following options are not fully implemented at this time:
 *
 * Security  { no plans have been made to add this option }
 * Timestamp { this option will be added in the near future }
 *
 * Options are handled in three places: In ip_demux, options are *processed*,
 * possibly affecting the forwarding of the message.  In ip_control, opcodes
 * allow the *setting* of options for packets sent by a given session.
 * Lastly, preceding the dispatching of noninitial fragments, the normal
 * IP header message must be *filtered* to remove options which are not copied
 * on fragmentation.
 */

/*
 * ip_option_handler
 *
 * This is the main IP gateway option handler.
 * It is called upon receipt of any message whose internet
 * header length is >5 (indicating at least one option is present).
 * Return value of -1 indicates that the message should NOT be forwarded.
 */
ip_option_handler(msg,hdr)
D 4
MSG msg;
E 4
I 4
Msg msg;
E 4
IPheader *hdr;
{
  char *option_buf, *cursor;
  u_char length,ptr;
  IPOption opt;

  TRACE0(ipp, 4, "In ip_option_handler");
  msg_pop(msg,IPHLEN);
  option_buf = msg_top(msg,msg_stack_len(msg));  /* check this */
  msg_push(msg,IPHLEN);
/*
  msg_peek(msg,20,ihl<<2,(char *)option_buf);
*/
  cursor = (char *)option_buf;
  while(((cursor-option_buf)<(((hdr->ip_hl)<<2)-IPHLEN)) && *cursor){
    /* process the next option */
    *(u_char *)&opt = ntohb(*cursor++);
    if(opt.ipopt_class == IP_CONTROLOPT){
      switch(opt.ipopt_number){
      case IP_EOOPT:
	TRACE0(ipp,1,"IP option bug #1! cancelling option handling");
	return 0;
      case IP_NOOPT:
	/* option cursor already advanced 1 */
	break;
      case IP_SECURITY:
	/* copy==TRUE, length==11, but we do not enforce it */
	cursor++; /* advance past the length field */
	{
	  u_short s_field,c_field;
	  s_field = ntohs(*(u_short *)cursor);
	  if(s_field){
	    TRACE0(ipp,3,"Dropping IP packet (security requirements)...");
	    return -1;
	  } else {
	    cursor += 2;
	    c_field = ntohs(*(u_short *)cursor);
	    if(c_field){
	      TRACE0(ipp,3,"Dropping IP packet (compartment requirements)...");
	      return -1;
	    } else {
	      cursor += 2;
	      cursor += 5; /* don't know handling and TCC fields */
	    }
	  }
	}
      case IP_LOOSE_RT:
	length = ntohb(*(u_char *)cursor++);
	ptr = ntohb(*(u_char *)cursor);
	if (ptr<4) goto badparam;
	if ((ptr<=length-4) && (ip_me(hdr->ip_dest))) {/* source routing */
	  char nbuf[64];
	  int  nlen = 64;
	  OLD_PROTL interface;

	  *(u_long *)&(hdr->ip_dest) = *(u_long *)(cursor+ptr-2);
	  /* select the route for the new destination */
	  interface = ip_router(hdr->ip_dest,(IPhost *)NULL,nbuf,&nlen);

	  /* record route taken*/
	  *(u_long *)(cursor+ptr-2)= *(u_long *)&interface2ipaddr[interface];
	  *(u_char *)cursor = htonb(ptr+4);      /* update ptr */
	}
	cursor += (length-2);
	break;
      case IP_STRICT_RT:
	length = ntohb(*(u_char *)cursor++);
	ptr = ntohb(*(u_char *)cursor);
	if (ptr<4) goto badparam;
	if(!ip_me(hdr->ip_dest)){
	  /* someone messed up; strict routing has been violated */
	  goto badparam;
	}
	if (ptr<=length-4) { /* source routing */
	  char nbuf[64];
	  int  nlen = 64;
	  OLD_PROTL interface;
	  IPhost gw;

	  *(u_long *)&(hdr->ip_dest) = *((u_long *)(cursor+ptr-2));

	  /* select the route for the new destination */
	  interface = ip_router(hdr->ip_dest,&gw,nbuf,&nlen);

	  /* this route had better be directly reachable */
	  if(!IP_EQUAL(gw,hdr->ip_dest)) goto badparam;

	  /* record route taken*/
	  *(u_long *)(cursor+ptr-2)= (*(u_long *)&interface2ipaddr[interface]);
	  *(u_char *)cursor = htonb(ptr+4);      /* update ptr */
	}
	cursor += (length-2);
	break;
      case IP_RECORD_RT:
	length = ntohb(*(u_char *)cursor++);
	ptr = ntohb(*(u_char *)cursor);
	if (ptr<4) goto badparam;
	if (ptr<=length-4) { /* record route */
	  char nbuf[64];
	  int  nlen = 64;
	  OLD_PROTL interface;

	  /* find my outgoing interface */
	  interface = ip_router(hdr->ip_dest, (IPhost *)NULL, nbuf, &nlen);

	  /* record route taken*/
	  *(u_long *)(cursor+ptr-2)= (*(u_long *)&interface2ipaddr[interface]);
	  *(u_char *)cursor = htonb(ptr+4);      /* update ptr */
	} else goto badparam;
	cursor += (length-2);
	break;
      case IP_STREAM_ID:
	length = ntohb(*(u_char *)cursor++);
	cursor+=2;
	break;
      default:
	goto badparam;
      }
    } else if ((opt.ipopt_class  == IP_DEBUGGINGOPT) &&
	       (opt.ipopt_number == IP_TIMESTAMP)) { /* timestamp option */

      struct ov_flag v;
      u_long foo;

      if((length = ntohb(*(u_char *)cursor))>40) goto badparam;
      if((ptr = ntohb(*(u_char *)++cursor))<5) goto badparam;
      *(u_char *)&v = ntohb(*(cursor+1));
      switch(v.flag){
      case 0:
	*(u_char *)cursor = ptr+4;
	break;
      case 1:
	*(u_char *)cursor = ptr+8;
	break;
      case 3:
	foo = *(u_long *)(cursor+ptr-2);
	if(ip_me(*(IPhost *)&foo)) *(u_char *)cursor = ptr+8;
	break;
      default:
	goto badparam;
      }
      
    } else { /* bad option */
    badparam:
      /* insert neat code to generate an ICMP badparam message here */
      TRACE0(ipp,3,"bad param messages aren't generated yet!");
      return -1;
    }
  }
  return 0;
}


/*
 * fragment_header
 *
 * Given an IP header message, output the header to attach to
 * (noninitial) fragments before sending.  Do this each dispatch,
 * since the user may have changed options.
 */
D 4
MSG fragment_header(hdr_ptr,tailhdr_ptr,options)
MSG options;
E 4
I 4
Msg fragment_header(hdr_ptr,tailhdr_ptr,options)
Msg options;
E 4
IPheader *hdr_ptr;
IPheader *tailhdr_ptr;
{
  IPheader hdr;
  register IPheader *h;
D 4
  MSG newopts;
E 4
I 4
  Msg newopts;
E 4
  u_char option_first[IPMAXOPTLEN], option_follow[IPMAXOPTLEN];
  u_char *first_cursor, *follow_cursor;
  u_char length,i,foo,newlen;
  IPOption opt;

  hdr = *hdr_ptr;
  h = &hdr;
  if(h->ip_hl > 5){
    msg_peek(options, IPHLEN, (int)((h->ip_hl<<2)-IPHLEN),
      (char *)option_first);
  }
  first_cursor = (u_char *)option_first;
  follow_cursor = (u_char *)option_follow;
  while((first_cursor-option_first)<(h->ip_hl<<2)-IPHLEN){
    /* process the next option */
    foo = *first_cursor++;
    *(u_char *)&opt = ntohb(foo);
    if(opt.ipopt_copy){
      *follow_cursor++ = foo;
    }
    switch(opt.ipopt_number){
    case IP_EOOPT:
      goto done;
    case IP_NOOPT:
      break;
    default:
      length = ntohb(*first_cursor);
      if(opt.ipopt_copy){
	for(i=0;i<length-1;i++) *follow_cursor++ = *first_cursor++;
      } else {
	first_cursor += length-1;
      }
    }
  }
 done:
  while((follow_cursor-option_follow)%4) *follow_cursor++ = 0;
  newlen = follow_cursor-option_follow;
  h->ip_hl = 5 + (newlen>>2);
  *tailhdr_ptr = *h;
  msg_make_allstack(newopts,IPMAXOPTLEN,(char *)option_follow,(int)newlen);
  msg_free(options);
  return newopts;
}


/*
 * ip_add_option
 */
D 4
MSG ip_add_option(hdr,options,buf,len)
E 4
I 4
Msg ip_add_option(hdr,options,buf,len)
E 4
IPheader *hdr;
D 4
MSG options;
E 4
I 4
Msg options;
E 4
char *buf;
int len;
{
  char *temp;

  /* check ntohs on ihl here */
  if (hdr->ip_hl == 5){
    hdr->ip_hl += ((len+3) >>2);
    hdr->ip_len += (((len+3)>>2)<<2);
    if(len % 4){
      temp = msg_push(options,1);
      *temp = '\0'; 
      temp = msg_push(options,len);
      bcopy(buf,temp,len);
      return options;
    } else {
      temp = msg_push(options,len);
      bcopy(buf,temp,len);
      return options;
    }
  } else {
    /* must parse hdrmsg and truncate garbage */
    return options;
  }
}

/*
 * ip_delete_option
 */
/*ARGSUSED*/
D 4
MSG ip_delete_option(hdr,options,opcode)
E 4
I 4
Msg ip_delete_option(hdr,options,opcode)
E 4
IPheader *hdr;
D 4
MSG options;
E 4
I 4
Msg options;
E 4
int opcode;
{
  TRACE0(ipp,1,"warning: ip delete option not implemented!");
  /* will write noops into appropriate bytes here */
  return options;
}


/*
 * ip_router.c - internet routing procedures
 * 5/2/88 cjeffery
 *
 * Well, it is just the case that for an ethernet workstation,
 * simpler is better.  The routing table is a map.  The initial size
 * the routing table is determined at runtime by an inspection of
 * of the configuration (gateways need more space).
 */

/*
 * ip_rt_insert
 *
 * insert an entry into the IP routing table
 */
ip_rt_insert(ip_addr,interface,gw_addr)
IPhost ip_addr, gw_addr;
OLD_PROTL  interface;
{
  RTEPtr rte;

  TRACE4(ipp,7,"In ip_rt_insert with %d.%d.%d.%d",
	 ip_addr.a,ip_addr.b,ip_addr.c,ip_addr.d);
  TRACE5(ipp,7,"  interface %d, to gateway %d.%d.%d.%d",
	 interface,gw_addr.a,gw_addr.b,gw_addr.c,gw_addr.d);
  if((rte=(RTEPtr)malloc(sizeof(RTE)))==NULL){
    TRACE0(ipp,1,"malloc fails in ip_rt_insert!  Die...die...");
/*    exit(-1); */
    return;
  }
  rte->interface = interface;
  rte->GWaddr    = gw_addr;

#ifdef UNDEF
  /* removed to allow redirects */
  /* get the network of this ip_addr */
  if(CLASSA(ip_addr)) ip_addr.b = 0;
  if(!CLASSC(ip_addr)) ip_addr.c = 0;
  ip_addr.d = 0;
#endif
  if((rte->binding = map_bind(ip_routing_table,(char *)&ip_addr,(int)rte))
     ==ERR_BIND){
    TRACE0(ipp,1,"Xbind fails in ip_rt_insert!  Die...die...");
/*    exit(-1); */
    return;
  }
}


/* A guess as to the maximum number of network devices or IPaddrs per
 * routing protocol.
 */
#define MAXSTUFFPERROUTER 4
/*
 * ip_rt_init
 *
 * allocate space for the routing table, based on the number of interfaces
 * build a table of my IP addresses from somewhere (rom?).
 */
ip_rt_init()
{
  int i, j, k, numprotls, numaddrs;
  IPhost addrs[MAXSTUFFPERROUTER];
  OLD_PROTL  protls[MAXSTUFFPERROUTER];
  Part	part[2];
  TRACE1(ipp, 7, "IP routing table init: %d net interfaces", netInterfaces);
  ip_routing_table = map_create((int)(IP_SELF->index) * 25, sizeof(IPhost));

  init_partlist(part, 1, ETHaddr);
  set_part(part, 0, my_ether_address);

  /* build a table of my IP addresses */
  for (i = 0; i < IP_SELF->numdown; i++) {
D 4
    numprotls = x_controlprotl(IP_SELF->down[i], GETIPINTERFACES,
E 4
I 4
    numprotls = x_controlprotl(IP_SELF->down[i], ARP_GETIPINTERFACES,
E 4
      (char *)protls, sizeof protls);
    if (numprotls < 0) {
      if (x_errno == BUFFER_TOO_SMALL) Kabort("Too many PROTLs in ip_init");
      continue;
    }
    numprotls /= sizeof(int);
    for (j = 0; j < numprotls; j++) {
      netInterfaces++;
      if (netInterfaces > 1) ip_i_am_a_gateway = TRUE;
      *(int *)addrs = protls[j];
D 4
      numaddrs = x_controlprotl(IP_SELF->down[i], GETIPADDRS, (char *)addrs,
	sizeof addrs);
E 4
I 4
      numaddrs = x_controlprotl(IP_SELF->down[i], ARP_GETIPADDRS, 
				(char *)addrs, sizeof addrs);
E 4
      if (numaddrs < 0) {
	if (x_errno == BUFFER_TOO_SMALL) Kabort("Too many ADDRs in ip_init");
	continue;
      }
      numaddrs /= sizeof(IPhost);
      if (numaddrs > 1) {
	/* our data structure can't handle this */
	Kabort("Only one ip address allowed per interface");
      }
      x_openenable(IP_SELF, x_tonew(protls[j]), part);
      for (k = 0; k < numaddrs; k++) {
	/* I have a resolver (IP_SELF->down[i]),
	   an interface protls[j] an address addrs[k] */
	IPhost temp;
	temp = addrs[k];
	
	interface2ipaddr[protls[j]] = temp;
	interface2resolution_protocol[protls[j]] = IP_SELF->down[i]->index;
	if (!ip_me(temp)) {
	  TRACE5(ipp,7,"I own class %c inetaddr %d.%d.%d.%d",
		 (CLASSA(temp)?'A':(CLASSB(temp)?'B':'C')),
		 temp.a, temp.b, temp.c, temp.d);
	  my_ip_addresses[num_ip_addresses++] = temp;

	  /* get the network of this ip_addr, enter it for direct delivery */
	  { IPhost temp2;
	    temp2 = temp;
	    if(CLASSA(temp)) temp.b = 0;
	    if(!CLASSC(temp)) temp.c = 0;
	    temp.d = 0;
	    ip_rt_insert(temp,protls[j],temp2);
	    my_ip_addresses[num_ip_addresses++] = temp;
	  }
	}
      }
    }
  }
}


/*
 * ip_router - main routing table query tool
 *
 * returns interface
 * fills in network address in buf and its length in len
 * fills in IP gateway address in gwa (iff gwa is not NULL!).
 */
OLD_PROTL ip_router(ip_addr, gwa, buf, len)
IPhost ip_addr, *gwa;
char *buf;
int  *len;
{
  OLD_PROTL  interface;
  RTE   *rte;
  IPhost gw, *gw_addr, netaddr;
  static Sessn arp[LASTDEVICEPROTOCOL+1];
  static unsigned dev_len[LASTDEVICEPROTOCOL+1];

  if(gwa) gw_addr = gwa; else gw_addr = &gw;

  /* look for a routing table entry for this specific IP address */
  TRACE4(ipp,5,"ip_router resolving %d.%d.%d.%d",
	 ip_addr.a,ip_addr.b,ip_addr.c,ip_addr.d);
  if((rte = (RTE *)map_resolve(ip_routing_table,(char *)&ip_addr))==(RTE *)-1){

    /* now try the network of this ip_addr */
    netaddr = ip_addr;
    if(CLASSA(netaddr)) netaddr.b = 0;
    if(!CLASSC(netaddr)) netaddr.c = 0;
    netaddr.d = 0;
    TRACE4(ipp,5,"ip_router resolving network %d.%d.%d.%d",
	   netaddr.a,netaddr.b,netaddr.c,netaddr.d);
    if((rte =(RTE *)map_resolve(ip_routing_table,(char *)&netaddr))==(RTE *)-1){
      /* select the default */
      (*gw_addr) = ip_Default_Gateway;
      if(ip_me(ip_Default_Gateway) || IP_EQUAL(ip_addr, ip_Default_Gateway)) {
	TRACE0(ipp,1,"Don't know where to forward packet!");
	return ERR_OLD_PROTL;
      }
      return ip_router(ip_Default_Gateway,gwa,buf,len);
    }
  }
  interface = rte->interface;
  (*gw_addr)= rte->GWaddr;
  TRACE4(ipp,7,"Routing table reports desired gateway is %d.%d.%d.%d",
	 (*gw_addr).a,(*gw_addr).b,(*gw_addr).c,(*gw_addr).d);

  /* the 'desired gateway' is on one of our networks...resolve its IPaddr
   * into an <interface,netaddr> pair unless *we* are the 'desired gateway'
   * in which case the final destination is on one of our networks, and we
   * can find *its* <interface,netaddr> pair and deliver the packet directly.
   */
  if (!arp[interface]) {
    arp[interface] = x_open(IP_SELF,x_tonew(interface2resolution_protocol[interface]),
      (Part *)NULL);
    dev_len[interface] = sizeof(ETHhost);
  }
  if(*len < dev_len[interface]) {
    x_errno = BUFFER_TOO_SMALL;
    return ERR_OLD_PROTL;
  }
  *(IPhost *)buf = (ip_me(*gw_addr)?ip_addr:(*gw_addr));
  if(x_controlsessn(arp[interface],RESOLVE,buf,*len) == -1) {
    x_errno = BAD_ADDR;
    return ERR_OLD_PROTL;
  } else {
    *len = dev_len[interface];
  }
  return interface;
}


/* MISCELLANEOUS UTILITIES */

/*
 * inet_iptoa
 *
 * rehash of the unix call inet_ntoa, only using our IPaddr type
 */
char *inet_iptoa(ipa)
IPhost ipa;
{
  static char my_name[16];
  extern char *sprintf();
  sprintf(my_name,"%d.%d.%d.%d",ipa.a,ipa.b,ipa.c,ipa.d);
  return my_name;
}


/*
 * ip_me
 *
 * returns whether this IPaddr is one of my own (relevant to gateways)
 */
ip_me(a)
IPhost a;
{
  int i;
  for(i=0; i<num_ip_addresses; i++){
    if(IP_EQUAL(a, my_ip_addresses[i])) return TRUE;
  }
  return FALSE;
}

my_cksum(hdr)
char *hdr;
{
  return(0xFFFF & ~ocsum(hdr,10));
}
#ifdef XSIMUL
#ifdef sun
asm("	.text");

asm("| Do a 16 bit one's complement sum of a given number of words");
asm("| The word pointer may not be odd");
asm(".globl	_ocsum");
asm("_ocsum:");
asm("	movl	sp@(4),a0	| get ptr");
asm("	movl	sp@(8),d0	| get word count");
asm("	movl	d2,sp@-		| save a reg");
asm("	movl	d0,d2		| save the count");
asm("	lsrl	#1,d0		| make d0 longs");
asm("	movl	#0,d1		| zero accumulator");
D 3
asm("	jra	1$		| into loop");
E 3
I 3
asm("	jra	1f		| into loop");
E 3
asm("| Here we run in 68010 loop mode until we get a carry");
D 3
asm("2$:	addl	a0@+,d1		| add in long");
asm("1$:	dbcs	d0,2$		| continue until carry or done");
asm("	jcc	3$		| if no carry, we're done");
E 3
I 3
asm("2:	addl	a0@+,d1		| add in long");
asm("1:	dbcs	d0,2b		| continue until carry or done");
asm("	jcc	3f		| if no carry, we're done");
E 3
asm("	addql	#1,d1		| add in carry");
D 3
asm("	jra	1$		| and go back to test for carry again");
asm("3$:	btst	#0,d2		| another short?");
E 3
I 3
asm("	jra	1b		| and go back to test for carry again");
asm("3:	btst	#0,d2		| another short?");
E 3
asm("	jeq	ret		| no, go away");
asm("	movl	#0,d0		| must do unsigned add");
asm("	movw	a0@,d0		| get the short");
asm("	addl	d0,d1		| add it in");
asm("	jcc	ret");
asm("	addql	#1,d1");
asm("| Now add in high word to low word as above");
asm("ret:");
asm("	movl	d1,d0");
asm("	lsrl	#8,d0		| get high word in d0");
asm("	lsrl	#8,d0		| and clear high do as well");
asm("	andl	#0xFFFF,d1	| clear high d1");
asm("	addw	d1,d0		| add in just the low word");
asm("	movl	#0,d1		| doesn't clear x bit");
asm("	addxw	d1,d0		| add in final carry");
asm("	movl	sp@+,d2		| restore reg");
asm("	rts			| all done");
#endif

#ifdef vax
D 5
asm("	.text");
asm("	.globl	_ocsum");
asm("_ocsum:");
asm("	.word 0");
asm("	clrl	r0");
asm("	ret");
E 5
I 5
int
ocsum(char *hdr, int count)
{
    return 0xFFFF;
}	 
E 5
#endif
I 5

E 5
#endif
E 1
