h10735
s 00006/00004/00103
d D 1.2 91/01/10 11:44:47 llp 2 1
c Prepared for 3.1 Distribution
e
s 00107/00000/00000
d D 1.1 90/11/16 10:52:58 menze 1 0
c date and time created 90/11/16 10:52:58 by menze
e
u
U
f e 0
t
T
I 1
/* 
 * chan_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */
 
D 2
#pragma once
E 2
I 2
#ifndef chan_internal_h
#define chan_internal_h
E 2

#define CHANHLEN  sizeof(CHAN_HDR) 
#define CHANEXTIDLEN sizeof(EXT_ID);
/* Size of largest address which might be below a channel session */
#define BIGADDR 64
 
typedef enum {old,current,new} SEQ_STAT;

 
typedef struct  {
        unsigned short chan;
	unsigned int prot_id;
	unsigned int seq;
	unsigned short flags;
	unsigned short err;
        unsigned boot_id;
	unsigned int len;
} CHAN_HDR;

/* message types */
#define REQUEST		((unsigned short) 0x0100)
#define REPLY           ((unsigned short) 0x0800)
#define EXPLICIT_ACK    ((unsigned short) 0x0400)
#define PROBE           ((unsigned short) 0x0200)
/* true flags */
#define ACK_REQUESTED   ((unsigned short) 0x0001)
#define SRVR_ERR        ((unsigned short) 0x0008)
#define FOR_SRVR        ((unsigned short) 0x0010)

/* error types */
#define CHAN_OK 1
#define CHAN_NO_SEVER 2

/* direction field values */
#define CLIENT 1
#define SERVER 2

typedef struct {
        unsigned short chan;
        unsigned char cur_state;
        unsigned int cur_seq;
        unsigned int boot_id;
        unsigned int prot_id;
        CHAN_HDR cur_hdr;
	CHAN_HDR hdr;
D 2
        MSG saved_msg;
        MSG answer;
E 2
I 2
        Msg saved_msg;
        Msg answer;
E 2
        int wait;
        int tries;
        int event;
        Semaphore reply_sem;
        int ticket;
  	XObj down_s;
	int direction;
	CHANaddr myCHANaddr;
	CHANaddr peerCHANaddr;
	IPhost server;
	IPhost client;
} CHAN_STATE;

/* SERVER STATES */
#define SVC_EXECUTE 1
#define SVC_WAIT 2
#define SVC_NEW 3
#define SVC_ZERO 4
/* CLIENT STATES */
#define CLNT_WAIT 10
#define CLNT_FREE 11 

#define START_SEQ 0

#define GOOD_BOOTID 15
#define BAD_BOOTID 257 


typedef struct {
	Map active_server_map;
	Map active_client_map;
	Map passive_map;
	unsigned short channel_number;
	IPaddr myIPaddr;
} PSTATE;

typedef struct {
        unsigned short direction;
	unsigned short chan;
	XObj down_s;
        unsigned int prot_id;
} ActiveID;

typedef unsigned int PassiveID;	/* prot_id serves as passive key */

#ifndef SPRITE_FLUSH 
#define SPRITE_FLUSH
#define flush_msg(m) { if (!msg_isnull(m)) {msg_free(m);msg_clear(m); }}
#define flush_event(e) { if (e) {event_removeevent(e); e=0;}}
#endif

I 2
#endif
E 2
E 1
