/* 
 * mse.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "mse.h"

int tracemsep;
static XObj MSE;
#define SCC (MSE->down[0])

/*
 * On the Sun-3, the mouse is connected to a serial chip, and
 * the serial interrupt routine calls SmiMouseSqueak().  
 */

static Sessn thesession = NULL;
mse_init(self)
XObj self;
{
  MSE = self;
}

/*ARGSUSED*/
Sessn mse_open(self, hlp, parts)
XObj self, hlp;
Part *parts;
{
  register Sessn s, lls;
  Part whom[2];
  int myChannel = 1;
  TRACE0(msep, 3, "mse_open");

  /* The mouse is a single-user device; check for conflict */
  
  if (thesession != NULL) {
    TRACE0(msep, 1, "Open of busy device, return ERR_SESSN");
    return (ERR_SESSN);
  }

  init_partlist(whom, 1, int);
  set_part(whom, 0, myChannel);


/* these lines replaced by above 2 lines -- may be removed if it works
                                                        071990 cliff
  whom[0].address = (char *) &myChannel;
  whom[0].length = 4;
  whom[1].address = NULL;
  whom[1].length = 0;
*/
  lls = x_open(MSE, SCC, whom);
  if (lls == ERR_SESSN) {
    TRACE1(msep, 1, "Error opening scc channel %d", myChannel);
    return(ERR_SESSN);
  }
  s = x_createsession(hlp, MSE, 1);
  s->numdown = 1;
  s->down[0] = lls;
  thesession = s;

  TRACE1(msep, 3, "mse open returns %x", thesession);
  return( thesession );
}

mse_close(s)
Sessn s;
{
  TRACE1(msep, 3, "mse close %x", s);
  thesession = NULL;
  s->state = NULL;
  x_destroysession(s);
}

/*ARGSUSED*/
mse_demux(s, msg)
Sessn s;
Msg msg;
{
  char squeak;
  static state = 0;
  static MouseInfo *mi;
  static Msg m;
#ifdef DEBUGMOUSE
  static char squeaks[6];
#endif

  squeak = msg_top(msg,1)[0];
  msg_free(msg);
  /* Check for sync byte */
  if ((squeak & 0xf8) == 0x80) state = 0;
#ifdef DEBUGMOUSE
  squeaks[state] = squeak;
#endif
  switch (state++) {
    case 0:
#ifdef DEBUGMOUSE
      squeaks[1] = squeaks[2] = squeaks[3] = squeaks[4] = 0x7e;
#endif
      if (msg_isnull(m)) {
	msg_make_allstack(m,128,(char *)0,0);
	mi = (MouseInfo *)msg_top(m,sizeof(MouseInfo));
      }
      /* Sync byte + buttons */
      mi->buttons = squeak & 7;
      mi->dx = 0;
      mi->dy = 0;
      break;
    case 1:
    case 3:
      /* Current reading is dx */
      mi->dx += squeak;
      break;
    case 2:        
      /* Current reading is dy */
      mi->dy += squeak;
      break;
    case 4:
      /* Current reading is dy, last byte of sequence */
      mi->dy += squeak;
#ifdef DEBUGMOUSE
      TRACE5(msep, 5, "mouses %x %d %d %d %d", squeaks[0], squeaks[1],
	squeaks[2], squeaks[3], squeaks[4]);
#endif
      TRACE4(msep, 5, "mouse popping %x %d %d to %x", mi->buttons, mi->dx,
	mi->dy, thesession);
      msg = m;
      msg_clear(m);
      x_demux(thesession, msg);
      break;
    default:
      break;
  }
}

static noop() {}

mse_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = mse_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = noop;
  } else {
    p->push = noop;
    p->pop = noop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = mse_close;
    p->control = noop;
  }
  p->open = (Pfi) mse_open;
  p->openenable = noop;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = mse_demux;
  p->getproc = mse_getproc;
}

