/* 
 * kbd.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "kbd.h"

int tracekbdp;

static Sessn thesession = NULL, thells;
static unsigned down[128 / sizeof(unsigned)];
static XObj KBD;
#define SCC (KBD->down[0])

kbd_init(self)
XObj self;
{
  int myChannel = 0;
  Part whom[2];
  KBD = self;

  init_partlist(whom, 1, int);
  set_part(whom, 0, myChannel);


/* these lines replaced by above 2 lines -- may be removed if it works
                                                        071990 cliff

  whom[0].address = (char *) &myChannel;
  whom[0].length = 4;
  whom[1].address = NULL;
  whom[1].length = 0;
*/
  thells = x_open(KBD, SCC, whom);
  if (thells == ERR_SESSN) {
    TRACE1(kbdp, 1, "Error opening scc channel %d", myChannel);
  }
}
  
/*ARGSUSED*/
Sessn kbd_open(self, hlp, parts)
XObj self, hlp;
Part *parts;
{
  register Sessn s;
  TRACE0(kbdp, 3, "kbd_open");

  /* The keyboard is a single-user device; check for conflict */
  
  if (thesession != NULL) {
    TRACE0(kbdp, 1, "Open of busy device, return ERR_SESSN");
    return ERR_SESSN;
  }
  s = x_createsession(hlp, KBD, 1);
  s->numdown = 1;
  s->down[0] = thells;
  thesession = s;

  TRACE1(kbdp, 3, "kbd open returns %x", thesession);
  return thesession;
}

#define LSHIFT_MASK	1
#define RSHIFT_MASK	2
#define CONTROLSESSN_MASK	4
#define LMETA_MASK	8
#define RMETA_MASK	16

#define MODE_NORMAL	0
#define MODE_SHIFT	1

static int mask = 0;
static int mode = MODE_NORMAL;

#define ABORTXX 66
#define ABORT0 1
#define ABORT1 77
static int last = 0;

static char translate[2][128] = {
  {
    /* 0 */ 0, 0, 0, 0, 0, 0, 0, 0,
    /* 8 */ 0, 0, 0, 0, 0, 0, 0, 0,
    /*16 */ 0, 0, 0, 0, 0, 0, 0, 0,
    /*24 */ 0, 0, 0, 0, 0, '\033', '1', '2',
    /*32 */ '3', '4', '5', '6', '7', '8', '9', '0',
    /*40 */ '-', '=', '`', '\010', 0, 0, 0, 0,
    /*48 */ 0, 0, 0, 0, 0, '\011', 'q', 'w', 
    /*56 */ 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p',
    /*64 */ '[', ']', '\177', 0, 0, 0, 0, 0,
    /*72 */ 0, 0, 0, 0, -4, 'a', 's', 'd',
    /*80 */ 'f', 'g', 'h', 'j', 'k', 'l', ';', '\'',
    /*88 */ '\\', '\015', 0, 0, 0, 0, 0, 0,
    /*96 */ 0, 0, 0, -1, 'z', 'x', 'c', 'v',
    /*104*/ 'b', 'n', 'm', ',', '.', '/', -2, '\012',
    /*112*/ 0, 0, 0, 0, 0, 0, 0, 0,
    /*120*/ -8, ' ', -16, 0, 0, 0, 0, 0
  },
  {
    /* 0 */ 0, 0, 0, 0, 0, 0, 0, 0,
    /* 8 */ 0, 0, 0, 0, 0, 0, 0, 0,
    /*16 */ 0, 0, 0, 0, 0, 0, 0, 0,
    /*24 */ 0, 0, 0, 0, 0, '\033', '!', '@',
    /*32 */ '#', '$', '%', '^', '&', '*', '(', ')',
    /*40 */ '_', '+', '~', '\010', 0, 0, 0, 0,
    /*48 */ 0, 0, 0, 0, 0, '\011', 'Q', 'W', 
    /*56 */ 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P',
    /*64 */ '{', '}', '\177', 0, 0, 0, 0, 0,
    /*72 */ 0, 0, 0, 0, -1, 'A', 'S', 'D',
    /*80 */ 'F', 'G', 'H', 'J', 'K', 'L', ':', '"',
    /*88 */ '|', '\015', 0, 0, 0, 0, 0, 0,
    /*96 */ 0, 0, 0, -1, 'Z', 'X', 'C', 'V',
    /*104*/ 'B', 'N', 'M', '<', '>', '?', -1, '\012',
    /*112*/ 0, 0, 0, 0, 0, 0, 0, 0,
    /*120*/ -1, ' ', -1, 0, 0, 0, 0, 0
  }
};
  
/*ARGSUSED*/
kbd_demux(self, s, m)
Sessn s;
Msg m;
{
  register unsigned keycode;
  register unsigned key; 
  register int x;
  keycode = msg_top(m,sizeof(char))[0] & 0xff;
  key = keycode & 0x7f;
  TRACE3(kbdp, 9, "kbd demux: code %x key %x mode %d", keycode, key, mode);
  if (last == ABORT0 && keycode == ABORT1 || keycode == ABORTXX) {
    printf("Abort at who cares where?\n");
#ifdef FOO
    breakpoint();
#endif
  }
  last = keycode;
  if (!thesession) {
    msg_free(m);
    return NULL;
  }
  if (keycode == 0x7f) {
    /* this is an "all up" event */
    mask = 0;
    mode = MODE_NORMAL;
    bzero((char *)down, sizeof down);
    TRACE0(kbdp, 5, "All up");
    msg_free(m);
    return NULL;
  }
  TRACE2(kbdp, 9, "mode = %d key = %x", mode, key);
  x = translate[mode][key];
  TRACE1(kbdp, 5, "x = %x", x);
  if (x < 0) {
    TRACE1(kbdp, 5, "shift key %d", x);
    x = -x;
    if (keycode & 0x80) {
      mask &= ~(x);
    } else {
      mask |= x;
    }
    mode = mask & (LSHIFT_MASK | RSHIFT_MASK) ? MODE_SHIFT : MODE_NORMAL;
    TRACE2(kbdp, 5, "mode %d mask %x", mode, mask);
  } else {
    if (x && (
	(keycode & 0x80) &&
         (!(down[key / sizeof(unsigned)] & (1 << key % sizeof(unsigned)))) ||
	(!(keycode & 0x80)))) {
      /* this is a down event */
      TRACE2(kbdp, 5, "Normal down mask = %x x = %x", mask, x);
      if (keycode & 0x80) {
	down[key / sizeof(unsigned)] &= ~(1 << key % sizeof(unsigned));
	TRACE1(kbdp, 5, "Up without down on %c", x);
      } else {
	down[key / sizeof(unsigned)] |=  (1 << key % sizeof(unsigned));
      }
      if (mask & CONTROLSESSN_MASK) {
	x &= 0x1f;
      }
      if (mask & (LMETA_MASK | RMETA_MASK)) {
	x |= 0x80;
      }
      msg_top(m,sizeof(char))[0] = x;
      return x_demux(thesession, m);
    }
  } 
  msg_free(m);
  return NULL;
}

kbd_close(s)
Sessn s;
{
  TRACE1(kbdp, 3, "kbd close %x", s);
  thesession = NULL;
  s->state = NULL;
  x_destroysession(s);
}

/*ARGSUSED*/
kbd_controlSessn(s, opcode, buf, len)
Sessn	s;
int	opcode, len;
char   *buf;
{
  switch (opcode) {
    default:
        x_errno = INVALID_OPCODE;
        return(-1);
   } 
}

static noop() {}

kbd_getproc(p,type)
XObj p;
XObjType type;
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = kbd_init;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
    p->control = noop;
  } else {
    p->push = noop;
    p->pop = noop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = kbd_close;
    p->control = kbd_controlSessn;
  }
  p->open = (Pfi) kbd_open;
  p->openenable = noop;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = kbd_demux;
  p->getproc = kbd_getproc;
}
