\begin{verbatim}
/*
 * udp_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#define	MAX	(1500 - 24)
#define	HLEN	(sizeof(HDR))
#define	DLEN	(MAX-HLEN)

/* global data for UDP; need data structure for assigned/free port nums */

typedef struct header {
  UDPport         sport;	/* source port */
  UDPport         dport;	/* destination port */
  short           ulen;	/* udp length */
  u_short         sum;	/* udp checksum */
}               HDR;

typedef struct pstate {
  IPaddr          myaddr;
  Map             activemap;
  Map             passivemap;
}               PSTATE;

typedef struct sstate {
  HDR             hdr;
  IPhost          dhost;
  XObj            down_s;
}               SSTATE;

/*
 * The active map is keyed on the pair of ports and the lower level IP
 * session.
 */
typedef struct {
  UDPport         localport;
  UDPport         remoteport;
  Sessn           sessn;
}               ActiveId;

/*
 * The key for the passive map is just the local UDP port number.
 */
typedef UDPport PassiveId;

#define swap_hdr(hdr) { \
  (hdr)->sport = ntohs((hdr)->sport); \
  (hdr)->dport = ntohs((hdr)->dport); \
  (hdr)->ulen  = ntohs((hdr)->ulen); \
}
\end{verbatim}
