/*
 * tableme.h - -me macros table and other explicit troff command strings
 *		Release 1.0a	August 1988
 *		Release 2.0	January 1990
 *
 * Copyright 1988, 1989, 1990  Beverly A.Erlebacher
 * erlebach@cs.toronto.edu    ...uunet!utai!erlebach
 *
 */

/* 
 * miscellaneous commands, described in texi2roff.h 
 */
struct misccmds mecmds = { ".nr _- 0", "\n.pp\n", "\n.ip\n", "", ""};

struct tablerecd metable[] = {
    "@*",		"",	"\n.br\n",	"",	"",	ESCAPED,
    "@.",		"",	"\\&.",		"",	"",	ESCAPED,
    "@:",		"",	"",		"",	"",	ESCAPED,
    "@@",		"",	"@",		"",	"",	ESCAPED,
    "@Arrow",		"\n",	"\\(rh",	"\n",	"",	CHAR,
    "@TeX{",		"}",	"TeX",		"",	"",	INPARA,
    "@appendix",	"\n",	
     "\n.if !\\n(_- \\{\\\n.nr _- 1\n.nr $1 0 1\n.af $1 A\\}\n.bp\n.ds __ ",
     "\n.sh 1 \\*(__ \n.(x \n\\n($1	\\*(__ \n.)x\n","\\fB",	HEADING,
    "@appendixsec",	"\n",	"\n.ds __ ",
	"\n.sh 2 \\*(__ \n.(x \n\\n($1.\\n($2      \\*(__ \n.)x\n",
							"\\fB",	HEADING,
    "@appendixsection",	"\n",	"\n.ds __ ",
	"\n.sh 2 \\*(__ \n.(x \n\\n($1.\\n($2      \\*(__ \n.)x\n",
							"\\fB",	HEADING,
    "@appendixsubsec",	"\n",	"\n.ds __ ",
	"\n.sh 3 \\*(__ \n.(x \n\\n($1.\\n($2.\\n($3    \\*(__ \n.)x\n",
							"\\fB",	HEADING,
    "@appendixsubsubsec","\n",	"\n.ds __ ",
	"\n.sh 4 \\*(__ \n.(x \n\\n($1.\\n($2.\\n($3.\\n($4  \\*(__ \n.)x\n",
							"\\fB",	HEADING,
    "@arrow",		"\n",	"\\(->",	"\n",	"",	CHAR,
    "@asis",		"\n",	"",		"\n",	"",	PARAGRAPH,
    "@asis{",		"}",	"",		"",	"",	INPARA,
    "@author",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@br",		"\n",	"\n.br\n.sp\n", "",	"",	PARAGRAPH,
    "@bullet{",		"}",	"\\(bu",	"",	"",	CHAR,
    "@bye",		"\n",	"",		"\n",	"",	DISCARD,
    "@b{",		"}",	"\\fB",		"",	"\\fB",	INPARA,
    "@c",		"\n",	"",		"\n",	"",	DISCARD,
    "@center",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@center{",		"}",	"\n.ce\n",	"",	"",	HEADING,
    "@chapter",		"\n",	"\n.bp\n.ds __ ",
	"\n.sh 1 \\*(__ \n.(x \n\\n($1	\\*(__ \n.)x\n","\\fB",	HEADING,
    "@cindex",		"\n",	"\n.iX \"c ",	"\"\n",	"",	INDEX,
    "@cite{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@code{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@comment",		"\n",	"",		"\n",	"",	DISCARD,
    "@contents",	"\n",	"\n.nr % 0 1\n.af % i\n.bp \\n%+1\n",
	".ce\n\\fBTable of Contents\\fR\n.sp 2\n.xp \n","",INPARA,
    "@copyright{",	"}",	"\\(co",	"",	"",	CHAR,
    "@ctrl{",		"}",	"\\fR\\&\\f(CW^","","\\fR\\&\\f(CW",INPARA,
    "@dag",		"}{",	"\\(dg",	"",	"",	CHAR,
    "@dag{",		"}",	"\\(dg",	"",	"",	CHAR,
    "@ddag",		"}{",	"\\(dd",	"",	"",	CHAR,
    "@ddag{",		"}",	"\\(dd",	"",	"",	CHAR,
    "@defcmd",		"@end", "\n.lp\n*\\ Command: ","","",	HEADING,
    "@defcmdx",		"\n", 	"\n.lp\n*\\ Command: ","\n.br\n","",HEADING,
    "@defconst",	"@end", "\n.lp\n*\\ Constant: ","","",	HEADING,
    "@defconstx",	"\n", 	"\n.lp\n*\\ Constant: ","\n.br\n","",HEADING,
    "@deffn",		"@end", "\n.lp\n*\\ ",	"",	"",	HEADING,
    "@deffnx",		"\n", 	"\n.lp\n*\\ ",	"\n.br\n","",	HEADING,
    "@defmac",		"@end", "\n.lp\n*\\ Macro: ","","",	HEADING,
    "@defmacx",		"\n", 	"\n.lp\n*\\ Macro: ","\n.br\n","",HEADING,
    "@defmethod",	"@end", "\n.lp\n*\\ Operation on ","","",HEADING,
    "@defmethodx",	"\n", 	"\n.lp\n*\\ Operation on ","\n.br\n",
							"",	HEADING,
    "@defopt",		"@end", "\n.lp\n*\\ User Option: ","","",HEADING,
    "@defoptx",		"\n", 	"\n.lp\n*\\ User Option: ","\n.br\n",
							"",	HEADING,
    "@defspec",		"@end", "\n.lp\n*\\ Special Form: ","","",HEADING,
    "@defspecx",	"\n", 	"\n.lp\n*\\ Special Form: ","\n.br\n",
							"",	HEADING,
    "@defun",		"@end", "\n.lp\n*\\ Function: ","","",	HEADING,
    "@defunx",		"\n", 	"\n.lp\n*\\ Function: ","\n.br\n","",HEADING,
    "@defvar",		"@end", "\n.lp\n*\\ Variable: ","","",	HEADING,
    "@defvarx",		"\n", 	"\n.lp\n*\\ Variable: ","\n.br\n","",HEADING,
    "@dfn{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@display",		"@end", "\n.(l I\n",	"\n.)l\n","",	DISPLAY,
    "@dots{",		"}",	"\\&...",	"",	"",	INPARA,
    "@eject",		"\n",	"\n.bp\n",	"",	"",	PARAGRAPH,
    "@emph{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@end",		"\n",	"",	"\n.sp\n.in\n", "",	END,
    "@enumerate",	"@end", "\n.(l L F\n.ba +5\n",
					"\n.ba -5\n.)l\n","",	ITEMIZING,
    "@equiv{",		"}",	"\\(==",	"",	"",	CHAR,
    "@error{",		"}",	"error->",	"",	"",	CHAR,
    "@example",		"@end", "\n.(l I\n\\fR\\&\\f(CW\n",
				"\n.)l\n","\\fR\\&\\f(CW",	DISPLAY,
    "@example{",	"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@exdent",		"\n",	"\n.lp\n",	"\n",	"",	PARAGRAPH,
    "@expansion{",	"}",	"\\(->",	"",	"",	CHAR,
    "@file{",		"}",	"\\fR\\&\\f(CW\\(if",
				"\\(is","\\fR\\&\\f(CW",	INPARA,
    "@finalout",	"\n",	"",		"\n",	"",	DISCARD,
    "@findex",		"\n",	"\n.iX \"f ",	"\"\n",	"",	INDEX,
    "@footnote{",	"}",	"\n.(f \n",	"\n.)f\n","",	FOOTNOTE,
    "@group",		"@end", "\n.(b\n",	"\n.)b\n","",	PARAGRAPH,
    "@heading",		"\n",	"\n.bp\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@headings",	"\n",	"",		"",	"",	DISCARD,
    "@iappendix",	"\n",	"\n.bp\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@iappendixsec",	"\n",	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@iappendixsubsec",	"\n",	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@ichapter",	"\n",	"\n.bp\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@ifinfo",		"@end", "\n",		"\n",	"",	PARAGRAPH, 
    "@iftex",		"@end", "",		"",	"",	PARAGRAPH,
    "@ignore",		"@end", "",		"",	"",	DISCARD,
    "@include",		"\n",	"",		"",	"",	INCLUDE,
    "@inforef{",	"}",	"See Info file ","",	"",	PARAGRAPH,
    "@isection",	"\n", 	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@isubsection",	"\n", 	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@isubsubsection",	"\n", 	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@item",		"\n",	"\n.ip ",	"\\ \n","",	ITEM,
    "@itemize",		"@end", "\n.(l L F\n.ba +5\n",
					"\n.ba -5\n.)l\n","",	ITEMIZING,
    "@itemx",		"\n",	"\n.ip ",	"\\ \n","",	ITEM,
    "@iunnumbered",	"\n", 	"\n.bp\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@iunnumberedsec",	"\n", 	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@iunnumberedsubsec","\n", 	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@i{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@kbd{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@key{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@kindex",		"\n",	"\n.iX \"k ",	"\"\n",	"",	INDEX,
    "@majorheading",	"\n",	"\n.sp 4\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@menu",		"@end", "\n.(l I\n\\s8Menu: \n",
					"\\s0\n.)l\n","",	DISPLAY,
    "@minus{",		"}",	"\\-",		"",	"",	CHAR,
    "@need",		"\n",	"",		"\n",	"",	DISCARD,
    "@node",		"\n", 	"\n.lp\n\\s8Node:",
					"\\s0\n.br\n","",	PARAGRAPH,
    "@noindent",	"\n",	"\n.lp\n",	"",	"",	PARAGRAPH,
    "@page",		"\n",	"\n.bp\n",	"",	"",	PARAGRAPH,
    "@pindex",		"\n",	"\n.iX \"p ",	"\"\n",	"",	INDEX,
    "@point{",		"}",	"*",		"",	"",	CHAR,
    "@printindex",	"\n",	"",		"\n",	"",	DISCARD,
    "@prints{",		"}",	"-|",		"",	"",	CHAR,
    "@print{",		"}",	"-|",		"",	"",	CHAR,
    "@pxref{",		"}",	"see section  ","",	"",	PARAGRAPH,
    "@quotation",	"@end", "\n.(q\n.nh\n", "\n.)q\n","",	DISPLAY,
    "@refill",		"\n",	"",		"\n",	"",	DISCARD,
    "@ref{",		"}",	"\\(if",	"\\(is","",	INPARA,
    "@result",		"\n",	"\\(rh",	"\n",	"",	CHAR,
    "@result{",		"}",	"\\(rh",	"",	"",	CHAR,
    "@r{",		"}",	"\\fR",		"",	"\\fR",	INPARA,
    "@samp{",		"}",	"\\fR\\&\\f(CW\\(if", "\\(is",
						"\\fR\\&\\f(CW",INPARA,
    "@sc{",		"}",	"\\fB",		"",	"\\fB",	INPARA,
    "@section",		"\n",	"\n.ds __ ",
     "\n.sh 2 \\*(__ \n.(x \n\\n($1.\\n($2      \\*(__ \n.)x\n",
							"\\fB",	HEADING,
    "@setchapternewpage","\n",	"",		"\n",	"",	DISCARD,
    "@setfilename",	"\n",	"",		"\n",	"",	DISCARD,
    "@settitle",	"\n",	"\n.ds St ",
		"\n.oh '\\\\*(St''%'\n.eh '%''\\\\*(St'\n","",	HEADING,
    "@smallbook",	"\n",	"",		"",	"",	DISCARD,
    "@smallexample",	"@end", "\n.(l I\n\\fR\\&\\f(CW\n",
				"\n.)l\n",	"\\fR\\&\\f(CW",DISPLAY,
    "@sp",		"\n",	"\n.sp",	"\n",	"",	PARAGRAPH,
    "@sp2",		"\n",	"\n.sp 2",	"\n",	"",	PARAGRAPH,
    "@strong{",		"}",	"\\fB",		"",	"\\fB",	INPARA,
    "@subheading",	"\n",	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@subsection",	"\n",	"\n.ds __ ",
	"\n.sh 3 \\*(__ \n.(x \n\\n($1.\\n($2.\\n($3    \\*(__ \n.)x\n",
							"\\fB",	HEADING,
    "@subsubheading",	"\n",	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@subsubsection",	"\n",	"\n.ds __ ",
      "\n.sh 4 \\*(__ \n.(x \n\\n($1.\\n($2.\\n($3.\\n($4  \\*(__ \n.)x\n",
							"\\fB",	HEADING,
    "@subtext",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@subtitle",	"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@summarycontents",	"\n",	"\n.nr % 0 1\n.af % i\n.bp \\n%+1\n",
	".ce\n\\fBTable of Contents\\fR\n.sp 2\n.xp \n","",	INPARA,
    "@syncodeindex",	"\n",	"",		"\n",	"",	DISCARD,
    "@synindex",	"\n",	"",		"\n",	"",	DISCARD,
    "@t",		"\n",	"\t",		"\n",	"",	CHAR,
    "@table",		"@end", "\n.(l L F\n.ba +5\n",
					"\n.ba -5\n.)l\n","",	ITEMIZING,
    "@tex",		"@end", "",		"",	"",	DISCARD, 
    "@tindex",		"\n",	"\n.iX \"t ",	"\"\n",	"",	INDEX,
    "@title",		"\n",	"\n.ce\n",	"\n",	"",	HEADING,
    "@titlefont{",	"}",	"\n.sz +10\n.ce\n",
						"\n.sz -10\n","",PARAGRAPH,
    "@titlepage",	"@end", "\n.tp\n",	"\n.bp\n","",	PARAGRAPH,
    "@titlespec",	"@end", "\n.tp\n.ce \n\\&\\*(St \n",
						"\n",	"",	PARAGRAPH,
    "@t{",		"}",	"\\fR\\&\\f(CW","","\\fR\\&\\f(CW",INPARA,
    "@unnumbered",	"\n",	"\n.bp\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@unnumberedsec",	"\n",	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@unnumberedsubsec","\n",	"\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@unnumberedsubsubsec","\n","\n.ds __ ",
		"\n.(x \n\\*(__ \n.)x\n.uh  \\*(__ \n","\\fB",	HEADING,
    "@var{",		"}",	"\\fI",		"",	"\\fI",	INPARA,
    "@vfil", 		"\n",	"",		"\n",	"",	DISCARD,
    "@vindex",		"\n",	"\n.iX \"v ",	"\"\n",	"",	INDEX,
    "@vskip",		"\n",	"",		"\n",	"",	DISCARD,
    "@w{",		"}",	"\n\\! ",	"\n",	"",	INPARA,
    "@xref{",		"}",	"See section ",	"",	"",	PARAGRAPH,
    "@{",		"",	"{",		"",	"",	ESCAPED,
    "@}",		"",	"}",		"",	"",	ESCAPED
};

