/* private fake-ldap layer to access AA0 */

#ifndef __
# ifdef __STDC__
#  define __(x) x
# else
#  define __(x) ()
#  define const
#  define volatile
#  define void
# endif
#endif


#define LDAP_SCOPE_BASE 0
#define LDAP_SCOPE_ONELEVEL 1
#define LDAP_SCOPE_SUBTREE 2

#define LDAP_SUCCESS 0

#define LDAP_PORT 0

#define LDAP_FILT_MAXSIZ 1024

typedef struct _LDAP {
  void *dummy;
} LDAP;

typedef struct _LDAPMessage {
  char *result;
} LDAPMessage;

extern LDAP * ldap_open __((const char *host, int port));
extern int    ldap_simple_bind_s __((LDAP *ld, char *binddn, char *passwd));
extern int    ldap_search_s __((LDAP *ld, char *base, int scope,
				char *filter, char **attrs, int,
				LDAPMessage **msgp));
extern LDAPMessage * ldap_first_entry __((LDAP *ld, LDAPMessage *msg));
extern char ** ldap_get_values __((LDAP *ld, LDAPMessage *entry, char *attr));
extern void    ldap_value_free __((char **vals));
extern void    ldap_msgfree    __((LDAPMessage *msg));
extern void ldap_unbind_s __((LDAP *ld));
