#!/bin/sh

#
#  Post-Installation script to complete the installation process.
#
#  - To move into place (conditionally) various prototype files
#  - To fill in configuration information into MAILSHARE/db/
#    files, if nothing in there t0 begin with...
#

# - MAILSHARE/forms/proto       --> MAILSHARE/forms (conditionally)
# - MAILSHARE/proto/*.{conf,cf} --> MAILSHARE/      (conditionally)
# - MAILVAR/db/proto/*          --> MAILVAR/db/     (conditionally)


ZCONFIG=/etc/zmailer.conf
MKDIR="mkdir -p"

. $ZCONFIG

while [ "$1" != "" ]
do
	echo "post-install.sh: param: $1"
	shift
done

# exit 99 # Sorry, not yet!

pwd=`pwd`

if [ ! -d $MAILSHARE/bak ]; then $MKDIR $MAILSHARE/bak ; fi

# ----------------------------
#    MAILSHARE/forms/

cd $MAILSHARE/forms/proto
for x in *
do
    if [ ! -f ../$x ] ; then
	mv $x ..
    else
	echo "=== $MAILSHARE/forms/$x  exists, not overwritten!"
    fi
done

# ----------------------------
#    MAILSHARE/

cd $MAILSHARE/proto
for x in *
do
    if [ ! -f ../$x ] ; then
	mv $x ..
    else
	echo "=== $MAILSHARE/$x  exists, not overwritten!"
    fi
done

# ----------------------------
#    MAILVAR/db/

cd $MAILVAR/db/proto
for x in *
do
    if [ ! -f ../$x ] ; then
	mv $x ..
    else
	echo "=== $MAILVAR/db/$x  exists, not overwritten!"
    fi
done

# ----------------------------
#    Database prototypes ???

for x in $MAILSHARE/proto/router.cf $MAILSHARE/proto/scheduler.conf \
	 $MAILSHARE/proto/smtpserver.conf $MAILSHARE/proto/sm.conf  \
	 $MAILVAR/db/proto/aliases $MAILVAR/db/proto/localnames     \
	 $MAILVAR/db/proto/fqdnaliases $MAILVAR/db/proto/routes	    \
	 $MAILVAR/db/proto/smtp-policy.src $MAILVAR/db/proto/smtp-policy.mx \
	 $MAILVAR/db/proto/smtp-policy.relay
do
    y=`echo $x | sed -e 's!/proto/!/!'`
    if [ -f $x ] ; then
	cmp -s $x $y && echo "*** Verify  $y  file!"
    fi
done

$MAILBIN/zmailer newdb

$MAILBIN/policy-builder.sh -n

cat <<EOF
***
*** Remember to verify input databases, and then execute commands:
***    $MAILBIN/zmailer newdb
***    $MAILBIN/policy-builder.sh (-n)
***
EOF
